/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.OrderForPos;
import com.efuture.business.javaPos.struct.request.CountAllIn;
import com.efuture.business.javaPos.struct.wslf.request.QueryAllReqDef;
import com.efuture.business.javaPos.struct.wslf.request.WSLFMemberConfirmIn;
import com.efuture.business.javaPos.struct.wslf.response.QueryAllRevDef;
import com.efuture.business.javaPos.struct.wslf.response.VipLoginProcessOut;
import com.efuture.business.service.CalcPopRemoteService;
import com.efuture.business.service.impl.VipSaleBSImpl;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.WslfVipTools;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ServiceSession;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;

public class VipSaleBSImpl_WSLF
extends VipSaleBSImpl {
    private static final Logger log = LoggerFactory.getLogger(VipSaleBSImpl_WSLF.class);
    @SoaAnnotation(value="/apiCalcPopRemoteService.do")
    private CalcPopRemoteService calcPopRemoteService;
    @Autowired
    WslfVipTools wslfVipTools;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    @Qualifier(value="jdbcTemplate")
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private DbTools dbTools;
    @Value(value="${java_findcusthas}")
    private String java_findcusthas;
    @Value(value="${java_findcusthasIn}")
    private String java_findcusthasIn;
    @Value(value="${java_findcusthasOut}")
    private String java_findcusthasOut;
    private String dataCharacter = "ISO8859_1#GBK";
    String dataSource = "wshyDataSource";

    public RespBase login(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"custType") || paramsObject.getString("custType").isEmpty()) {
            return new RespBase(Code.CODE_40005.getIndex(), "\u4f1a\u5458\u767b\u9646\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4f1a\u5458\u7c7b\u522b]");
        }
        if (!paramsObject.containsKey((Object)"consumersCard") || paramsObject.getString("consumersCard").isEmpty()) {
            return new RespBase(Code.CODE_40005.getIndex(), "\u4f1a\u5458\u767b\u9646\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4f1a\u5458\u53f7]");
        }
        String ct = paramsObject.getString("custType");
        if ("1".equals(ct)) {
            return this.login1(session, vo, paramsObject);
        }
        if ("2".equals(ct)) {
            return this.login2(session, vo, paramsObject);
        }
        return new RespBase(Code.CODE_40005.getIndex(), "\u4f1a\u5458\u7c7b\u522b\u4e0d\u5b58\u5728!");
    }

    public RespBase login1(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ConsumersData custData;
        log.info("login1 ==>{}", (Object)paramsObject.toJSONString());
        WSLFMemberConfirmIn paraIn = (WSLFMemberConfirmIn)JSONObject.toJavaObject((JSON)paramsObject, WSLFMemberConfirmIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u7f13\u5b58\u5df2\u5931\u6548");
        }
        String flowNo = paramsObject.getString("flowNo");
        Order order = cacheModel.getOrder();
        if (paraIn.getCertifyType() != null && paraIn.getCertifyType().equalsIgnoreCase("CANCEL") && StringUtils.isNotBlank((String)flowNo)) {
            boolean isMaotai = false;
            for (Goods sg : cacheModel.getGoodsList()) {
                if (!"32".equals(sg.getGoodsType())) continue;
                isMaotai = true;
                break;
            }
            if (isMaotai) {
                return Code.CODE_40006.getRespBase(new Object[0]);
            }
            order = cacheModel.getOrder();
            order.setTotalPoint(0.0);
            order.setThisTimePoint(0.0);
            order.setConsumersData(null);
            cacheModel.setOrder(order);
            vo.setCacheModel(cacheModel);
            if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0 && !SellType.isGroupbuy((String)order.getOrderType())) {
                cacheModel = this.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, vo);
            }
            log.info("\u4f1a\u5458\u767b\u51fa\u51fa\u53c2\uff1a[{}]", (Object)JSONObject.toJSONString((Object)cacheModel));
            RespBase rep = new RespBase();
            rep.setRetflag(0);
            rep.setData((Object)cacheModel);
            return rep;
        }
        VipLoginProcessOut vipProcessOut = null;
        if (null == flowNo || "".equals(flowNo)) {
            String jsonIn = JSON.toJSONString((Object)new JSONObject().put("vcode", (Object)paraIn.getConsumersCard()));
            vipProcessOut = this.findVipStatus(jsonIn, this.dataSource);
            log.info("\u4f1a\u5458\u8ba4\u8bc1\u51fa\u53c21==>{}", (Object)vipProcessOut);
            if (vipProcessOut.getRet() == 1) {
                BaseOutModel out = new BaseOutModel();
                OrderForPos ofs = new OrderForPos();
                ConsumersData custData2 = new ConsumersData();
                if (StringUtils.isBlank((String)vipProcessOut.getRcode())) {
                    return new RespBase(Code.CODE_40001, cacheModel.getFlowNo());
                }
                custData2.setConsumersCard(vipProcessOut.getRcode());
                custData2.setConsumersId(vipProcessOut.getRcode());
                custData2.setConsumersCName(vipProcessOut.getRname());
                if (StringUtils.isNotBlank((String)vipProcessOut.getRzkl()) && !"0".equals(vipProcessOut.getRzkl())) {
                    custData2.setConsumersType("\u5de5\u4f1a\u5361");
                    custData2.setGrantCard(custData2.getConsumersCard());
                    custData2.setZkl(CastUtil.castDouble((Object)vipProcessOut.getRzkl()) / 100.0);
                } else {
                    custData2.setConsumersType("\u8d85\u5e02\u5361");
                }
                custData2.setConsumsersStatus(vipProcessOut.getRvalue4());
                custData2.setPoint(Double.valueOf(vipProcessOut.getRvalue1()) / 100.0);
                ofs.setTotalPoint(Double.valueOf(vipProcessOut.getRvalue1()) / 100.0);
                ofs.setPointCardNo(vipProcessOut.getRcode());
                custData2.setCustType(paraIn.getCustType());
                ofs.setConsumersData(custData2);
                out.setOrder(ofs);
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                log.info("\u67e5\u627e\u4f1a\u5458\u51fa\u53c2:" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "MEMBERLOGIN")));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "MEMBERLOGIN");
            }
            return new RespBase(Code.CODE_40000, "\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25!");
        }
        if ("Y12".equals(cacheModel.getOrder().getOrderType())) {
            for (Goods sg : cacheModel.getGoodsList()) {
                if (!(sg.getElectronicStamp() > 0.0) && !(sg.getPhysicalStamp() > 0.0)) continue;
                return new RespBase(Code.CODE_40000, "\u5df2\u5b58\u5728\u6362\u8d2d\u4e0d\u5141\u8bb8\u518d\u5237\u4f1a\u5458\u5361!");
            }
        }
        if (order.getStaffSale()) {
            return new RespBase(Code.CODE_40000, "\u5df2\u5237\u5458\u5de5\u5361\u4e0d\u5141\u8bb8\u5237\u4f1a\u5458\u5361!");
        }
        try {
            JSONObject ino = new JSONObject();
            ino.put("vcode", (Object)paraIn.getConsumersCard());
            String jsonIn = JSON.toJSONString((Object)ino);
            vipProcessOut = this.findVipStatus(jsonIn, this.dataSource);
            log.info("\u4f1a\u5458\u8ba4\u8bc1\u51fa\u53c22==>{}", JSONObject.toJSON((Object)vipProcessOut));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RespBase(Code.CODE_40000.getIndex(), "\u4f1a\u5458\u767b\u5f55\u5931\u8d25!", null, "WSLFVIPLOGIN");
        }
        if (vipProcessOut.getRet() == 1) {
            BaseOutModel out = new BaseOutModel();
            OrderForPos ofs = new OrderForPos();
            custData = new ConsumersData();
            if (StringUtils.isBlank((String)vipProcessOut.getRcode())) {
                return new RespBase(Code.CODE_40001, cacheModel.getFlowNo());
            }
            custData.setConsumersCard(vipProcessOut.getRcode());
            custData.setConsumersId(vipProcessOut.getRcode());
            custData.setConsumersCName(vipProcessOut.getRname());
            custData.setConsumsersStatus(vipProcessOut.getRvalue4());
            custData.setPoint(CastUtil.castDouble((Object)vipProcessOut.getRvalue1()) / 100.0);
            if (StringUtils.isNotBlank((String)vipProcessOut.getRzkl()) && !"0".equals(vipProcessOut.getRzkl())) {
                if (null != cacheModel.getOrder().getConsumersData() && StringUtils.isNotBlank((String)cacheModel.getOrder().getConsumersData().getConsumersId())) {
                    custData = cacheModel.getOrder().getConsumersData();
                } else {
                    custData.setConsumersType("\u5de5\u4f1a\u5361");
                    order.setTotalPoint(CastUtil.castDouble((Object)vipProcessOut.getRvalue1()) / 100.0);
                    order.setPointCardNo(vipProcessOut.getRcode());
                }
                custData.setGrantCard(vipProcessOut.getRcode());
                custData.setZkl(CastUtil.castDouble((Object)vipProcessOut.getRzkl()) / 100.0);
            } else {
                order.setTotalPoint(CastUtil.castDouble((Object)vipProcessOut.getRvalue1()) / 100.0);
                order.setPointCardNo(vipProcessOut.getRcode());
                custData.setConsumersType("\u8d85\u5e02\u5361");
            }
            if (null != cacheModel.getOrder().getConsumersData() && cacheModel.getOrder().getConsumersData().getZkl() < 1.0) {
                custData.setGrantCard(cacheModel.getOrder().getConsumersData().getGrantCard());
                custData.setZkl(cacheModel.getOrder().getConsumersData().getZkl());
            }
        } else {
            return new RespBase(Code.CODE_40000, "\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25!");
        }
        order.setConsumersData(custData);
        cacheModel.setOrder(order);
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0 && !SellType.isGroupbuy((String)order.getOrderType())) {
            try {
                vo.setCacheModel(cacheModel);
                cacheModel = this.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, vo);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("\u4f1a\u5458\u8c03\u7528\u5355\u884c\u8ba1\u7b97\u5f02\u5e38:" + e);
            }
            if (cacheModel.getCalcResult() == -1) {
                String errCode = "100000";
                if (cacheModel.getErrCode().length() > 0) {
                    errCode = cacheModel.getErrCode();
                }
                return new RespBase(Code.CODE_40000, errCode + cacheModel.getErrMsg());
            }
        }
        log.info("\u4f1a\u5458\u4fe1\u606f\uff1a[{}]", (Object)JSONObject.toJSONString((Object)cacheModel.getOrder().getConsumersData()));
        RespBase rep = new RespBase();
        rep.setRetflag(0);
        rep.setData((Object)cacheModel);
        return rep;
    }

    public RespBase login2(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        log.info("login2 ==>{}", (Object)paramsObject.toJSONString());
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        String flowNo = paramsObject.getString("flowNo");
        Order order = cacheModel.getOrder();
        if (null != paramsObject.getString("certifyType") && "CANCEL".equalsIgnoreCase(paramsObject.getString("certifyType")) && StringUtils.isNotBlank((String)flowNo)) {
            boolean isMaotai = false;
            for (Goods sg : cacheModel.getGoodsList()) {
                if (!"32".equals(sg.getGoodsType())) continue;
                isMaotai = true;
                break;
            }
            if (isMaotai) {
                return Code.CODE_40006.getRespBase(new Object[0]);
            }
            order = cacheModel.getOrder();
            order.setTotalPoint(0.0);
            order.setThisTimePoint(0.0);
            order.setConsumersData(null);
            cacheModel.setOrder(order);
            if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
                vo.setCacheModel(cacheModel);
                if (!SellType.isGroupbuy((String)order.getOrderType())) {
                    cacheModel = this.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, vo);
                }
            }
            RespBase rep = new RespBase();
            rep.setRetflag(0);
            rep.setData((Object)cacheModel);
            return rep;
        }
        String jthy = "";
        try {
            ConsumersData custData;
            String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            jthy = this.wslfVipTools.getJTHYCode(modeDetailsVo);
            log.info("JTHY{}", (Object)jthy);
            if ("".equals(jthy)) {
                return new RespBase(Code.CODE_60.getIndex(), "\u672a\u914d\u7f6e\u96c6\u56e2\u4f1a\u5458IP\u7aef\u53e3\u53c2\u6570", vo.getCacheModel().getFlowNo());
            }
            GlobalInfo.setWslfvipIp((String)jthy.split(":")[0]);
            GlobalInfo.setWslfvipPort((int)Integer.valueOf(jthy.split(":")[1]));
            QueryAllReqDef vipquery = new QueryAllReqDef(paramsObject);
            log.info("\u96c6\u56e2\u4f1a\u5458\u5165\u53c2{}", (Object)vipquery.toString());
            QueryAllRevDef queryAllRevDef = this.wslfVipTools.viplogin(vipquery);
            log.info("\u96c6\u56e2\u4f1a\u5458\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)queryAllRevDef));
            if ("0".equals(queryAllRevDef.getResult())) {
                custData = new ConsumersData();
                custData.setConsumersCardNOECP(vipquery.getCardNOECP());
                custData.setConsumersCard(queryAllRevDef.getCardNo());
                custData.setConsumersCName(queryAllRevDef.getMemberName());
                custData.setConsumersType("GRP");
                custData.setConsumersLevel(queryAllRevDef.getBranchGrade());
                custData.setPointMoney(Double.valueOf(queryAllRevDef.getAMT()).doubleValue());
                custData.setPoint(Double.valueOf(queryAllRevDef.getCompanyPoint()).doubleValue());
                custData.setCustType(paramsObject.getString("custType"));
                if (null != cacheModel.getOrder().getConsumersData() && cacheModel.getOrder().getConsumersData().getZkl() < 1.0) {
                    custData.setGrantCard(cacheModel.getOrder().getConsumersData().getGrantCard());
                    custData.setZkl(cacheModel.getOrder().getConsumersData().getZkl());
                }
            } else {
                return new RespBase(Code.CODE_40000.getIndex(), queryAllRevDef.getPoint(), null, "WSLFVIPLOGIN");
            }
            order.setTotalPoint(Double.valueOf(queryAllRevDef.getCompanyPoint()).doubleValue());
            order.setTrackNo(vipquery.getCardNOECP());
            order.setConsumersData(custData);
        }
        catch (Exception e) {
            log.info("[\u4f1a\u5458\u5165\u53c2\u4fe1\u606f\u8f6c\u6362\u5f02\u5e38]");
            e.printStackTrace();
            return new RespBase(Code.CODE_40000.getIndex(), "\u4f1a\u5458\u767b\u5f55\u5931\u8d25!", null, "WSLFVIPLOGIN");
        }
        cacheModel.setOrder(order);
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0 && !SellType.isGroupbuy((String)order.getOrderType())) {
            vo.setCacheModel(cacheModel);
            try {
                cacheModel = this.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, vo);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("\u4f1a\u5458\u8c03\u7528\u5355\u884c\u8ba1\u7b97\u5f02\u5e38:" + e);
            }
            if (cacheModel.getCalcResult() == -1) {
                String errCode = "100000";
                if (cacheModel.getErrCode().length() > 0) {
                    errCode = cacheModel.getErrCode();
                }
                return new RespBase(Code.CODE_40000, errCode + cacheModel.getErrMsg());
            }
        }
        log.info("\u4f1a\u5458\u4fe1\u606f\uff1a[{}]", (Object)JSONObject.toJSONString((Object)cacheModel.getOrder().getConsumersData()));
        RespBase rep = new RespBase();
        rep.setRetflag(0);
        rep.setData((Object)cacheModel);
        return rep;
    }

    public RespBase CustomerPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        return null;
    }

    public RespBase SaleCorrect(ServiceSession session, ResqVo rvo, JSONObject paramsObject) {
        return null;
    }

    public RespBase CardClear(ServiceSession session, ResqVo rvo, JSONObject paramsObject) {
        return null;
    }

    private CacheModel calcOrderPop(ServiceSession session, String calcMode, CacheModel cacheModel, ResqVo vo, JSONObject paramsObject) {
        RespBase resp = new RespBase();
        CountAllIn countAllIn = new CountAllIn();
        countAllIn = (CountAllIn)countAllIn.transfer(paramsObject);
        countAllIn.setCalcMode(calcMode);
        List limitedPayCodes = CountAllIn.gainLimitedPayCodes((CacheModel)cacheModel, (CountAllIn)countAllIn);
        countAllIn.setLimitedPayCodes(limitedPayCodes);
        try {
            countAllIn = (CountAllIn)JSON.parseObject((String)paramsObject.toJSONString(), CountAllIn.class);
        }
        catch (Exception e) {
            resp.setData((Object)cacheModel);
            log.info("\u4f1a\u5458\u6574\u5355\u8ba1\u7b97\u5165\u53c2\u8f6c\u6362\u5f02\u5e38CountAllIn ==>{}", (Object)e.toString());
        }
        RespBase respBase = null;
        try {
            respBase = this.calcPopRemoteService.calcAllPop(session, vo, countAllIn);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4f1a\u5458\u8c03\u7528\u6574\u5355\u8ba1\u7b97\u5f02\u5e38:" + e);
        }
        ResqVo resqVo = (ResqVo)respBase.getData();
        cacheModel = resqVo.getCacheModel();
        return cacheModel;
    }

    public VipLoginProcessOut findVipStatus(String json, String dataSource) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc(dataSource));
        log.info("vip_dataSource\uff1a" + dataSource);
        log.info("vip_processIn\uff1a" + json);
        HashMap ropValue = (HashMap)this.jdbcTemplate.execute((CallableStatementCreator)new /* Unavailable Anonymous Inner Class!! */, (CallableStatementCallback)new /* Unavailable Anonymous Inner Class!! */);
        log.info("vip_processOut:" + ropValue);
        String retcode = "";
        if (ropValue != null && ropValue.get("ret") != null) {
            retcode = String.valueOf(ropValue.get("ret"));
        }
        VipLoginProcessOut vipProOut = new VipLoginProcessOut();
        try {
            DbTools.ConvertToObjectNoTranscoding((Object)vipProOut, (HashMap)ropValue, (String[])VipLoginProcessOut.ref);
        }
        catch (Exception e) {
            vipProOut.setRet(1);
            vipProOut.setRvalue5(e.toString());
            log.info("Return convert to Bean error:" + e.toString());
        }
        MultipleDataSource.clearDataSource();
        return vipProOut;
    }

    public RespBase giveOrReverse(ServiceSession session, ResqVo rvo, JSONObject paramsObject) {
        return null;
    }

    static /* synthetic */ String access$000(VipSaleBSImpl_WSLF x0) {
        return x0.java_findcusthas;
    }

    static /* synthetic */ String access$100(VipSaleBSImpl_WSLF x0) {
        return x0.java_findcusthasIn;
    }

    static /* synthetic */ String access$200(VipSaleBSImpl_WSLF x0) {
        return x0.java_findcusthasOut;
    }

    static /* synthetic */ String access$300(VipSaleBSImpl_WSLF x0) {
        return x0.dataCharacter;
    }

    static /* synthetic */ DbTools access$400(VipSaleBSImpl_WSLF x0) {
        return x0.dbTools;
    }

    static /* synthetic */ Logger access$500() {
        return log;
    }
}

