/**
 * Copyright © 2019 e-future. All rights reserved.
 *
 * @Title: SDKConfig.java
 * @Prject: efuture-posSV-service
 * @Package: com.efuture.pos.util.rsa
 * @Description: TODO
 * @author: yincan
 * @date: 2019年7月5日 下午3:12:14
 * @version: V1.0
 */
package com.efuture.business.local;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;



/**
 * @Description: 密钥配置文件
 * @author: yincan
 * @date: 2019年7月5日 下午3:12:14
 */
@Component("ZBRSAConfig")
//@Configuration
//@PropertySource(name = "ZBRSAConfig", value = "classpath:application-whzb.yml")
@ConfigurationProperties(prefix = "zhongbai")
@PropertySource(value = "classpath:application-whzb.yml")
public class ZBRSAConfig {

    // private static final Logger logger =
    // LoggerFactory.getLogger(SDKConfig.class);

    /**
     * 版本号 默认1.0
     */
    @Value("${version}") private String version;

    /**
     * 传入字符集 默认UTF-8
     */
    @Value("${inCharSet}") private String inCharSet;

    /**
     * 回传字符集 默认UTF-8
     */
    @Value("${OutCharSet}") private String OutCharSet;

    /**
     * 商户号--平台分配商户号，针对需支付公司
     */
    @Value("${mcId}") private String mcId;

    /**
     * 接入商--平台分配接入商，针对接入来源用于RSA加/解密
     */
    @Value("${pactId}") private String pactId;

    /**
     * 加密方式
     */
    @Value("${signMethod}") private String signMethod;

    /**
     * RSA私钥路劲
     */
    @Value("${RSAPrivateKey}") private String RSAPrivateKey = "";
    /**
     * RSA公钥路劲
     */

    @Value("${RSAPublicKey}") private String RSAPublicKey = "";

    /** socket通信ip */
    //	private String socketIp;

    /**socket通信port */
    //	private int socketPort;

    /**
     * socket通信机构编码
     */
    @Value("${branCode}") private String branCode;
    /** 方法路由，1--http请求 ，2--socket请求*/
    //	private String MethodRouter;

    /**
     * socket超时时间
     */
    @Value("${SocketTimeout}") private int SocketTimeout;

    /**
     * head签名标志.
     */
    public static final String param_signature = "X-Sign";

    /**
     * 参数赋值标记
     */
    public static final String EQUAL = "=";

    /**
     * 参数拼接标记
     */
    public static final String AMPERSAND = "&";

    public String getSignMethod() {
        return signMethod;
    }

    public void setSignMethod(String signMethod) {
        this.signMethod = signMethod;
    }

    public static String getParam_signature() {
        return param_signature;
    }

    public static String getEQUAL() {
        return EQUAL;
    }

    public static String getAMPERSAND() {
        return AMPERSAND;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getInCharSet() {
        return inCharSet;
    }

    public void setInCharSet(String inCharSet) {
        this.inCharSet = inCharSet;
    }

    public String getOutCharSet() {
        return OutCharSet;
    }

    public void setOutCharSet(String outCharSet) {
        OutCharSet = outCharSet;
    }

    public String getMcId() {
        return mcId;
    }

    public void setMcId(String mcId) {
        this.mcId = mcId;
    }

    public String getPactId() {
        return pactId;
    }

    public void setPactId(String pactId) {
        this.pactId = pactId;
    }

    public String getRSAPrivateKey() {
        return RSAPrivateKey;
    }

    public void setRSAPrivateKey(String rSAPrivateKey) {
        RSAPrivateKey = rSAPrivateKey;
    }

    public String getRSAPublicKey() {
        return RSAPublicKey;
    }

    public void setRSAPublicKey(String rSAPublicKey) {
        RSAPublicKey = rSAPublicKey;
    }

    public String getBranCode() {
        return branCode;
    }

    public void setBranCode(String branCode) {
        this.branCode = branCode;
    }

    public int getSocketTimeout() {
        return SocketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        SocketTimeout = socketTimeout;
    }

}
