/**   
 * Copyright © 2019 e-future. All rights reserved.
 * 
 * @Title: BaseRequest.java 
 * @Prject: efuture-posSV-service
 * @Package: com.efuture.pos.model.zhongbai.request 
 * @Description: TODO
 * @author: yincan   
 * @date: 2019年7月12日 下午2:28:02 
 * @version: V1.0   
 */
package com.efuture.business.model.request;

import com.efuture.business.util.UUIDUtils;

import java.io.Serializable;


/**
 * @Description: TODO
 * @author: yincan
 * @date: 2019年7月12日 下午2:28:02
 */
public class BaseRequest extends ZbRequest {

	private static final long serialVersionUID = 1L;
	/**
	 * 请求编号 ,可为随机字符串或uuid不长于32位,防网络攻击
	 * <p>
	 * length 128
	 */
	private String traceId;
	/**
	 * 版本号
	 * <p>
	 * length 20
	 */
	private String version;
	/**
	 * 传入字符集
	 */
	private String inCharSet;
	/**
	 * 回传字符集
	 */
	private String OutCharSet;
	/**
	 * 商户号
	 */
	private String mcId;
	/**
	 * 接入商
	 */
	private String pactId;
	/**
	 * 接口名称
	 */
	private String service;
	/**
	 * 请求数据
	 */
	private RequestData data;

	public String getTraceId() {
		return traceId;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getInCharSet() {
		return inCharSet;
	}

	public void setInCharSet(String inCharSet) {
		this.inCharSet = inCharSet;
	}

	public String getOutCharSet() {
		return OutCharSet;
	}

	public void setOutCharSet(String outCharSet) {
		OutCharSet = outCharSet;
	}

	public String getMcId() {
		return mcId;
	}

	public void setMcId(String mcId) {
		this.mcId = mcId;
	}

	public String getPactId() {
		return pactId;
	}

	public void setPactId(String pactId) {
		this.pactId = pactId;
	}

	public String getService() {
		return service;
	}

	public void setService(String service) {
		this.service = service;
	}

	public BaseRequest(RequestData data) {
		this.data = data;
	}

	public BaseRequest() {
		setTraceId(UUIDUtils.buildGuid());// 请求编号
		// setVersion(RSAConfig.getVersion());// 版本号
		// setMcId(RSAConfig.getMcId());// 商户号
		// setPactId(RSAConfig.getPactId());
	}

	public BaseRequest(String version, String mcId, String pactId, String service) {
		super();
		this.traceId = UUIDUtils.buildGuid();
		this.version = version;
		this.mcId = mcId;
		this.pactId = pactId;
		this.service = service;
	}

	public RequestData getData() {
		return data;
	}

	public void setData(RequestData data) {
		this.data = data;
	}

	/**
	 * 
	 * @Description: 请求数据基类
	 * @author: yincan
	 * @date: 2019年7月12日 下午3:05:40
	 */
	public static class RequestData implements Serializable {

		private static final long serialVersionUID = 1L;
		/**
		 * 交易日期 yyyyMMddHHmmss
		 */
		private String transDate;
		/**
		 * 门店标识
		 */
		private String storeCode;
		/**
		 * 款台号
		 */
		private String posId;

		public String getTransDate() {
			return transDate;
		}

		public void setTransDate(String transDate) {
			this.transDate = transDate;
		}

		public String getStoreCode() {
			return storeCode;
		}

		public void setStoreCode(String storeCode) {
			this.storeCode = storeCode;
		}

		public String getPosId() {
			return posId;
		}

		public void setPosId(String posId) {
			this.posId = posId;
		}

		@Override
		public String toString() {
			return "RequestData [transDate=" + transDate + ", storeCode=" + storeCode + ", posId=" + posId + "]";
		}

	}

	@Override
	public String toString() {
		return "BaseRequest [traceId=" + traceId + ", version=" + version + ", inCharSet=" + inCharSet + ", OutCharSet="
				+ OutCharSet + ", mcId=" + mcId + ", pactId=" + pactId + ", service=" + service + ", data=" + data
				+ "]";
	}

	public enum ZBServiceType {
		sale("101", "消费"), voidsale("102", "冲正"), query("301", "交易查询"), refund("401", "退款"), TransTypeQuery("501",
				"交易码类型查询"), ortherQuery("503", "其他查询"), submit("701", "交易上送");
		private final String code;

		private final String desc;

		public String code() {
			return this.code;
		}

		public String desc() {
			return this.desc;
		}

		private ZBServiceType(String code, String desc) {
			this.code = code;
			this.desc = desc;
		}

	}
}
