/**   
 * Copyright © 2019 e-future. All rights reserved.
 * 
 * @Title: ZhongBaio2oDataBillsalePaysIn.java
 * @Prject: efuture-posSV-service
 * @Package: com.efuture.pos.model.request 
 * @Description: TODO
 * @author: yincan   
 * @date: 2019年7月11日 下午4:14:39 
 * @version: V1.0   
 */
package com.efuture.business.model.request;

import com.efuture.business.javaPos.struct.Payment;

import java.util.ArrayList;
import java.util.List;


/**
 * @Description: 小票付款行明细
 * @author: yincan
 * @date: 2019年7月11日 下午4:14:39
 */
public class ZhongBaiSalePay {

	/** 行号 */
	private int rowno;
	/** 支付代码 */
	private String payid;
	/** 支付金额 */
	private long payje;
	/**  */
	private String payno;
	/** 支付代码 */
	private String payerid;

	public int getRowno() {
		return rowno;
	}

	public void setRowno(int rowno) {
		this.rowno = rowno;
	}

	public String getPayid() {
		return payid;
	}

	public void setPayid(String payid) {
		this.payid = payid;
	}

	public long getPayje() {
		return payje;
	}

	public void setPayje(long payje) {
		this.payje = payje;
	}

	public String getPayno() {
		return payno;
	}

	public void setPayno(String payno) {
		this.payno = payno;
	}

	public String getPayerid() {
		return payerid;
	}

	public void setPayerid(String payerid) {
		this.payerid = payerid;
	}

	public static ZhongBaiSalePay transform2zb(Payment pay) {
		ZhongBaiSalePay zbSalePay = new ZhongBaiSalePay();
		zbSalePay.setRowno(pay.getRowno());
		zbSalePay.setPayid(pay.getPayCode());
		zbSalePay.setPayje((long) (pay.getMoney() * 100));
		zbSalePay.setPayno(pay.getPayNo());
		// zbSalePay.setPayerid(pay.payer);
		return zbSalePay;
	}

	public static List<ZhongBaiSalePay> transform2zb(List<Payment> pays) {
		List<ZhongBaiSalePay> paysZB = new ArrayList<ZhongBaiSalePay>();
		for (Payment pay : pays) {
			paysZB.add(ZhongBaiSalePay.transform2zb(pay));
		}
		return paysZB;
	}
}
