package com.efuture.business.model.request;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import org.apache.commons.httpclient.util.DateUtil;


/**
 * 中百接口入参
 * 
 * @author jiacheng
 *
 */
public class ZhongBaio2oIn implements Serializable {

	private static final long serialVersionUID = 1L;
	/**
	 * 请求编号 ,可为随机字符串或uuid不长于32位,防网络攻击
	 * <p>
	 * length 128
	 */
	private String traceId;
	/**
	 * 版本号
	 * <p>
	 * length 20
	 */
	private String version;
	/**
	 * 传入字符集
	 */
	private String inCharSet;
	/**
	 * 回传字符集
	 */
	private String OutCharSet;
	/**
	 * 商户号
	 */
	private String mcId;
	/**
	 * 接入商
	 */
	private String pactId;
	/**
	 * 接口名称
	 */
	private String service;
	/**
	 * 接口明细数据
	 */
	private Zhongbaio2oDataIn data;

	public String getTraceId() {
		return traceId;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getInCharSet() {
		return inCharSet;
	}

	public void setInCharSet(String inCharSet) {
		this.inCharSet = inCharSet;
	}

	public String getOutCharSet() {
		return OutCharSet;
	}

	public void setOutCharSet(String outCharSet) {
		OutCharSet = outCharSet;
	}

	public String getMcId() {
		return mcId;
	}

	public void setMcId(String mcId) {
		this.mcId = mcId;
	}

	public String getPactId() {
		return pactId;
	}

	public void setPactId(String pactId) {
		this.pactId = pactId;
	}

	public String getService() {
		return service;
	}

	public void setService(String service) {
		this.service = service;
	}

	public Zhongbaio2oDataIn getData() {
		return data;
	}

	public void setData(Zhongbaio2oDataIn data) {
		this.data = data;
	}

	public ZhongBaio2oIn(ZhongbaiPaymentIn reqIn, CacheModel cacheModel) {
		// 小票头
		Order order = cacheModel.getOrder();
		List<Goods> goods = cacheModel.getGoodsList();
		List<Payment> payments = cacheModel.getPayments();
		Zhongbaio2oDataIn data = new Zhongbaio2oDataIn();
		data.setTransDate(DateUtil.formatDate(new Date(), "yyyyMMddHHmmss"));
		data.setStoreCode(order.getShopCode());// 门店号
		data.setPosId(order.getTerminalNo());// 款机号
		data.setListNo(order.getTerminalSno());// 小票号
		data.setCashier(order.getTerminalOperator());// 收银员
		// data.setOrderNo(orderNo);//
		data.setPayCode("C");
		data.setPayMode("BARCODE");
		data.setTransAmt((long) (reqIn.getMoney() * 100));
		data.setRepeat(0);
	}

	public ZhongBaio2oIn() {
	}
}
