/**   
 * Copyright © 2019 e-future. All rights reserved.
 * 
 * @Title: ZhongBaio2oDataBillsaleGoodsIn.java
 * @Prject: efuture-posSV-service
 * @Package: com.efuture.pos.model.request 
 * @Description: TODO
 * @author: yincan   
 * @date: 2019年7月11日 下午4:16:09 
 * @version: V1.0   
 */
package com.efuture.business.model.request;

import com.efuture.business.javaPos.struct.Goods;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;


/**
 * @Description: 小票商品明细
 * @author: yincan
 * @date: 2019年7月11日 下午4:16:09
 */
public class ZhongBaisaleGoods {

	/** 行号 */
	private String rowno;
	/** 商品编码 */
	private String code;
	/** 商品条码 */
	private String barcode;
	/** 商品名称 */
	private String name;
	/** 专柜编码 */
	private String manaframe;
	/** 类别编码 */
	private String catid;
	/** 商品品牌 */
	private String ppid;
	/** 税率 */
	private long xxtax;
	/** 市场价格 */
	private long sj;
	/** 商品价格 */
	private long jg;
	/** 数量 */
	private long sl;
	/** 本行合计原始总金额 */
	private long hjje;
	/** 本行合计折扣 */
	private long hjzk;

	public String getRowno() {
		return rowno;
	}

	public void setRowno(String rowno) {
		this.rowno = rowno;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getBarcode() {
		return barcode;
	}

	public void setBarcode(String barcode) {
		this.barcode = barcode;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getManaframe() {
		return manaframe;
	}

	public void setManaframe(String manaframe) {
		this.manaframe = manaframe;
	}

	public String getCatid() {
		return catid;
	}

	public void setCatid(String catid) {
		this.catid = catid;
	}

	public String getPpid() {
		return ppid;
	}

	public void setPpid(String ppid) {
		this.ppid = ppid;
	}

	public long getXxtax() {
		return xxtax;
	}

	public void setXxtax(long xxtax) {
		this.xxtax = xxtax;
	}

	public long getSj() {
		return sj;
	}

	public void setSj(long sj) {
		this.sj = sj;
	}

	public long getJg() {
		return jg;
	}

	public void setJg(long jg) {
		this.jg = jg;
	}

	public long getSl() {
		return sl;
	}

	public void setSl(long sl) {
		this.sl = sl;
	}

	public long getHjje() {
		return hjje;
	}

	public void setHjje(long hjje) {
		this.hjje = hjje;
	}

	public long getHjzk() {
		return hjzk;
	}

	public void setHjzk(long hjzk) {
		this.hjzk = hjzk;
	}

	public static ZhongBaisaleGoods transform2zb(Goods good) {
		ZhongBaisaleGoods zbGood = new ZhongBaisaleGoods();
		zbGood.setRowno(String.valueOf(good.getFlowId()));
		zbGood.setCode(good.getGoodsCode());
		zbGood.setBarcode(good.getBarNo());
		try {
			zbGood.setName(URLEncoder.encode(good.getGoodsName(), "utf-8"));
		} catch (UnsupportedEncodingException e) {
			zbGood.setName(good.getGoodsName());
			// e.printStackTrace();
		}
		zbGood.setManaframe(good.getOrgCode());// 专柜编码
		zbGood.setCatid(good.getCategory());// 类别
		zbGood.setPpid(good.getBrand());// 品牌
		// zbGood.setXxtax(good.getKlm());// 税率
		zbGood.setSj((long) (good.getListPrice() * 100));// 市场价格
		zbGood.setJg((long) (good.getSalePrice() * 100));// 商品价格
		zbGood.setSl((long) (good.getQty() * 1000));// 数量
		zbGood.setHjje((long) (good.getSaleValue() * 100));// 合计金额
		zbGood.setHjzk((long) (good.getTotalDiscountValue() * 100));// 合计折扣
		return zbGood;
	}

	public static List<ZhongBaisaleGoods> transform2zb(List<Goods> goods) {
		List<ZhongBaisaleGoods> goodsZB = new ArrayList<ZhongBaisaleGoods>();
		for (Goods good : goods) {
			goodsZB.add(ZhongBaisaleGoods.transform2zb(good));
		}
		return goodsZB;
	}
}
