/**   
 * Copyright © 2019 e-future. All rights reserved.
 * 
 * @Title: Receipts.java 
 * @Prject: efuture-posSV-service
 * @Package: com.efuture.pos.model.zhongbai 
 * @Description: TODO
 * @author: yincan   
 * @date: 2019年7月12日 下午3:34:08 
 * @version: V1.0   
 */
package com.efuture.business.model.request;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import com.alibaba.druid.util.StringUtils;
import com.efuture.business.bean.SellType;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;

/**
 * @Description: 中百小票信息
 * @author: yincan
 * @date: 2019年7月12日 下午3:34:08
 */
public class ZhongbaiBill implements Serializable {
	private static final long serialVersionUID = 1L;
	/**
	 * 交易类型
	 */
	private String type;
	/**
	 * 会员号
	 */
	private String userCode;
	/**
	 * 明细条数
	 */
	private int tot;
	/**
	 * 购买数量 默认3位精度,如 1个为1000
	 */
	private long zsl;
	/**
	 * 销售金额
	 */
	private long xsje;
	/**
	 * 应付金额：分
	 */
	private long ysje;
	/**
	 * 收银损益：分
	 */
	private long sysy;
	/**
	 * 优惠金额：分
	 */
	private long zzke;
	/**
	 * 商品
	 */
	private List<ZhongBaisaleGoods> sgs;
	/**
	 * 支付行
	 */
	private List<ZhongBaiSalePay> sps;

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getUserCode() {
		return userCode;
	}

	public void setUserCode(String userCode) {
		this.userCode = userCode;
	}

	public int getTot() {
		return tot;
	}

	public void setTot(int tot) {
		this.tot = tot;
	}

	public long getZsl() {
		return zsl;
	}

	public void setZsl(long zsl) {
		this.zsl = zsl;
	}

	public long getXsje() {
		return xsje;
	}

	public void setXsje(long xsje) {
		this.xsje = xsje;
	}

	public long getYsje() {
		return ysje;
	}

	public void setYsje(long ysje) {
		this.ysje = ysje;
	}

	public long getSysy() {
		return sysy;
	}

	public void setSysy(long sysy) {
		this.sysy = sysy;
	}

	public long getZzke() {
		return zzke;
	}

	public void setZzke(long zzke) {
		this.zzke = zzke;
	}

	public List<ZhongBaisaleGoods> getSgs() {
		return sgs;
	}

	public void setSgs(List<ZhongBaisaleGoods> sgs) {
		this.sgs = sgs;
	}

	public List<ZhongBaiSalePay> getSps() {
		return sps;
	}

	public void setSps(List<ZhongBaiSalePay> sps) {
		this.sps = sps;
	}

	public ZhongbaiBill(CacheModel cacheModel) {
		Order order = cacheModel.getOrder();
		List<Goods> goods = cacheModel.getGoodsList();
		List<Payment> payments = cacheModel.getPayments();
		if (order != null) {
			this.setType(SellType.RETAIL_SALE);
			if(null != order.getConsumersData() && !StringUtils.isEmpty(order.getConsumersData().getConsumersCard())) {
				this.setUserCode(order.getConsumersData().getConsumersCard());
			}
			this.setTot(order.getQty());// 明细条数
			this.setZsl(order.getQty() * 1000);// 购买数量
			this.setXsje((long) (order.getOughtPay() * 100+0.1));// 销售金额
			this.setYsje((long) (order.getExistPay() * 100+0.1));// 应付金额
			this.setSysy((long) (order.getOverageValue() * 100+0.1));// 收银损益
			this.setZzke((long) (order.getTotalDiscountValue() * 100+0.1));// 优惠金额
			this.setSgs(ZhongBaisaleGoods.transform2zb(goods));// 商品
			this.setSps(ZhongBaiSalePay.transform2zb(payments));// 付款行
		}

	}
//	public static void main(String[] args) {
//	double outpay = 20.4d;
//	System.out.println((long) (outpay * 100+0.1));
//	}
}
