/**   
 * Copyright © 2019 e-future. All rights reserved.
 * 
 * @Title: ZhongbaiPaymentIn.java 
 * @Prject: efuture-posSV-service
 * @Package: com.efuture.pos.model.request 
 * @Description: TODO
 * @author: yincan   
 * @date: 2019年7月11日 下午3:08:41 
 * @version: V1.0   
 */
package com.efuture.business.model.request;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.javaPos.struct.AbstractInModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PosField;
import com.efuture.business.model.response.ZhongbaiData;
import com.efuture.business.model.response.ZhongbaiFund;
import com.efuture.business.util.UUIDUtils;

/**
 * @Description: 中百支付入参
 * @author: yincan
 * @date: 2019年7月11日 下午3:08:41
 */
public class ZhongbaiPaymentIn extends AbstractInModel {

	private static final long serialVersionUID = 1L;
	@PosField(describe = "scene")
	private String scene;// 0-普通 1-除外
	@PosField(describe = "付款方式代码")
	private String payCode; // 付款方式代码
	@PosField(describe = "付款方式名称")
	private String payName; // 付款方式名称
	@PosField(describe = "付款卡号")
	private String payNo; // 付款卡号；（储值卡卡号或微信交易单号）
	@PosField(describe = "付款大类")
	private String payType; // 付款大类
	@PosField(describe = "原币金额")
	private double amount; // 原币金额
	@PosField(describe = "付款金额")
	private double money; // 付款金额
	@PosField(describe = "汇率", allowNull = true)
	private double rate; // 汇率
	@PosField(describe = "找零汇率", allowNull = true)
	private double chargeRate; // 找零汇率
	@PosField(describe = "收银损益", allowNull = true)
	private double overage; // 收银损益
	@PosField(describe = "支付模式")
	private String flag; // 支付模式 1付款 2找零3 扣回
	@PosField(describe = "是否找零")
	private String isAllowCharge; // 是否找零
	@PosField(describe = "是否溢余")
	private String isOverage; // 是否溢余
	@PosField(describe = "最小成交金额", allowNull = true)
	private double minVal;// 最小成交金额
	@PosField(describe = "最大成交金额", allowNull = true)
	private double maxVal;// 最大成交金额
	@PosField(describe = "四舍五入方式")
	private String cutMode;// 四舍五入方式(Y:截断N:四舍五入)0-精确到分、1-四舍五入到角、2-截断到角、3-四舍五入到元、4-截断到元、5-进位到角、6-进位到元
	@PosField(describe = "四舍五入精度")
	private String precision;// 四舍五入精度
	@PosField(describe = "授权码", allowNull = true)
	private String authCode;
	@PosField(describe = "券余额", allowNull = true)
	private double couponBalance;
	@PosField(describe = "银联流水号", allowNull = true)
	private long misTraceId;// 银联流水号
	@PosField(describe = "终端号", allowNull = true)
	private String misTerminalId;// 终端号
	@PosField(describe = "机构号", allowNull = true)
	private String misMerchantId;// 机构号
	@PosField(describe = "批次号", allowNull = true)
	private String misBatchNo;// 批次号
	@PosField(describe = "银行卡交易参考号", allowNull = true)
	private String misReferenceNo;// 银行卡交易参考号
	@PosField(describe = "优惠金额", allowNull = true)
	private double discountValue;// 优惠金额
	@PosField(describe = "商户优惠金额", allowNull = true)
	private double merchantdiscountValue;// 商户优惠金额
	@PosField(describe = "支付渠道优惠金额", allowNull = true)
	private double payChannelDiscountValue;// 支付渠道优惠金额

	@PosField(describe = "小票号", allowNull = true) // 查询用
	private String idSheetNo;
	@PosField(describe = "商户交易号", allowNull = true) // 查询用
	private String orderNo;
	/**
	 * 1是销售 2是消单，4是退货
	 */
	@PosField(describe = "原交易类型", allowNull = true) // 查询用
	private String queryType;

	public String getScene() {
		return scene;
	}

	public void setScene(String scene) {
		this.scene = scene;
	}

	public String getPayCode() {
		return payCode;
	}

	public void setPayCode(String payCode) {
		this.payCode = payCode;
	}

	public String getPayName() {
		return payName;
	}

	public void setPayName(String payName) {
		this.payName = payName;
	}

	public String getPayNo() {
		return payNo;
	}

	public void setPayNo(String payNo) {
		this.payNo = payNo;
	}

	public String getPayType() {
		return payType;
	}

	public void setPayType(String payType) {
		this.payType = payType;
	}

	public double getAmount() {
		return amount;
	}

	public void setAmount(double amount) {
		this.amount = amount;
	}

	public double getRate() {
		return rate;
	}

	public void setRate(double rate) {
		this.rate = rate;
	}

	public double getChargeRate() {
		return chargeRate;
	}

	public void setChargeRate(double chargeRate) {
		this.chargeRate = chargeRate;
	}

	public double getMoney() {
		return money;
	}

	public void setMoney(double money) {
		this.money = money;
	}

	public double getOverage() {
		return overage;
	}

	public void setOverage(double overage) {
		this.overage = overage;
	}

	public long getMisTraceId() {
		return misTraceId;
	}

	public void setMisTraceId(long misTraceId) {
		this.misTraceId = misTraceId;
	}

	public String getMisTerminalId() {
		return misTerminalId;
	}

	public void setMisTerminalId(String misTerminalId) {
		this.misTerminalId = misTerminalId;
	}

	public String getMisMerchantId() {
		return misMerchantId;
	}

	public void setMisMerchantId(String misMerchantId) {
		this.misMerchantId = misMerchantId;
	}

	public String getMisBatchNo() {
		return misBatchNo;
	}

	public void setMisBatchNo(String misBatchNo) {
		this.misBatchNo = misBatchNo;
	}

	public String getMisReferenceNo() {
		return misReferenceNo;
	}

	public void setMisReferenceNo(String misReferenceNo) {
		this.misReferenceNo = misReferenceNo;
	}

	public String getFlag() {
		return flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}

	public double getDiscountValue() {
		return discountValue;
	}

	public void setDiscountValue(double discountValue) {
		this.discountValue = discountValue;
	}

	public double getMerchantdiscountValue() {
		return merchantdiscountValue;
	}

	public void setMerchantdiscountValue(double merchantdiscountValue) {
		this.merchantdiscountValue = merchantdiscountValue;
	}

	public double getPayChannelDiscountValue() {
		return payChannelDiscountValue;
	}

	public void setPayChannelDiscountValue(double payChannelDiscountValue) {
		this.payChannelDiscountValue = payChannelDiscountValue;
	}

	public String getIsAllowCharge() {
		return isAllowCharge;
	}

	public void setIsAllowCharge(String isAllowCharge) {
		this.isAllowCharge = isAllowCharge;
	}

	public String getIsOverage() {
		return isOverage;
	}

	public void setIsOverage(String isOverage) {
		this.isOverage = isOverage;
	}

	public double getMinVal() {
		return minVal;
	}

	public void setMinVal(double minVal) {
		this.minVal = minVal;
	}

	public double getMaxVal() {
		return maxVal;
	}

	public void setMaxVal(double maxVal) {
		this.maxVal = maxVal;
	}

	public String getCutMode() {
		return cutMode;
	}

	public void setCutMode(String cutMode) {
		this.cutMode = cutMode;
	}

	public String getPrecision() {
		return precision;
	}

	public void setPrecision(String precision) {
		this.precision = precision;
	}

	public String getAuthCode() {
		return authCode;
	}

	public void setAuthCode(String authCode) {
		this.authCode = authCode;
	}

	public double getCouponBalance() {
		return couponBalance;
	}

	public void setCouponBalance(double couponBalance) {
		this.couponBalance = couponBalance;
	}

	public String getIdSheetNo() {
		return idSheetNo;
	}

	public void setIdSheetNo(String idSheetNo) {
		this.idSheetNo = idSheetNo;
	}

	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	public String getQueryType() {
		return queryType;
	}

	public void setQueryType(String queryType) {
		this.queryType = queryType;
	}

	@Override
	public AbstractInModel transfer(JSONObject jsonParams) {
		ZhongbaiPaymentIn in = JSON.toJavaObject(jsonParams, ZhongbaiPaymentIn.class);
		return in;
	}

	/**
	 * 
	 * @Title: creatPrePayment
	 * @Description: 根据界面入参生成payment
	 * @param paymentIn
	 * @param order
	 * @return
	 * @return: Payment
	 * @author: yincan
	 * @date: 2019年7月16日 下午5:53:45
	 */
	public static Payment creatPrePayment(ZhongbaiPaymentIn paymentIn, CacheModel order) {
		Payment payment = new Payment();
		payment.setPuid(UUIDUtils.buildPuid());// 付款唯一标识号
		payment.setRowno(order.getPayments().size() + 1);// 营销付款行号,顺序号
		if ("3".equals(paymentIn.getFlag())) {
			payment.setFlag("3");
		} else if ("2".equals(paymentIn.getFlag())) {
			payment.setFlag("2");
		} else {
			payment.setFlag("1");
		}
		// payment.setFlag("1");
		// payment.setFlag(paymentIn.getFlag());
		payment.setTerminalNo(order.getOrder().getTerminalNo()); // 收银机号
		payment.setTerminalSno(order.getOrder().getTerminalSno()); // 小票号
		payment.setPayCode(paymentIn.getPayCode()); // 付款方式代码
		payment.setPayNo(paymentIn.getPayNo()); // 订单号
		payment.setRate(paymentIn.getRate()); // 汇率
		payment.setAmount(paymentIn.getAmount()); // 原币
		payment.setMoney(paymentIn.getMoney()); // 本币
		payment.setOverage(paymentIn.getOverage()); // 损益
		payment.setBatchNo(paymentIn.getMisBatchNo());// 批次号
		payment.setTrace(paymentIn.getMisTraceId());// 银联流水号
		payment.setMisTerminalId(paymentIn.getMisTerminalId());// 终端号
		payment.setMisMerchantId(paymentIn.getMisMerchantId());// 机构号
		payment.setRefCode(paymentIn.getMisReferenceNo());// 银行卡交易参考号
		payment.setDiscountValue(paymentIn.getDiscountValue());// 优惠金额
		payment.setMerchantdiscountValue(paymentIn.getMerchantdiscountValue());// 商户优惠金额
		payment.setPayChannelDiscountValue(paymentIn.getPayChannelDiscountValue());// 支付渠道优惠金额
		payment.setChargeRate(paymentIn.getChargeRate());// 找零汇率
		payment.setIsAllowCharge(paymentIn.getIsAllowCharge()); // 是否找零
		payment.setIsOverage(paymentIn.getIsOverage());// 是否溢余
		/*
		 * if (SellType.ISBACK(order.getOrder().getOrderType())) {
		 * payment.setIsAllowCharge("N"); }
		 */
		payment.setMinVal(paymentIn.getMinVal());// 最小成交金额
		payment.setMaxVal(paymentIn.getMaxVal());// 最大成交金额
		payment.setPrcutMode(paymentIn.getCutMode());// 四舍五入方式(Y:截断
														// N:四舍五入)0-精确到分、1-四舍五入到角、2-截断到角、3-四舍五入到元、4-截断到元、5-进位到角、6-进位到元
		payment.setPrecision(paymentIn.getPrecision());// 四舍五入精度
		payment.setPayType(paymentIn.getPayType());// 付款大类
		payment.setPayName(paymentIn.getPayName());// 付款方式名称
		payment.setIsDirectDel(true);
		payment.setAuthCode(paymentIn.getAuthCode());
		payment.setCouponBalance(paymentIn.getCouponBalance());
		return payment;
	}

	/**
	 * 
	 * @Title: creatPayment
	 * @Description: 根据接口返回，生成多个payment
	 * @param paymentIn
	 * @param data
	 * @return
	 * @return: Payment
	 * @author: yincan
	 * @date: 2019年7月16日 下午5:41:48
	 */
	public static List<Payment> creatPayment(Payment paymentTemp, ZhongbaiData data) {
		List<Payment> payments = new ArrayList<Payment>();
		paymentTemp.setBatchNo(data.getOrderNo());// 支付订单号 同一次支付，批次号相同
		List<ZhongbaiFund> funds = data.getFunds();
		for (int i = 0; i < funds.size(); i++) {
			Payment pay = (Payment) paymentTemp.clone();
			pay.setPuid(UUIDUtils.buildPuid());
			pay.setPayCode(funds.get(i).getCode());// 支付编码
			pay.setPayName(funds.get(i).getName());// 支付方式名称
			pay.setAmount((Double.valueOf(funds.get(i).getJe())*0.01));//原币
			pay.setMoney((Double.valueOf(funds.get(i).getJe())*0.01)*pay.getRate());// 支付金额
			pay.setPayNo(funds.get(i).getBatch());// 付款券号,用来打印
			pay.setRowno(pay.getRowno() + i);
			pay.setRefCode(funds.get(i).getPayno());// 支付交易流水号
			payments.add(pay);
		}
		return payments;
	}
}
