package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.efuture.business.annotation.HessianService;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.CalcPopSoaUrl;
import com.efuture.business.constant.VipSoaUrl;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.*;
import com.efuture.business.javaPos.struct.promotionCentre.request.CrminfoAuthIn;
import com.efuture.business.javaPos.struct.request.CountAllIn;
import com.efuture.business.model.CustomerOutDef;
import com.efuture.business.service.CalcPopRemoteService;
import com.efuture.business.service.VipRemoteService;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.HttpClientUtils;
import com.product.model.ServiceSession;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.List;

@Slf4j
@HessianService(value = VipSoaUrl.VIPLOGIN_SERVICE_URL, interf = VipRemoteService.class) @Service
public class VipRemoteServiceImpl implements VipRemoteService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VipRemoteServiceImpl.class);
    //营销接口待定
    @SoaAnnotation(value = CalcPopSoaUrl.CALCPOP_SERVICE_URL) private CalcPopRemoteService
        calcPopRemoteService;

    /**
     * 会员登出/查询/登陆
     *
     * @return
     */
    @Override public RespBase login(ServiceSession session, ResqVo rvo, JSONObject paramsObject) {

        PosLogicCompoment plc = new PosLogicCompoment();
        // 1.登出注销清缓存
        String certifyType = paramsObject.getString("certifyType");
        if (certifyType != null && certifyType.equalsIgnoreCase("CANCEL")) {
            String flowNo = paramsObject.getString("flowNo");
            if (StringUtils.isNotBlank(flowNo)) {
                // 获取缓存
                CacheModel cacheModel = rvo.getCacheModel();
                if (cacheModel == null) {
                    return Code.CODE_40003.getRespBase(paramsObject.getString("flowNo"));
                }
                Order order = cacheModel.getOrder();
                order.setTotalPoint(0.00);
                order.setThisTimePoint(0.00);
                order.setConsumersData(new ConsumersData());
                cacheModel.setOrder(order);
                // 若缓存中有商品则调用单行商品计算刷新商品信息
                if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
                    // 单行计算并保存CacheModel
                    cacheModel =
                        calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, rvo, plc);
                }

                // 返回会员信息
                RespBase rep = new RespBase();
                rep.setRetflag(0);
                rep.setData(cacheModel);
                return rep;
            }
        }

        //2.会员查询
        //手机号
        //        String mobileNo = paramsObject.getString("mobileNo");
        //        if (null != mobileNo && mobileNo.length() > 11) {
        //            return Code.CODE_40000.getRespBase("登录失败：手机号输入不正确");
        //        }
        //渠道ID（全局统一编码）
        String channel_id = paramsObject.getString("channel_id");
        //经营公司
        String corp_id = paramsObject.getString("corp_id");
        //门店
        String mkt_id = paramsObject.getString("mkt_id");
        //验证方式: 1-卡号  2-手机号  3-邮箱  4-QQ登录  5-微信登录  6-支付宝登录  7-新浪微博登录  A-磁道  B-二维码  C-CID
        String id_type = paramsObject.getString("id_type");
        //认证关键字
        String id_keyword = paramsObject.getString("id_keyword");
        //认证密码        //手机号—支付密码        //卡号—证件后6位
        String id_password = paramsObject.getString("id_password");
        //返回列列表,
        String fields = paramsObject.getString("fields");

        if (null == channel_id || channel_id.isEmpty()) {
            return Code.CODE_40000.getRespBase("会员登录必须包含参数[渠道编码]");
        }
        if (null == corp_id || corp_id.isEmpty()) {
            return Code.CODE_40000.getRespBase("会员登录必须包含参数[经营公司编码]");
        }
        if (null == mkt_id || mkt_id.isEmpty()) {
            return Code.CODE_40000.getRespBase("会员登录必须包含参数[门店号]");
        }
        if (null == id_type || id_type.isEmpty()) {
            return Code.CODE_40000.getRespBase("会员登录必须包含参数[验证方式]");
        }
        if (null == id_keyword || id_keyword.isEmpty()) {
            return Code.CODE_40000.getRespBase("会员登录必须包含参数[认证关键字]");
        }
        if (null == id_password || id_password.isEmpty()) {
            return Code.CODE_40000.getRespBase("会员登录必须包含参数[认证密码]");
        }
        //        if (null == fields || fields.isEmpty()) {
        //            return Code.CODE_40000.getRespBase("会员登录必须包含参数[返回列列表]");
        //        }
        String flowNo = paramsObject.getString("flowNo");
        CacheModel cacheModel = null;
        Order order = null;
        if (StringUtils.isNotBlank(flowNo)) {
            // 获取缓存
            cacheModel = rvo.getCacheModel();
            if (cacheModel == null) {
                return Code.CODE_40003.getRespBase(paramsObject.getString("flowNo"));
            }
            order = cacheModel.getOrder();

            //有订单操作校验
            if (SellType.STAMP_EXCHANGE_SALE.equals(order.getOrderType())) {
                for (Goods sg : cacheModel.getGoodsList()) {
                    if (sg.getElectronicStamp() > 0 || sg.getPhysicalStamp() > 0) {
                        return Code.CODE_40002.getRespBase("已存在换购不允许再刷会员卡");
                    }
                }
            }
            if (order.getStaffSale()) {
                return Code.CODE_40002.getRespBase("已刷员工卡不允许刷会员卡");
            }
        }

        String cardNo = paramsObject.getString("cardNo");
        boolean isCard = false;// 是否卡号登录
        // 校验卡号
        if (null != cardNo && "1".equals(id_type)) {
            String mCardNo = checkCard(cardNo);// 校验卡号
            if (null != mCardNo) {
                isCard = true;
            } else {
                return Code.CODE_40004.getRespBase("卡号校验失败");
            }
        }

        CrminfoAuthIn crminfoAuthIn = new CrminfoAuthIn();
        crminfoAuthIn.setChannelId(channel_id);
        crminfoAuthIn.setCorpId(corp_id);
        crminfoAuthIn.setMktId(mkt_id);
        crminfoAuthIn.setIdKeyword(id_keyword);
        crminfoAuthIn.setIdPassword(id_password);
        crminfoAuthIn.setIdType(id_type);
        crminfoAuthIn.setFields("*,consumers_data,accnts");
        //SEARCH-查询（默认）
        //PLACEORDER-下单
        //CONSUME-消费
        crminfoAuthIn.setAuthScene("SEARCH");

        log.info("中百会员入参==>{}",JSONObject.toJSON(crminfoAuthIn));
        //调用会员认证
        String repStr = crminfoAuth(crminfoAuthIn);
        JSONObject out = JSON.parseObject(repStr);
        JSONObject data = out.getJSONObject("data");
        if (null == data || data.size() == 0) {
            return Code.CODE_40000.getRespBase("会员营销返回数据结构缺失!");
        }
        CustomerOutDef custRep = JSONObject.parseObject(data.toJSONString(), CustomerOutDef.class);
        //返回代码
        //0	    成功
        //20000 认证信息不存在
        //20001 解析磁道/二维码/条码失败
        //20002 会员已冻结
        //20003 会员已注销
        //20004 密码验证错误
        //20005 字典错误：会员类型不存在或会员用途不存在
        //20006 权限错误：无回馈权限
        //20007 使用范围错误
        String retCode = out.getString("returncode");
        if (retCode.equals("20000")) {
            return Code.CODE_40020.getRespBase("认证信息不存在");
        } else if (retCode.equals("20001")) {
            return Code.CODE_40021.getRespBase("解析磁道/二维码/条码失败");
        } else if (retCode.equals("20002")) {
            return Code.CODE_40022.getRespBase("会员已冻结");
        } else if (retCode.equals("20003")) {
            return Code.CODE_40023.getRespBase("会员已注销");
        } else if (retCode.equals("20004")) {
            return Code.CODE_40024.getRespBase("密码验证错误");
        } else if (retCode.equals("20005")) {
            return Code.CODE_40025.getRespBase("字典错误：会员类型不存在或会员用途不存在");
        } else if (retCode.equals("20006")) {
            return Code.CODE_40026.getRespBase("权限错误：无回馈权限");
        } else if (retCode.equals("20007")) {
            return Code.CODE_40027.getRespBase("使用范围错误");
        }
        // 返回会员信息
        RespBase rep = new RespBase();
        ConsumersData custData = new ConsumersData();
        custData.setConsumersCard(custRep.getCustid());
        custData.setConsumersCardName(custRep.getCust_typename());
        custData.setConsumersId(custRep.getCid());
        custData.setConsumersCName(custRep.getName());
        custData.setConsumersType(custRep.getConsumers_data().getConsumers_type());// 会员类型
        custData.setConsumersCardExp(custRep.getConsumers_data().getConsumers_xfdate());
        custData.setMobile(custRep.getMobile());// 手机号
        custData.setPoint(CastUtil.castDouble(custRep.getAccnt().getJf()));// 积分

        // 若缓存中有商品则调用单行商品计算刷新商品信息
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
            // 单行计算并保存CacheModel
            cacheModel = calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, rvo, plc);
        }

        order.setConsumersData(custData);
        cacheModel.setOrder(order);
        rep.setRetflag(0);
        rep.setData(cacheModel);
        return rep;
    }

    public CacheModel calcAfterMemberLoginOrCancel(CacheModel cacheModel, JSONObject paramsObject,
        ServiceSession session, ResqVo vo, PosLogicCompoment plc) {
        // 到会员营销中心计单行促销
        cacheModel.callMarketClear();
        cacheModel = plc.removeAeonCouponPopDetail(cacheModel);
        cacheModel.getOrder().setSeqNo("");

        if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 3) {
            //调用单行促销
            RespBase<ResqVo> respBase = null;
            try {
                respBase = calcPopRemoteService
                    .calcSinglePopAfterVipService(session, "0", "", null, vo, null, true, true,
                        true);
            } catch (Exception e) {
                e.printStackTrace();
                LOGGER.info("会员调用单行计算异常:" + e);
            }
            ResqVo resqVo = respBase.getData();
            cacheModel = resqVo.getCacheModel();

        } else if (cacheModel.getPopMode() == 2) {
            //调用整单促销
            String calcMode = "0";
            cacheModel = calcOrderPop(session, calcMode, cacheModel, vo, paramsObject);
        } else {
//            plc.calcOrderAmount(cacheModel);
        }

//        cacheModel = plc.CalcAdjustDiscAfterOrder(cacheModel);

        return cacheModel;
    }

    /**
     * 调用promotion工程进行会员整单计算
     */
    private CacheModel calcOrderPop(ServiceSession session, String calcMode, CacheModel cacheModel,
        ResqVo vo, JSONObject paramsObject) {
        RespBase<CacheModel> resp = new RespBase<CacheModel>();
        CountAllIn countAllIn = new CountAllIn();

        countAllIn = (CountAllIn) countAllIn.transfer(paramsObject);
        countAllIn.setCalcMode(calcMode);
        List<String> limitedPayCodes = countAllIn.gainLimitedPayCodes(cacheModel, countAllIn);
        countAllIn.setLimitedPayCodes(limitedPayCodes);

        try {
            countAllIn = JSON.parseObject(paramsObject.toJSONString(), CountAllIn.class);
        } catch (Exception e) {
            resp.setData(cacheModel);
            //            return Code.CODE_50033.getRespBase("已刷员工卡不允许刷会员卡");
            //            return ServiceResponse.buildFailure(session, PosReturnCode.RESPONSE_FAILURE,
            //                "整单计算入参转换错误[{0}]", e.getMessage());
        }

        RespBase<ResqVo> respBase = null;
        try {
            respBase = calcPopRemoteService.calcAllPop(session, vo, countAllIn);
        } catch (Exception e) {
            e.printStackTrace();
            LOGGER.info("会员调用整单计算异常:" + e);
        }
        ResqVo resqVo = respBase.getData();
        cacheModel = resqVo.getCacheModel();
        return cacheModel;
    }

    /**
     * @Description: 会员认证
     */
    public String crminfoAuth(CrminfoAuthIn crminfoAuthIn) {
        String str = null;
        // 调用会员营销平台 会员认证
        try {
            String url = GlobalInfo.vipurl;
            String inParams = JSON.toJSONString(crminfoAuthIn);
            str = HttpClientUtils.postJson(url, inParams);
            LOGGER.info("会员认证出参:" + str);
        } catch (IOException e) {
            e.printStackTrace();
        }
        //        ServiceResponse resp = HttpClientUtils.doPost(restTemplate, RemoteService.PROMOTION_INFO,
        //            YPopStatusType.CRMINFOAUTH_URL, session, inParams, CrminfoAuthOut.class, "营销中心", "会员认证");
        return str;
    }


    // 检验卡号合法性,成功返回解析后的卡号，失败返回null
    private String checkCard(String cardNo) {
        String mCardNo = null;
        SysParaInfo spi = new SysParaInfo();
        String hyqz = spi.getHyqz();

        // 1. 磁条卡
        if (cardNo.contains("=")) {
            mCardNo = cardNo.split("=")[0];
            if (mCardNo.length() >= 16) {
                mCardNo = mCardNo.substring(mCardNo.length() - 16);
            }
        } else if (cardNo.startsWith("93") || cardNo.startsWith("94")) {// c) 电子会员卡
            if (cardNo.length() >= 18) {
                mCardNo = cardNo.substring(2, 18);// 从第三位截取卡号，截取16位
            }
        }
        if (null != mCardNo) {
            if (hyqz.contains(",")) {
                String[] qzs = hyqz.split(",");
                for (String qz : qzs) {
                    if (mCardNo.startsWith(qz)) {
                        return mCardNo;
                    }
                }
            } else {
                if (mCardNo.startsWith(hyqz)) {
                    return mCardNo;
                }
            }
        }
        if (cardNo.length() == 10) {// b) IC卡 仅限青岛
            mCardNo = "637243" + cardNo;
            return mCardNo;
        }
        return null;

    }

}
