package com.efuture.business.service.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;

import com.efuture.business.annotation.HessianService;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.CalcPopSoaUrl;
import com.efuture.business.constant.VipSoaUrl;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.global.PosReturnCode;
import com.efuture.business.javaPos.struct.*;
import com.efuture.business.javaPos.struct.cnaeon.BaseResponse;
import com.efuture.business.javaPos.struct.request.CountAllIn;
import com.efuture.business.javaPos.struct.request.ZBMemberConfirmIn;
import com.efuture.business.local.ZBRSAConfig;
import com.efuture.business.model.request.BaseRequest;
import com.efuture.business.model.request.ZhongBaio2oIn;
import com.efuture.business.model.request.Zhongbaio2oDataIn;
import com.efuture.business.model.response.ZhongbaiData;
import com.efuture.business.model.response.ZhongbaiUsr;
import com.efuture.business.service.CalcPopRemoteService;
import com.efuture.business.service.ZBVipRemoteService;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.RSAUtil;
import com.efuture.business.util.UUIDUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.product.model.ResponseCode;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;

/**
 * 中百会员认证接口
 *
 * @author jiacheng
 */
@Slf4j
@HessianService(value = VipSoaUrl.ZB_VIPLOGIN_SERVICE_URL, interf = ZBVipRemoteService.class)
@Service public class ZBVipRemoteServiceImpl implements ZBVipRemoteService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZBVipRemoteServiceImpl.class);

    //营销接口待定
    @SoaAnnotation(value = CalcPopSoaUrl.CALCPOP_SERVICE_URL) private CalcPopRemoteService
        calcPopRemoteService;

    @Resource(name = "ZBRSAConfig") public ZBRSAConfig ZBRSAConfig;

    @Override
    public RespBase memberLogin(ServiceSession session, ResqVo vo, JSONObject paramsObject) {

        // 入参bean转换(由自定义的ZBMemberConfirmIn封装进ZhongBaio2oIn)
        ZBMemberConfirmIn paraIn = JSONObject.toJavaObject(paramsObject, ZBMemberConfirmIn.class);
        // 查询订单缓存是否存在，不存在返回失败
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, "订单[{0}]已失效，请重新生成订单", vo.getCacheModel().getFlowNo());
        }

        // 1.注销清缓存
        if (paraIn.getCertifyType() != null && paraIn.getCertifyType().equalsIgnoreCase("CANCEL")) {
            String flowNo = paramsObject.getString("flowNo");
            if (StringUtils.isNotBlank(flowNo)) {
                Order order = cacheModel.getOrder();
                order.setTotalPoint(0.00);
                order.setThisTimePoint(0.00);
                order.setConsumersData(null);
                cacheModel.setOrder(order);
                // 若缓存中有商品则调用单行商品计算刷新商品信息
                if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
                    //团购单类型不走营销 yinC 2020/08/07
                    if (!SellType.isGroupbuy(order.getOrderType())) {
                        // 单行计算并保存CacheModel
                        cacheModel =
                            calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, vo);
                    }
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(OrderForPos.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo(cacheModel, (JSONObject) JSON.toJSON(out));
                LOGGER.info("出参输出" + JSON.toJSON(new RespBase(Code.SUCCESS, resqVo, "ZBMZKPAY")));
                return new RespBase(Code.SUCCESS, resqVo, "ZBMZKPAY");
            }
        }

        // 初始化券平台参数
        ServiceResponse response =
            initRSAConfigByPara(session, paraIn.getShopCode(), paraIn.getErpCode());

//        if (!ResponseCode.SUCCESS.equals(response.getReturncode())) {
//            return new RespBase(Code.CODE_40000, "会员查询异常!");
//        }

        ZhongBaio2oIn in = new ZhongBaio2oIn();
        Zhongbaio2oDataIn dataIn = new Zhongbaio2oDataIn();
        try {
            dataIn.setTransDate(paraIn.getTransDate());
            dataIn.setPayCode(paraIn.getConsumersCard());
            dataIn.setListNo(paraIn.getTerminalSno());
            if ("002".equals(paraIn.getErpCode())) {
                dataIn.setStoreCode(paraIn.getShopCode().substring(0, 4));
            } else {
                dataIn.setStoreCode(paraIn.getShopCode());
            }
            dataIn.setPosId(paraIn.getTerminalNo());
            dataIn.setCashier(paraIn.getTerminalOperator());
            dataIn.setPayCode(paraIn.getMobileNo());
            in.setData(dataIn);
            // 密钥及其它必要信息
//            RSAUtil.getPrivateKey(ZBRSAConfig.getRSAPrivateKey());
//            RSAUtil.getPublicKey(ZBRSAConfig.getRSAPublicKey());
            in.setTraceId(UUIDUtils.buildGuid());// 请求编号
            in.setVersion(ZBRSAConfig.getVersion());
            in.setMcId(ZBRSAConfig.getMcId());
            in.setPactId(ZBRSAConfig.getPactId());
            in.setService(BaseRequest.ZBServiceType.TransTypeQuery.code());
        } catch (Exception e) {
            LOGGER.info("[会员入参信息转换异常]");
            e.printStackTrace();
        }
        // 2.不传入 flowNo 只查会员信息返回
        //        String serviceUrl = ZhongBaio2oService
        //            .getRemotePayServiceUrl(session, paraIn.getShopCode(), paraIn.getErpCode());// 获取中百地址
//        String serviceUrl = SysPara.getSysParaInfo(cacheModel.getSysPara(), "HYPU");
        String serviceUrl = cacheModel.getOrder().getSysPara().payUrl;
        String flowNo = paramsObject.getString("flowNo");
        if (null == flowNo || "".equals(flowNo)) {
            // 调用中百服务查询交易码类型
            log.info("中百会员请求==>{}",JSONObject.toJSON(in));
            response = execute(session, JSON.toJSONString(in),
                BaseRequest.ZBServiceType.TransTypeQuery.desc(), serviceUrl);
            log.info("中百会员返回<=={}",JSONObject.toJSON(response));
            if ("0".equals(response.getReturncode())) {
                BaseResponse res = (BaseResponse) response.getData();
                if ("SUCCESS".equals(res.getCode()) && null != res.getData()) {
                    ZhongbaiData zbData =
                        JSONObject.parseObject(res.getData().toJSONString(), ZhongbaiData.class);
                    //                    ZhongbaiUsr usr = res.getData().getUsr();
                    ZhongbaiUsr usr = zbData.getUsr();
                    if (null != usr) {
                        BaseOutModel out = new BaseOutModel();
                        OrderForPos ofs = new OrderForPos();
                        ConsumersData custData = new ConsumersData();
                        custData.setConsumersCard(usr.getUserCode());
                        custData.setConsumersId(usr.getUserId());
                        custData.setConsumersCName(usr.getUserName());
                        //                        custData.setConsumersType(
                        //                            res.getData().getCodeType());// 支付码类型,组合如CP表示同时是会员和支付码，P表示是支付码
                        custData.setConsumersType(
                            zbData.getCodeType());// 支付码类型,组合如CP表示同时是会员和支付码，P表示是支付码
                        custData.setConsumersLevel(usr.getGrade());
                        custData.setPoint(usr.getPoint());
                        ofs.setTotalPoint(usr.getPoint());
                        ofs.setThisTimePoint(usr.getBcjf());
                        ofs.setConsumersData(custData);
                        out.setOrder(ofs);

                        ResqVo resqVo =
                            ResqVo.buildReqVo(cacheModel, (JSONObject) JSON.toJSON(out));
                        LOGGER.info(
                            "出参输出" + JSON.toJSON(new RespBase(Code.SUCCESS, resqVo, "ZBMZKPAY")));

                        return new RespBase(Code.SUCCESS, resqVo, "ZBMZKPAY");
                    }
                } else {
                    return new RespBase(Code.CODE_40000, "会员验证失败:" + res.getMessage());
                }
            } else {
                return new RespBase(Code.CODE_40000, "会员验证失败!");
            }
        }

        // 3.调用会员认证
        if (SellType.STAMP_EXCHANGE_SALE.equals(cacheModel.getOrder().getOrderType())) {
            for (Goods sg : cacheModel.getGoodsList()) {
                if (sg.getElectronicStamp() > 0 || sg.getPhysicalStamp() > 0) {
                    return new RespBase(Code.CODE_40000, "已存在换购不允许再刷会员卡!");
                }
            }
        }

        Order order = cacheModel.getOrder();
        if (order.getStaffSale()) {
            return new RespBase(Code.CODE_40000, "已刷员工卡不允许刷会员卡!");
        }

        response =
            execute(session, JSON.toJSONString(in), BaseRequest.ZBServiceType.TransTypeQuery.desc(),
                serviceUrl);

        if (ResponseCode.SUCCESS.equals(response.getReturncode())) {
            BaseResponse res = (BaseResponse) response.getData();
            if (
//                    "SUCCESS".equals(res.getCode()) &&
                            null != res.getData()) {
                ZhongbaiData zbData =
                    JSONObject.parseObject(res.getData().toJSONString(), ZhongbaiData.class);
                //                ZhongbaiUsr usr = res.getData().getUsr();
                ZhongbaiUsr usr = zbData.getUsr();
                if (null != usr) {
                    ConsumersData custData = new ConsumersData();
                    custData.setConsumersCard(usr.getUserCode());
                    custData.setConsumersId(usr.getUserId());
                    custData.setConsumersCName(usr.getUserName());
                    //                    custData.setConsumersType(
                    //                        res.getData().getCodeType());// 支付码类型,组合如CP表示同时是会员和支付码，P表示是支付码
                    custData
                        .setConsumersType(zbData.getCodeType());// 支付码类型,组合如CP表示同时是会员和支付码，P表示是支付码
                    custData.setConsumersLevel(usr.getGrade());
                    custData.setPoint(usr.getPoint());
                    if (StringUtils.isBlank(custData.getConsumersType()) && "CP"
                        .equals(custData.getConsumersType())) {
                        custData.setCostomerPaycode(paraIn.getConsumersCard()); //CP码记录给前端调用
                    }
                    order.setTotalPoint(usr.getPoint());
                    order.setThisTimePoint(usr.getBcjf());
                    order.setConsumersData(custData);
                }
            } else {
                return new RespBase(Code.CODE_40000, "会员验证失败" + res.getMessage());
            }
        } else {
            return new RespBase(Code.CODE_40000, "会员验证失败!");
        }

        cacheModel.setOrder(order);

        // 若缓存中有商品则调用单行商品计算刷新商品信息
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
            //团购单类型不走营销 yinC 2020/08/07
            if (!SellType.isGroupbuy(order.getOrderType())) {
                // 单行计算并保存CacheModel
                try {
                    cacheModel =
                        calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session, vo);
                } catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.info("会员调用单行计算异常:" + e);
                }

                if (cacheModel.getCalcResult() == -1) {
                    String errCode = PosReturnCode.RESPONSE_FAILURE;
                    if (cacheModel.getErrCode().length() > 0) {
                        errCode = cacheModel.getErrCode();
                    }
                    return new RespBase(Code.CODE_40000, errCode + cacheModel.getErrMsg());
                }
            }
        }
        // 刷新缓存
        //        cacheModelService.saveOrUpdateCacheModel(cacheModel);
        LOGGER.info("会员信息：[{}]", JSONObject.toJSONString(cacheModel.getOrder().getConsumersData()));

        // 返回会员信息
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo(cacheModel, (JSONObject) JSON.toJSON(out));
        LOGGER.info("出参输出" + JSON.toJSON(new RespBase(Code.SUCCESS, resqVo, "ZBMZKPAY")));
        return new RespBase(Code.SUCCESS, resqVo, "ZBMZKPAY");
    }

    public ServiceResponse initRSAConfigByPara(ServiceSession session, String shopCode,
        String erpCode) {
        List<String> codes = new ArrayList<String>();
        codes.add("ZBMCID");
        //        List<SysPara> sysPara =
        //            orderService.getSyspara(session, codes, session.getErpCode(), shopCode);
        //        String mcId = SysPara.getSysParaInfo(sysPara, "ZBMCID");
        SysParaInfo spi = new SysParaInfo();
        String mcId = spi.getOutErpCode();
        if (StringUtils.isEmpty(mcId)) {
            return ServiceResponse.buildFailure(session, "100000", "从总部获取商户经营公司代码失败");
        }
        ZBRSAConfig.setMcId(mcId);
        return ServiceResponse.buildSuccess(null);
    }

    /**
     * 调用promotion工程进行会员整单计算
     */
    private CacheModel calcOrderPop(ServiceSession session, String calcMode, CacheModel cacheModel,
        ResqVo vo, JSONObject paramsObject) {
        RespBase<CacheModel> resp = new RespBase<CacheModel>();
        CountAllIn countAllIn = new CountAllIn();

        countAllIn = (CountAllIn) countAllIn.transfer(paramsObject);
        countAllIn.setCalcMode(calcMode);
        List<String> limitedPayCodes = countAllIn.gainLimitedPayCodes(cacheModel, countAllIn);
        countAllIn.setLimitedPayCodes(limitedPayCodes);

        try {
            countAllIn = JSON.parseObject(paramsObject.toJSONString(), CountAllIn.class);
        } catch (Exception e) {
            resp.setData(cacheModel);
            //            return Code.CODE_50033.getRespBase("已刷员工卡不允许刷会员卡");
            //            return ServiceResponse.buildFailure(session, PosReturnCode.RESPONSE_FAILURE,
            //                "整单计算入参转换错误[{0}]", e.getMessage());
        }

        RespBase<ResqVo> respBase = null;
        try {
            respBase = calcPopRemoteService.calcAllPop(session, vo, countAllIn);
        } catch (Exception e) {
            e.printStackTrace();
            LOGGER.info("会员调用整单计算异常:" + e);
        }
        ResqVo resqVo = respBase.getData();
        cacheModel = resqVo.getCacheModel();
        return cacheModel;
    }

    /**
     * 登录会员后计算并保存缓存
     */
    public CacheModel calcAfterMemberLoginOrCancel(CacheModel cacheModel, JSONObject paramsObject,
        ServiceSession session, ResqVo vo) {
        PosLogicCompoment plc = new PosLogicCompoment();
        // 到会员营销中心计算单行促销
        cacheModel.callMarketClear();
        cacheModel = plc.removeAeonCouponPopDetail(cacheModel);
        cacheModel.getOrder().setSeqNo("");
        if (cacheModel.getPopMode() == 1) {
            //调用单行促销
            RespBase<ResqVo> respBase = null;
            try {
                respBase = calcPopRemoteService
                    .calcSinglePopAfterVipService(session, "0", "", null, vo, null, true, true,
                        true);
            } catch (Exception e) {
                e.printStackTrace();
                LOGGER.info("会员调用单行计算异常:" + e);
            }

        } else if (cacheModel.getPopMode() == 2) {
            String calcMode = "0";
            cacheModel = calcOrderPop(session, calcMode, cacheModel, vo, paramsObject);
        } else {
            PosLogicCompoment.calcOrderAmount(cacheModel);
        }

        cacheModel = plc.CalcAdjustDiscAfterOrder(cacheModel);

        return cacheModel;
    }

    public ServiceResponse execute(ServiceSession session, String inStr, String serviceType,
        String RemoteServiceUrl) {
        RSAUtil.getPrivateKey(ZBRSAConfig.getRSAPrivateKey());
        RSAUtil.getPublicKey(ZBRSAConfig.getRSAPublicKey());
        if (StringUtils.isEmpty(RemoteServiceUrl)) {
            return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "从总部获取券平台请求地址为空!");
        }

        //    JSONObject json = JSONObject.parseObject(inStr);
        //	JSONObject Jsondata = (JSONObject)json.get("data");
        //	Jsondata.put("storeCode", "2150998");
        //	json.put("data", Jsondata);
        //	inStr = json.toJSONString();
        HttpUtils httpUtils = new HttpUtils();
        ServiceResponse resp = httpUtils
            .zhongbaiDataCenterPost(null, HttpUtils.RemoteService.ZHONGBAI_DATACENTER,
                RemoteServiceUrl, session, inStr, BaseResponse.class, "中百券平台", serviceType);
//        if (ResponseCode.SUCCESS.equals(resp.getReturncode())) {
//            BaseResponse data = (BaseResponse) resp.getData();
//            // 校验通信标识
//            if (!"00".equals(data.getCode())) {
//                resp.setReturncode(String.valueOf(data.getCode()));
//                resp.setData(data.getMessage());
//            }
//        }

        return resp;
    }

}

