package com.efuture.ocp.common.cache.config;

import com.efuture.ocp.common.cache.message.RedisMessageUtils;
import com.efuture.ocp.common.cache.message.RootMessageListenerAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FutureRedisMessageConfig
{

    @Autowired
    private StringRedisTemplate redisTemplate;

    @Bean
    RedisMessageListenerContainer container(RedisProperty redisProperty)
    {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisTemplate.getConnectionFactory());
        List<Topic> topicList = new ArrayList<>();
        String topics = redisProperty.getTopics();
        String[] topicArray = topics.split(",");
        Set<String> topicSet = new HashSet<String>();

        for (int i = 0; i < topicArray.length; i++) {
            topicSet.add(topicArray[0]);
            //topicList.add(new PatternTopic(topic[0]));
        }

        topicSet.add(RedisProperty.default_topic.cacheDataChanged);
        topicSet.add(RedisProperty.default_topic.configDataChanged);

        for (String t : topicSet) {
            topicList.add(new PatternTopic(t));
        }

        MessageListenerAdapter listenerAdapter = new MessageListenerAdapter(new RootMessageListenerAdapter());
        container.addMessageListener(listenerAdapter, topicList);
        return container;
    }

    @Bean
    public RedisMessageUtils redisMessageUtils()
    {
        return new RedisMessageUtils(redisTemplate);
    }


}
