package com.efuture.ocp.common.cache.message;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.cache.config.RedisProperty;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RootMessageListenerAdapter implements  MessageListener
{

    RedisSerializer<String> stringSerializer = new StringRedisSerializer();
    /**
     * Callback for processing received objects through Redis.
     *
     * @param message message must not be {@literal null}.
     * @param pattern pattern matching the channel (if specified) - can be {@literal null}.
     */
    @Override
    public void onMessage(Message message, byte[] pattern)
    {
        String topic = stringSerializer.deserialize(message.getChannel());
        String msg = stringSerializer.deserialize(message.getBody());

        //如果是缓存变动，POST缓存变动通知
        if (topic.equalsIgnoreCase(RedisProperty.default_topic.cacheDataChanged)) {
            CacheDataChangeEvent event = JSONObject.parseObject(msg, CacheDataChangeEvent.class);
            SpringUtil.getApplicationContext().publishEvent(event);
        }
        //如果是字典变动，POST字典变动通知
        else if (topic.equalsIgnoreCase(RedisProperty.default_topic.configDataChanged)) {
            ConfigDataChangeEvent event = JSONObject.parseObject(msg, ConfigDataChangeEvent.class);
            SpringUtil.getApplicationContext().publishEvent(event);
        }
        //如果是其他的，POST RedisMsg通知
        else {
            RedisMessage event = JSONObject.parseObject(msg, RedisMessage.class);
            SpringUtil.getApplicationContext().publishEvent(event);
        }
    }
}
