package com.efuture.ocp.common.callnumber;

/**
 * 叫号器
 */
public interface CallNumberHandle
{

    /**
     * 初始化
     */
    void init();

    int start(NumberInfo num);
    /**
     * 得到下一个号码
     * @param num 当前号
     * @param waitSecond 等待时长 [秒]
     * @return 返回 -1 表示目前无号可以用
     */
    int next(NumberInfo num, int waitSecond) ;


    /**
     * 处理完毕
     * 释放持有的号码
     */
    void complete(NumberInfo num);
}
