package com.efuture.ocp.common.callnumber;

import com.efuture.common.utils.ServiceLogs;
import com.efuture.ocp.common.cache.config.CacheConfig;
import com.efuture.ocp.common.distributedLock.DLockInfo;
import com.efuture.ocp.common.distributedLock.DistributedLockHandle;

public class DistributedCallNumberHandle implements CallNumberHandle
{

    private DistributedLockHandle dLock;

    public DistributedCallNumberHandle(DistributedLockHandle dLock)
    {
        this.dLock = dLock;
    }


    /**
     * 初始化
     */
    @Override
    public void init()
    {
    }


    /**
     * 锁定当前号码
     *
     * @param num
     * @return
     */
    public boolean lock(NumberInfo numInfo, int lockNum)
    {
        try {
            String lockKey = numInfo.getLockKey();
            String key = lockKey + ":" + lockNum;
            DLockInfo lock = dLock.tryLock(key, CacheConfig.CacheTimeOut.HalfHour, 0);

            //锁定成功
            if (lock != null) {
                numInfo.setCur(lockNum);
                numInfo.setLockInfo(lock);
                return true;
            }
            else {
                return false;
            }
        }
        catch (Throwable th) {
            ServiceLogs.error("DistributedCallNumberHandle.lock", th, "锁定[{0}][{1}]时，发生错误", 0, numInfo.getLockKey(), lockNum);
        }

        return false;
    }

    /**
     * 第一次开始处理
     *
     * @param num
     * @return
     */
    @Override
    public int start(NumberInfo num)
    {
        boolean suc = false;
        int next = num.getCur();
        String lockKey = num.getLockKey();
        suc = lock(num, next);

        if (suc) {
            ServiceLogs.info("NumberInfo", "叫号器[{0}]叫号[{1}]成功", 0, lockKey, next);
            num.startExecute();
            return next;
        }
        else {
            ServiceLogs.info("NumberInfo", "叫号器[{0}]叫号[{1}]失败,准备叫下一个", 0, lockKey, next);
            return -1;
        }
    }

    /**
     * 得到下一个号码
     *
     * @return 返回 -1 表示目前无号可以用
     */
    @Override
    public int next(NumberInfo num, int waitSecond)
    {
        //num.startExecute();
        boolean suc = false;
        int next = num.getCur() + 1;

        if (next < 0) {
            next = 0;
        }

        int max = num.getMax();
        int cur = num.getCur();
        int start = num.getStart();
        String lockKey = num.getLockKey();
        long startTime = System.currentTimeMillis();
        long wait = waitSecond * 1000;

        do {
            if (next >= max) {
                next = 0;
            }

            //如果next 等于当前自己的号，说明已经循环了一轮了，先退出即可
            if (next == start) {
                ServiceLogs.info("NumberInfo", "叫号器[{0}]已经循环一轮,直接退出", 0, lockKey);
                break;
            }

            ServiceLogs.info("NumberInfo", "叫号器[{0}]开始叫号[{1}]", 0, lockKey, next);
            String key = lockKey + ":" + next;
            suc = lock(num, next);

            if (suc) {
                ServiceLogs.info("NumberInfo", "叫号器[{0}]叫号[{1}]成功", startTime, lockKey, next);
                num.startExecute();
                return next;
            }
            else {
                ServiceLogs.info("NumberInfo", "叫号器[{0}]叫号[{1}]失败,准备叫下一个", startTime, lockKey, next);
            }

            if (System.currentTimeMillis() - startTime > wait) {
                ServiceLogs.info("NumberInfo", "叫号器[{0}]呼叫超时,直接退出", startTime, lockKey);
                break;
            }

            next = next + 1;
        } while (!suc);

        ServiceLogs.info("NumberInfo", "叫号器[{0}]未获取到号", startTime, lockKey);
        return -1;
    }

    /**
     * 处理完毕
     */
    @Override
    public void complete(NumberInfo num)
    {
        DLockInfo lockKey = num.getLockInfo();

        try {
            if (num.isRunning()) {
                dLock.unlock(lockKey);
            }
        }
        finally {
            num.completeExecute();
        }
    }
}
