package com.efuture.ocp.common.distributedLock;

import com.efuture.common.utils.UniqueUtils;

public class DLockInfo
{
    String key;
    /**
     * 开始时间
     */
    private Long startTime;

    /**
     * 租约时长
     */
    private Integer leaseTime;

    private Long lockKey;

    public DLockInfo(String key, Integer leaseTime)
    {
        this.key = key;
        this.startTime = System.currentTimeMillis();
        this.leaseTime = leaseTime;
        this.lockKey = UniqueUtils.genPhKey();
    }

    public String getKey()
    {
        return key;
    }

    public void setKey(String key)
    {
        this.key = key;
    }

    public Long getStartTime()
    {
        return startTime;
    }

    public void setStartTime(Long startTime)
    {
        this.startTime = startTime;
    }

    public Integer getLeaseTime()
    {
        return leaseTime;
    }

    public void setLeaseTime(Integer leaseTime)
    {
        this.leaseTime = leaseTime;
    }

    public Long getLockKey()
    {
        return lockKey;
    }

    public void setLockKey(Long lockKey)
    {
        this.lockKey = lockKey;
    }

    @Override
    public String toString()
    {
        return "DLockInfo{" +
               "key='" + key + '\'' +
               ", startTime=" + startTime +
               ", leaseTime=" + leaseTime +
               '}';
    }
}
