package com.efuture.ocp.common.distributedLock;

import cn.hutool.extra.spring.SpringUtil;

import java.util.concurrent.*;

public class LockWatchdogImpl implements LockWatchdog
{
    ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, new ThreadPoolExecutor.AbortPolicy());

    ConcurrentHashMap<String, DLockInfo> locks = new ConcurrentHashMap<>();
    DistributedLockHandle lockHandle;

    public LockWatchdogImpl(DistributedLockHandle lockHandle)
    {
        this.lockHandle = lockHandle;
    }

    @Override
    public void add(DLockInfo lockInfo)
    {
        locks.put(lockInfo.getKey(), lockInfo);
        executorService.schedule(() -> watch(lockInfo), 10, TimeUnit.MINUTES);
    }

    @Override
    public void remove(DLockInfo lockInfo)
    {
        locks.remove(lockInfo.getKey());
    }

    public void watch(DLockInfo lockInfo)
    {
        if (lockInfo == null) {
            return;
        }

        if (locks.get(lockInfo.getKey()) != null) {
            lockHandle.renewal(lockInfo);
        }
    }

}
