/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache.message;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.cache.message.CacheDataChangeEvent;
import com.efuture.ocp.common.cache.message.ConfigDataChangeEvent;
import com.efuture.ocp.common.cache.message.RedisMessage;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RootMessageListenerAdapter
implements MessageListener {
    RedisSerializer<String> stringSerializer = new StringRedisSerializer();

    public void onMessage(Message message, byte[] pattern) {
        String topic = (String)this.stringSerializer.deserialize(message.getChannel());
        String msg = (String)this.stringSerializer.deserialize(message.getBody());
        if (topic.equalsIgnoreCase("cache_data_changed")) {
            CacheDataChangeEvent event = (CacheDataChangeEvent)JSONObject.parseObject((String)msg, CacheDataChangeEvent.class);
            SpringUtil.getApplicationContext().publishEvent((Object)event);
        } else if (topic.equalsIgnoreCase("config_data_changed")) {
            ConfigDataChangeEvent event = (ConfigDataChangeEvent)JSONObject.parseObject((String)msg, ConfigDataChangeEvent.class);
            SpringUtil.getApplicationContext().publishEvent((Object)event);
        } else {
            RedisMessage event = (RedisMessage)JSONObject.parseObject((String)msg, RedisMessage.class);
            SpringUtil.getApplicationContext().publishEvent((Object)event);
        }
    }
}

