/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.callnumber;

import com.efuture.common.utils.ServiceLogs;
import com.efuture.ocp.common.callnumber.CallNumberHandle;
import com.efuture.ocp.common.callnumber.NumberInfo;
import com.efuture.ocp.common.distributedLock.DLockInfo;
import com.efuture.ocp.common.distributedLock.DistributedLockHandle;

public class DistributedCallNumberHandle
implements CallNumberHandle {
    private DistributedLockHandle dLock;

    public DistributedCallNumberHandle(DistributedLockHandle dLock) {
        this.dLock = dLock;
    }

    @Override
    public void init() {
    }

    public boolean lock(NumberInfo numInfo, int lockNum) {
        try {
            String lockKey = numInfo.getLockKey();
            String key = lockKey + ":" + lockNum;
            DLockInfo lock = this.dLock.tryLock(key, 1800, 0);
            if (lock != null) {
                numInfo.setCur(lockNum);
                numInfo.setLockInfo(lock);
                return true;
            }
            return false;
        }
        catch (Throwable th) {
            ServiceLogs.error((String)"DistributedCallNumberHandle.lock", (Throwable)th, (String)"\u9501\u5b9a[{0}][{1}]\u65f6\uff0c\u53d1\u751f\u9519\u8bef", (long)0L, (Object[])new Object[]{numInfo.getLockKey(), lockNum});
            return false;
        }
    }

    @Override
    public int start(NumberInfo num) {
        boolean suc = false;
        int next = num.getCur();
        String lockKey = num.getLockKey();
        suc = this.lock(num, next);
        if (suc) {
            ServiceLogs.info((String)"NumberInfo", (String)"\u53eb\u53f7\u5668[{0}]\u53eb\u53f7[{1}]\u6210\u529f", (long)0L, (Object[])new Object[]{lockKey, next});
            num.startExecute();
            return next;
        }
        ServiceLogs.info((String)"NumberInfo", (String)"\u53eb\u53f7\u5668[{0}]\u53eb\u53f7[{1}]\u5931\u8d25,\u51c6\u5907\u53eb\u4e0b\u4e00\u4e2a", (long)0L, (Object[])new Object[]{lockKey, next});
        return -1;
    }

    @Override
    public int next(NumberInfo num, int waitSecond) {
        boolean suc = false;
        int next = num.getCur() + 1;
        if (next < 0) {
            next = 0;
        }
        int max = num.getMax();
        int cur = num.getCur();
        int start = num.getStart();
        String lockKey = num.getLockKey();
        long startTime = System.currentTimeMillis();
        long wait = waitSecond * 1000;
        do {
            if (next >= max) {
                next = 0;
            }
            if (next == start) {
                ServiceLogs.info((String)"NumberInfo", (String)"\u53eb\u53f7\u5668[{0}]\u5df2\u7ecf\u5faa\u73af\u4e00\u8f6e,\u76f4\u63a5\u9000\u51fa", (long)0L, (Object[])new Object[]{lockKey});
                break;
            }
            ServiceLogs.info((String)"NumberInfo", (String)"\u53eb\u53f7\u5668[{0}]\u5f00\u59cb\u53eb\u53f7[{1}]", (long)0L, (Object[])new Object[]{lockKey, next});
            String key = lockKey + ":" + next;
            suc = this.lock(num, next);
            if (suc) {
                ServiceLogs.info((String)"NumberInfo", (String)"\u53eb\u53f7\u5668[{0}]\u53eb\u53f7[{1}]\u6210\u529f", (long)startTime, (Object[])new Object[]{lockKey, next});
                num.startExecute();
                return next;
            }
            ServiceLogs.info((String)"NumberInfo", (String)"\u53eb\u53f7\u5668[{0}]\u53eb\u53f7[{1}]\u5931\u8d25,\u51c6\u5907\u53eb\u4e0b\u4e00\u4e2a", (long)startTime, (Object[])new Object[]{lockKey, next});
            if (System.currentTimeMillis() - startTime > wait) {
                ServiceLogs.info((String)"NumberInfo", (String)"\u53eb\u53f7\u5668[{0}]\u547c\u53eb\u8d85\u65f6,\u76f4\u63a5\u9000\u51fa", (long)startTime, (Object[])new Object[]{lockKey});
                break;
            }
            ++next;
        } while (!suc);
        ServiceLogs.info((String)"NumberInfo", (String)"\u53eb\u53f7\u5668[{0}]\u672a\u83b7\u53d6\u5230\u53f7", (long)startTime, (Object[])new Object[]{lockKey});
        return -1;
    }

    @Override
    public void complete(NumberInfo num) {
        DLockInfo lockKey = num.getLockInfo();
        try {
            if (num.isRunning()) {
                this.dLock.unlock(lockKey);
            }
        }
        finally {
            num.completeExecute();
        }
    }
}

