/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.distributedLock;

import com.efuture.common.utils.ServiceLogs;
import com.efuture.ocp.common.distributedLock.DLock;
import com.efuture.ocp.common.distributedLock.DLockInfo;
import com.efuture.ocp.common.distributedLock.DistributedLockHandle;
import com.efuture.ocp.common.distributedLock.DistributedLockKeyHandle;
import com.efuture.ocp.common.distributedLock.exception.DistributedLockCacheException;
import com.efuture.ocp.common.distributedLock.exception.DistributedLockGetKeyException;
import com.efuture.ocp.common.distributedLock.exception.DistributedLockIsExistException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DistributedLockAspect {
    @Autowired
    DistributedLockHandle lockHandle;
    @Autowired
    DistributedLockKeyHandle keyHandle;

    @Around(value="@annotation(around)")
    public Object round(ProceedingJoinPoint point, DLock around) throws Throwable {
        ServiceLogs.debug((String)"DistributedLock", (String)"\u5f00\u59cb\u6267\u884c", (long)0L, (Object[])new Object[0]);
        String lockKey = "";
        try {
            lockKey = this.keyHandle.getKey(point, around);
        }
        catch (Exception e) {
            ServiceLogs.error((String)"DistributedLock", (Throwable)e, (String)"\u83b7\u53d6\u9501\u7684key\u5931\u8d25", (long)0L, (Object[])new Object[0]);
            throw new DistributedLockGetKeyException("50000", "\u83b7\u53d6\u9501\u7684key\u5931\u8d25[{0}]", e.getMessage());
        }
        ServiceLogs.debug((String)"DistributedLock", (String)("\u83b7\u53d6\u5230Key:" + lockKey), (long)0L, (Object[])new Object[0]);
        int lockExpire = around.lockExpire();
        DLockInfo lock = null;
        try {
            lock = this.lockHandle.tryLock(lockKey, lockExpire, around.waitMillSeconds());
        }
        catch (Exception e) {
            ServiceLogs.error((String)"DistributedLock", (Throwable)e, (String)"\u83b7\u53d6\u9501\u5931\u8d25[{0}]", (long)0L, (Object[])new Object[0]);
            throw new DistributedLockCacheException("50000", "\u83b7\u53d6\u9501\u5931\u8d25[{0}]", lockKey);
        }
        if (lock == null) {
            throw new DistributedLockIsExistException("50000", "\u83b7\u53d6\u9501\u5931\u8d25[{0}]", lockKey);
        }
        Object result = null;
        try {
            result = point.proceed();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            this.lockHandle.unlock(lock);
        }
        return result;
    }
}

