package com.efuture.common.autoconfig;

import com.efuture.common.web.rest.FutureRestUrlPathHelper;
import com.efuture.common.web.argument.SessionArgumentResolver;
import com.efuture.common.web.controller.ExceptionControllerAdvice;
import com.efuture.common.web.controller.SessionAndLogWebInterceptor;
import com.efuture.common.web.filter.LoggingBodyFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.List;

@Configuration
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
public class WebAutoConfiguration implements WebMvcConfigurer
{

    SessionAndLogWebInterceptor sessionAndLogWebInterceptor;

    public WebAutoConfiguration(SessionAndLogWebInterceptor sessionAndLogWebInterceptor)
    {
        this.sessionAndLogWebInterceptor = sessionAndLogWebInterceptor;
    }

    /**
     * 1.增加拦截器
     * 解析session和记录日志的拦截器
     *
     * @param registry
     */
    @Override
    public void addInterceptors(InterceptorRegistry registry)
    {
        registry.addInterceptor(sessionAndLogWebInterceptor);
    }

    /**
     * 1.增加session参数解析器
     * @param resolvers
     */
    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers)
    {
        resolvers.add(new SessionArgumentResolver());
    }

    /**
     * 增加 路径解析器
     * @param configurer
     */
    @Override
    public void  configurePathMatch(PathMatchConfigurer configurer)
    {
        configurer.setUrlPathHelper(new FutureRestUrlPathHelper());
    }
    @Configuration
    protected static class SessionWebInterceptorAutoConfig
    {

        @Bean
        @ConditionalOnMissingBean
        public SessionAndLogWebInterceptor newSessionWebInterceptor()
        {
            return new SessionAndLogWebInterceptor();
        }

    }


    @Configuration
    protected static class FilterAutoConfig
    {

        @Bean
        @Order(value = 0)
        public FilterRegistrationBean loggingBodyFilter()
        {
            FilterRegistrationBean filter = new FilterRegistrationBean(new LoggingBodyFilter());
            filter.addUrlPatterns("/*");
            return filter;
        }
    }

    @Configuration
    protected static class ControllerAdviceAutoConfig
    {

        @Bean
        @ConditionalOnMissingBean
        public ExceptionControllerAdvice exceptionControllerAdvice()
        {
            return new ExceptionControllerAdvice();
        }
    }

}
