package com.efuture.common.web.rest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;

import java.util.ArrayList;
import java.util.List;

public class FutureRestBeanNameUrlHandlerMapping extends BeanNameUrlHandlerMapping
{

    Logger log = LoggerFactory.getLogger(FutureRestBeanNameUrlHandlerMapping.class);

    @Override
    protected String[] determineUrlsForHandler(String beanName)
    {
        log.debug("zhouwd:FutureRestBeanNameUrlHandlerMapping------------" + beanName);
        List<String> urls = new ArrayList<>();

        if (beanName.startsWith("/")) {
            urls.add(beanName);
        }

        String[] aliases = obtainApplicationContext().getAliases(beanName);

        for (String alias : aliases) {
            if (alias.startsWith("/")) {
                urls.add(alias);
            }
        }

        return StringUtils.toStringArray(urls);
    }
}
