package com.efuture.common.web.rest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UrlPathHelper;

import javax.servlet.http.HttpServletRequest;

public class FutureRestUrlPathHelper extends UrlPathHelper
{
    Logger log = LoggerFactory.getLogger(FutureRestUrlPathHelper.class);

    //    @Override
    //    public String getLookupPathForRequest(HttpServletRequest request, @Nullable String lookupPathAttributeName) {
    //        log.debug("zhouwd:getLookupPathForRequest:start-------------------------------------------------------------------------------------");
    //        String rtn = super.getLookupPathForRequest(request, lookupPathAttributeName);
    //        log.debug("zhouwd:getLookupPathForRequest:end-------------------------------------------------------------------------------------");
    //        return rtn;
    //    }

    private boolean isFutureRest(String url)
    {
        if (url.equalsIgnoreCase("/cgop-query-webin/rest")) {
            return true;
        }
        else {
            return false;
        }
    }

    private String getLookupPathForRequestByMethod(HttpServletRequest request)
    {
        String method = request.getParameter("method");
        int lastdot = method.lastIndexOf(".");
        String beanName = method.substring(0, lastdot);
        String funName = method.substring(lastdot + 1);
        return "/" + beanName + "/" + funName;
    }

    @Override
    public String getLookupPathForRequest(HttpServletRequest request)
    {
        log.debug("zhouwd:getLookupPathForRequest:start-------------------------------------------------------------------------------------");
        String url = request.getRequestURI();
        String rtn = null;

        if (isFutureRest(url)) {
            rtn = getLookupPathForRequestByMethod(request);
        }
        else {
            rtn = super.getLookupPathForRequest(request);
        }

        log.debug("zhouwd:getLookupPathForRequest:end-------------------------------------------------------------------------------------");
        return rtn;
    }
}
