package com.efuture.common.web.utils;

import org.springframework.util.AntPathMatcher;

import java.util.List;

/**
 * Url utils
 *
 * @author：恒宇少年 - 于起宇
 * <p>
 * DateTime：2019/9/15 4:52 下午
 * Blog：http://blog.yuqiyu.com
 * WebSite：http://www.jianshu.com/u/092df3f77bca
 * Gitee：https://gitee.com/hengboy
 * GitHub：https://github.com/hengboy
 */
public class UrlUtils
{
    /**
     * check uri is ignore
     *
     * @param ignoreUrls ignore urls
     * @param uri        wait check uri
     * @return check result
     */
    public static boolean isIgnore(List<String> ignoreUrls, String uri)
    {
        // check is matcher ant path
        for (String ignoreUri : ignoreUrls) {
            AntPathMatcher matcher = new AntPathMatcher();
            boolean isMatcher = matcher.match(ignoreUri, uri);

            if (isMatcher) {
                return true;
            }
        }

        return false;
    }
}