package com.efuture.common.web.controller;

import com.efuture.common.web.session.ServiceSession;
import com.efuture.common.web.session.ServiceSessionUtils;
import com.efuture.ocp.common.exception.ResponseCode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 统一响应
 */
public class ResultVO implements Serializable
{
    private static final long serialVersionUID = 8592349743899783777L;

    private String returncode;
    private List<String> msg;
    private Object data;
    private String logkey;


    private ResultVO(Object data)
    {
        this(ResponseCode.SUCCESS, data);
    }

    private ResultVO(String code, Object data)
    {
        this.returncode = code;
        this.data = data;
    }

    private ResultVO(String returncode, String msg, Object data, String logkey)
    {
        this.returncode = returncode;
        this.msg = new ArrayList<>();
        this.msg.add(msg);
        this.data = data;
        this.logkey = logkey;
    }

    private ResultVO(String returncode, String msg, Object data)
    {
        ServiceSession session = ServiceSessionUtils.getLocalSession();
        this.returncode = returncode;
        this.msg = new ArrayList<>();
        this.msg.add(msg);
        this.data = data;
        this.logkey = session.getRootkey();
    }

    public static ResultVO failure(String returncode, String msg)
    {
        return new ResultVO(returncode, msg, null);
    }

    public static ResultVO failure(String msg)
    {
        return new ResultVO(ResponseCode.FAILURE, msg, msg);
    }

    public static ResultVO success(Object data)
    {
        return new ResultVO(ResponseCode.SUCCESS, data);
    }

    public String getReturncode()
    {
        return returncode;
    }

    public void setReturncode(String returncode)
    {
        this.returncode = returncode;
    }

    public List<String> getMsg()
    {
        return msg;
    }

    public void setMsg(List<String> msg)
    {
        this.msg = msg;
    }

    public Object getData()
    {
        return data;
    }

    public void setData(Object data)
    {
        this.data = data;
    }

    public String getLogkey()
    {
        return logkey;
    }

    public void setLogkey(String logkey)
    {
        this.logkey = logkey;
    }
}
