package com.efuture.common.web.session;

import cn.hutool.core.convert.Convert;
import com.efuture.common.web.utils.HttpReqUtils;
import com.efuture.common.web.utils.LogIdUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

public class ServiceSessionUtils
{


    public static ServiceSession createSessionFromHttpRequest(HttpServletRequest request)
    {
        ServiceSession session = new ServiceSession();
        Map param = HttpReqUtils.getPathParams(request);
        long entId = getLong(param, "ent_id", 0);
        long userId = getLong(param, "user_id", 0);
        String userName = getString(param, "user_name", "efuture");
        String locale = getString(param, "locale", "");
        String logKey = LogIdUtils.getLogId();
        String rootKey = getString(param, "rootkey", logKey);
        String parentkey = getString(param, "logkey", logKey);
        String debug = getString(param, "debug_status", "");
        session.setEnt_id(entId);
        session.setUser_id(userId);
        session.setUser_name(userName);
        session.setLocale(locale);
        session.setLogkey(logKey);
        session.setRootkey(rootKey);
        session.setParentkey(parentkey);
        session.setDebug_status(debug);
        return session;
    }


    public static ServiceSession createLocalSessionFromHttpRequest(HttpServletRequest request)
    {
        ServiceSession session = createSessionFromHttpRequest(request);
        GlobSessionThreadLocal.set(session);
        return session;
    }


    public static ServiceSession getLocalSession()
    {
        return GlobSessionThreadLocal.get();
    }

    public static void removeLocalSession()
    {
        GlobSessionThreadLocal.remove();
    }

    private static String getString(Map param, String key, String defaultValue)
    {
        return Convert.convert(String.class, param.getOrDefault(key, defaultValue));
    }

    private static Long getLong(Map param, String key, long defaultValue)
    {
        return Convert.convert(Long.class, param.getOrDefault(key, defaultValue));
    }

}
