/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.web.session;

import cn.hutool.core.convert.Convert;
import com.efuture.common.web.session.GlobSessionThreadLocal;
import com.efuture.common.web.session.ServiceSession;
import com.efuture.common.web.utils.HttpReqUtils;
import com.efuture.common.web.utils.LogIdUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ServiceSessionUtils {
    public static ServiceSession createSessionFromHttpRequest(HttpServletRequest request) {
        ServiceSession session = new ServiceSession();
        Map param = HttpReqUtils.getPathParams(request);
        long entId = ServiceSessionUtils.getLong(param, "ent_id", 0L);
        long userId = ServiceSessionUtils.getLong(param, "user_id", 0L);
        String userName = ServiceSessionUtils.getString(param, "user_name", "efuture");
        String locale = ServiceSessionUtils.getString(param, "locale", "");
        String logKey = LogIdUtils.getLogId();
        String rootKey = ServiceSessionUtils.getString(param, "rootkey", logKey);
        String parentkey = ServiceSessionUtils.getString(param, "logkey", logKey);
        session.setEnt_id(entId);
        session.setUser_id(userId);
        session.setUser_name(userName);
        session.setLocale(locale);
        session.setLogkey(logKey);
        session.setRootkey(rootKey);
        session.setParentkey(parentkey);
        return session;
    }

    public static ServiceSession createLocalSessionFromHttpRequest(HttpServletRequest request) {
        ServiceSession session = ServiceSessionUtils.createSessionFromHttpRequest(request);
        GlobSessionThreadLocal.set((ServiceSession)session);
        return session;
    }

    public static ServiceSession getLocalSession() {
        return GlobSessionThreadLocal.get();
    }

    public static void removeLocalSession() {
        GlobSessionThreadLocal.remove();
    }

    private static String getString(Map param, String key, String defaultValue) {
        return (String)Convert.convert(String.class, (Object)param.getOrDefault(key, defaultValue));
    }

    private static Long getLong(Map param, String key, long defaultValue) {
        return (Long)Convert.convert(Long.class, (Object)param.getOrDefault(key, defaultValue));
    }
}

