package com.efuture.common.web.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageNotReadableException;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;

/**
 * 自定义转换，把Session写到入参对象中
 */
public class CustomFastJsonHttpMessageConverter extends FastJsonHttpMessageConverter
{


    @Override
    protected Object readInternal(Class<? extends Object> clazz, //
                                  HttpInputMessage inputMessage //
                                 ) throws IOException
    {
        return readType(getType(clazz, null), inputMessage);
    }


    private String getBodyStr(HttpInputMessage inputMessage)
    {
        return null;
    }

    private Object readType(Type type, HttpInputMessage inputMessage) throws IOException
    {
        try {
            InputStream in = inputMessage.getBody();
            return JSON.parseObject(in, this.getFastJsonConfig().getCharset(), type, this.getFastJsonConfig().getFeatures());
        }
        catch (JSONException ex) {
            throw new HttpMessageNotReadableException("JSON parse error: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new HttpMessageNotReadableException("I/O error while reading input message", ex);
        }
    }
}
