/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.efuture.redis.component.RedisClient;
import com.efuture.redis.constant.RedisConstant;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.product.component.BaseCompomentServiceImpl;
import com.product.controller.ProductController;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public abstract class RedisCompomentServiceImpl<X>
extends BaseCompomentServiceImpl<RedisClient, X> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductController.class);
    private int keepSeconds;
    private List<String> indexFields;

    public int getKeepSeconds() {
        return this.keepSeconds;
    }

    public void setKeepSeconds(int keepSeconds) {
        this.keepSeconds = keepSeconds;
    }

    public List<String> getIndexFields() {
        return this.indexFields;
    }

    public void setIndexFields(List<String> indexFields) {
        this.indexFields = indexFields;
    }

    public RedisCompomentServiceImpl(String collectionName, String keyfieldName) {
        super(collectionName, keyfieldName);
    }

    @Override
    protected long onCount(ServiceSession session, RedisClient template, Query query, String collectionName) {
        DBObject dbQuery = query.getQueryObject();
        String redisQuery = null;
        ArrayList<String> otherKeys = new ArrayList<String>();
        Set keySet = dbQuery.keySet();
        try {
            for (String keyName : keySet) {
                if (StringUtils.isEmpty(redisQuery)) {
                    redisQuery = String.format("%1$s:%2$s:%3$s", this.getCollectionName(), keyName, dbQuery.get(keyName));
                    continue;
                }
                otherKeys.add(String.format("%1$s:%2$s:%3$s", this.getCollectionName(), keyName, dbQuery.get(keyName)));
            }
        }
        catch (Exception e) {
            LOGGER.error("onCount\u6267\u884c\u5f02\u5e38, \u67e5\u8be2\u6761\u4ef6:query--" + query + ", collectionName--" + collectionName);
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return template.onCount(this.getCollectionName(), redisQuery, otherKeys);
    }

    @Override
    protected <T> List<T> onFind(ServiceSession session, RedisClient template, Query query, Class<T> entityClass, String collectionName) {
        ArrayList<Object> response = new ArrayList<Object>();
        try {
            List dataList;
            Object dataRow;
            String data;
            ArrayList fieldList = new ArrayList();
            ArrayList<String> operatorList = new ArrayList<String>();
            ArrayList<Object> argslist = new ArrayList<Object>();
            DBObject dbQuery = query.getQueryObject();
            int limit = query.getLimit();
            int skip = query.getSkip();
            String redisQuery = null;
            boolean isLuaQuery = false;
            ArrayList<String> otherKeys = new ArrayList<String>();
            Set keySet = dbQuery.keySet();
            for (Iterator keyName : keySet) {
                Object dbValue = dbQuery.get((String)((Object)keyName));
                if (StringUtils.isEmpty(redisQuery)) {
                    redisQuery = String.format("%1$s:%2$s:%3$s", this.getCollectionName(), keyName, dbValue);
                } else {
                    otherKeys.add(String.format("%1$s:%2$s:%3$s", this.getCollectionName(), keyName, dbValue));
                }
                if (dbValue instanceof Map) {
                    isLuaQuery = true;
                    Map dataRow2 = (Map)dbValue;
                    Set operKeys = dataRow2.keySet();
                    for (String operKey : operKeys) {
                        Object operValue = dataRow2.get(operKey);
                        if ("=".equals(operKey)) {
                            fieldList.add(keyName);
                            operatorList.add("=");
                            argslist.add(operValue);
                            continue;
                        }
                        if (">".equals(operKey)) {
                            fieldList.add(keyName);
                            operatorList.add(">");
                            argslist.add(operValue);
                            continue;
                        }
                        if (">=".equals(operKey)) {
                            fieldList.add(keyName);
                            operatorList.add(">=");
                            argslist.add(operValue);
                            continue;
                        }
                        if ("<".equals(operKey)) {
                            fieldList.add(keyName);
                            operatorList.add("<");
                            argslist.add(operValue);
                            continue;
                        }
                        if ("<=".equals(operKey)) {
                            fieldList.add(keyName);
                            operatorList.add("<=");
                            argslist.add(operValue);
                            continue;
                        }
                        if ("!=".equals(operKey)) {
                            fieldList.add(keyName);
                            operatorList.add("!=");
                            argslist.add(operValue);
                            continue;
                        }
                        if ("like".equals(operKey)) {
                            fieldList.add(keyName);
                            operatorList.add("like");
                            argslist.add(operValue);
                            continue;
                        }
                        if (!"in".equals(operKey)) continue;
                        fieldList.add(keyName);
                        operatorList.add("in");
                        if (operValue instanceof List) {
                            argslist.add(operValue);
                            continue;
                        }
                        ArrayList sublist = new ArrayList();
                        sublist.add(operValue);
                        argslist.add(sublist);
                    }
                    continue;
                }
                if (dbValue instanceof List) {
                    isLuaQuery = true;
                    fieldList.add(keyName);
                    operatorList.add("in");
                    argslist.add(dbValue);
                    continue;
                }
                fieldList.add(keyName);
                operatorList.add("=");
                argslist.add(dbValue);
            }
            if (isLuaQuery) {
                List results = null;
                LOGGER.info("... queryByLua \u67e5\u8be2\u5230\u7ed3\u679c\u96c6\uff1a" + results.size());
                for (String id : results) {
                    Map dataMap = template.onQueryById(this.getCollectionName(), id);
                    data = JSON.toJSONString((Object)dataMap);
                    dataRow = JSON.parseObject((String)data, entityClass);
                    response.add(dataRow);
                }
            } else if (keySet.size() < 1) {
                dataList = template.onQueryPage(this.getCollectionName(), limit, skip, RedisConstant.Sort.nosort);
                for (Map dataMap : dataList) {
                    String data2 = JSON.toJSONString((Object)dataMap);
                    Object dataRow3 = JSON.parseObject((String)data2, entityClass);
                    response.add(dataRow3);
                }
            } else {
                dataList = template.onQueryPageByCondition(RedisConstant.Sort.nosort, this.getCollectionName(), skip, limit, redisQuery, otherKeys);
                List mapList = template.onQueryByIdList(this.getCollectionName(), dataList);
                for (Map dataMap : mapList) {
                    data = JSON.toJSONString((Object)dataMap);
                    dataRow = JSON.parseObject((String)data, entityClass);
                    response.add(dataRow);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("onFind\u6267\u884c\u5f02\u5e38, \u67e5\u8be2\u6761\u4ef6:query--" + query + ", collectionName--" + collectionName);
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    protected DBObject onDefaultRowInsert(Query query, Update update) {
        BasicDBObject dbInsert = new BasicDBObject();
        DBObject dbUpdateObject = update.getUpdateObject();
        Object oDataSet = dbUpdateObject.get("$set");
        Object oDataInsert = dbUpdateObject.get("$setOnInsert");
        if (oDataSet != null && oDataSet instanceof DBObject) {
            dbInsert.putAll((BSONObject)((DBObject)oDataSet));
        }
        if (oDataInsert != null && oDataInsert instanceof DBObject) {
            dbInsert.putAll((BSONObject)((DBObject)oDataInsert));
        }
        dbInsert.putAll((BSONObject)query.getQueryObject());
        return dbInsert;
    }

    @Override
    protected void onUpsert(ServiceSession session, RedisClient template, Query query, Update update, String collectionName) {
        DBObject dbQuery = query.getQueryObject();
        String primaryKey = TypeUtils.castToString((Object)dbQuery.get(this.getKeyfieldName()));
        HashMap updateRow = new HashMap();
        HashMap InsertRow = new HashMap();
        Set keys = update.getUpdateObject().keySet();
        for (String keyname : keys) {
            if ("$set".equalsIgnoreCase(keyname)) {
                BasicDBObject updateMap = (BasicDBObject)update.getUpdateObject().get(keyname);
                updateRow.putAll(updateMap);
                continue;
            }
            if (!"$setOnInsert".equalsIgnoreCase(keyname)) continue;
            BasicDBObject insertMap = (BasicDBObject)update.getUpdateObject().get(keyname);
            updateRow.putAll(insertMap);
        }
        template.onRowUpsert(this.getCollectionName(), updateRow, InsertRow, primaryKey, this.getIndexFields(), this.getKeepSeconds());
    }

    @Override
    protected int onInsertd(ServiceSession session, RedisClient template, JSONObject dataRow, String collectionName) {
        String primaryKey = dataRow.getString(this.getKeyfieldName());
        System.out.println("name--->" + this.getCollectionName() + "  key->" + primaryKey + " data--->" + JSON.toJSONString((Object)dataRow));
        template.onRowInsert(this.getCollectionName(), (Map)dataRow, primaryKey, this.getIndexFields(), this.getKeepSeconds());
        return 1;
    }

    @Override
    protected void onInsert(ServiceSession session, RedisClient template, JSONObject dataRow, String collectionName) {
        String primaryKey = dataRow.getString(this.getKeyfieldName());
        System.out.println("name--->" + this.getCollectionName() + "  key->" + primaryKey + " data--->" + JSON.toJSONString((Object)dataRow));
        template.onRowInsert(this.getCollectionName(), (Map)dataRow, primaryKey, this.getIndexFields(), this.getKeepSeconds());
    }

    @Override
    protected void onRemove(ServiceSession session, RedisClient template, Query query, String collectionName) {
        DBObject dbQuery = query.getQueryObject();
        String primaryKey = TypeUtils.castToString((Object)dbQuery.get(this.getKeyfieldName()));
        template.onRowDelete(this.getCollectionName(), primaryKey, this.getIndexFields());
    }
}

