/*
 * Decompiled with CFR 0.152.
 */
package com.product.config;

import com.efuture.prop.util.PropertiesBindingPostProcessor;
import com.efuture.redis.MyJedisPoolConfig;
import com.efuture.redis.component.FtJedisPool;
import com.product.component.AuthorityBaseServiceImpl;
import com.product.component.EasyDataSource;
import com.product.config.FtJedisPoolConfig;
import com.product.controller.ProductReflect;
import com.product.language.MessageSourceHelper;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.UniqueID;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcTemplate;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@EnableAutoConfiguration
public class BaseConfiger {
    @Autowired
    @Qualifier(value="sqlSessionFactory")
    SqlSessionFactoryBean sqlSessionFactory;
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    protected ResourceLoader resourceLoader = new DefaultResourceLoader();

    @Bean(name={"UniqueID"})
    UniqueID onUniqueIDTemplate() throws Exception {
        UniqueID instance = new UniqueID();
        instance.setHostId("120");
        return instance;
    }

    @Bean(name={"datasource"})
    @Qualifier(value="datasource")
    @ConfigurationProperties(prefix="spring.datasource")
    @Primary
    public EasyDataSource onDruidDataSource() {
        EasyDataSource service = new EasyDataSource();
        service.setMaxActive(200);
        service.setMinIdle(20);
        return service;
    }

    @Bean(name={"JdbcTemplate"})
    public JdbcTemplate onJdbcTemplate(@Qualifier(value="datasource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Autowired
    @Bean(name={"sqlSessionFactory"})
    public SqlSessionFactoryBean onSqlSessionFactoryBean(@Qualifier(value="datasource") DataSource datasource) {
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        Resource resource = this.resourceLoader.getResource("classpath:mybatis-config.xml");
        service.setConfigLocation(resource);
        service.setDataSource(datasource);
        return service;
    }

    @Bean(name={"StorageOperation"})
    public FMybatisTemplate onFMybatisTemplate(@Qualifier(value="sqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new FMybatisTemplate(sqlSessionFactory, ExecutorType.BATCH);
    }

    @Bean(name={"ServiceMethodReflect"})
    public ProductReflect onProductReflect() {
        return new ProductReflect();
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource onResourceBundleMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"message"});
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    @Bean(name={"messageSourceHelper"})
    public MessageSourceHelper onMessageSourceHelper() {
        MessageSourceHelper messageSourceHelper = new MessageSourceHelper();
        messageSourceHelper.setMessageSource(this.onResourceBundleMessageSource());
        return messageSourceHelper;
    }

    @Bean(name={"authorityBaseServiceImpl"})
    public AuthorityBaseServiceImpl onAuthorityBaseServiceImpl() {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = new AuthorityBaseServiceImpl();
        return authorityBaseServiceImpl;
    }

    @Bean(name={"jedisPoolConfig"})
    @Qualifier(value="jedisPoolConfig")
    public FtJedisPoolConfig onJedisPoolConfig() {
        FtJedisPoolConfig service = null;
        try {
            service = (FtJedisPoolConfig)((Object)PropertiesBindingPostProcessor.init((ResourceLoader)this.resourceLoader, (Environment)this.environment, FtJedisPoolConfig.class));
        }
        catch (Exception e) {
            System.out.println("--------------> null");
            StringWriter stringWriter = new StringWriter();
            PrintWriter PrintWriter2 = new PrintWriter(stringWriter);
            e.printStackTrace(PrintWriter2);
        }
        return service;
    }

    @Bean(name={"jedisPool"})
    @Qualifier(value="jedisPool")
    public FtJedisPool onJedisPool(@Qualifier(value="jedisPoolConfig") MyJedisPoolConfig config) {
        System.out.println(String.format("redisHost=%1$s redisPort=%2$d", config.getHost(), config.getPort()));
        FtJedisPool service = null;
        try {
            String maxActive = this.environment.getProperty("spring.redis.pool.max-active");
            String maxWait = this.environment.getProperty("spring.redis.pool.max-wait");
            String maxIdle = this.environment.getProperty("spring.redis.pool.max-idle");
            String minIdle = this.environment.getProperty("spring.redis.pool.min-idle");
            config.setMaxTotal(Integer.parseInt(maxActive));
            config.setMaxWaitMillis((long)Integer.parseInt(maxWait));
            config.setMaxIdle(Integer.parseInt(maxIdle));
            config.setMinIdle(Integer.parseInt(minIdle));
            String password = this.environment.getProperty("spring.redis.password");
            String timeout = this.environment.getProperty("spring.redis.timeout");
            service = StringUtils.isEmpty((String)password) ? new FtJedisPool((JedisPoolConfig)config, config.getHost(), config.getPort().intValue(), Integer.parseInt(timeout)) : new FtJedisPool((JedisPoolConfig)config, config.getHost(), config.getPort().intValue(), Integer.parseInt(timeout), password);
        }
        catch (Exception e) {
            System.out.println("--------------> null");
        }
        return service;
    }
}

