/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.slice.filter;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.fastjson.JSONObject;
import com.product.storage.filter.FtSqlSource;
import com.product.storage.slice.filter.CollectionDeleteWrapper;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Invocation;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class CollectionUpdateWrapper
extends CollectionDeleteWrapper {
    protected void onUpdateStatement(Logger logger, JSONObject logJson, Invocation invocation, MappedStatement mappedStatement, BoundSql boundSql, SQLStatement stmt, String partionKey) throws Throwable {
        SQLUpdateStatement updateStmt = (SQLUpdateStatement)stmt;
        String collectionName = updateStmt.getTableName().getSimpleName();
        SQLBinaryOpExpr newWhereExpr = new SQLBinaryOpExpr();
        String authWhereSql = this.getPartionWhere(collectionName, partionKey);
        if (!StringUtils.isEmpty((Object)authWhereSql)) {
            SQLExpr authWhereExpr = this.getWhereInfo(authWhereSql);
            if (updateStmt.getWhere() != null && updateStmt.getWhere() instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr whereExpr = (SQLBinaryOpExpr)updateStmt.getWhere();
                if (whereExpr != null) {
                    newWhereExpr.setOperator(SQLBinaryOperator.BooleanAnd);
                    newWhereExpr.setLeft((SQLExpr)whereExpr);
                    newWhereExpr.setRight(authWhereExpr);
                }
            } else {
                newWhereExpr = authWhereExpr;
            }
            updateStmt.setWhere((SQLExpr)newWhereExpr);
        }
        StringBuffer newSql = new StringBuffer();
        MySqlOutputVisitor visitor = null;
        if (this.getDbType().equals("mysql")) {
            visitor = new MySqlOutputVisitor((Appendable)newSql);
        } else if (this.getDbType().equals("oracle")) {
            visitor = new OracleOutputVisitor((Appendable)newSql);
        } else {
            throw new Exception("\u672a\u8bc6\u522b\u7684dbType");
        }
        visitor.visit(updateStmt);
        visitor.println();
        visitor.endVisit(updateStmt);
        FtSqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newSql.toString(), boundSql);
        MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, sqlSource);
        invocation.getArgs()[0] = newMs;
        logJson.put("newSql", (Object)newSql.toString());
        logger.info((Object)String.format("newSQL --->%1$s", newSql.toString()));
    }
}

