/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.slice.filter;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.fastjson.JSONObject;
import com.product.storage.slice.filter.CollectionInsertWrapper;
import com.product.storage.slice.filter.ExecutorCallback;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class ExecutorSliceWrapper
extends CollectionInsertWrapper
implements Interceptor {
    private static Logger logger = Logger.getLogger((String)"sqlLog");

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String sqlStatement = "";
        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[1];
        }
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        sqlStatement = boundSql.getSql();
        logger.info((Object)String.format("intercept--->1--->%1$s", sqlStatement));
        String organizationCode = "";
        Object paramsValue = boundSql.getParameterObject();
        if (paramsValue instanceof Map) {
            Map paramsMap = (Map)paramsValue;
            organizationCode = paramsMap.get("@datakey").toString();
        }
        boolean isexec = false;
        if (this.isWrapper(sqlStatement, organizationCode)) {
            isexec = true;
        }
        if (!isexec) {
            return invocation.proceed();
        }
        final String partionKey = organizationCode;
        ExecutorCallback callback = new ExecutorCallback(){

            @Override
            public void onAction(SQLSelectQueryBlock query, String collectionName, String collectionAlias) {
                SQLBinaryOpExpr newWhereExpr = new SQLBinaryOpExpr();
                String authWhereSql = ExecutorSliceWrapper.this.getPartionWhere(collectionName, partionKey);
                if (!StringUtils.isEmpty((Object)authWhereSql)) {
                    SQLExpr authWhereExpr = ExecutorSliceWrapper.this.getWhereInfo(authWhereSql);
                    if (query.getWhere() != null && query.getWhere() instanceof SQLBinaryOpExpr) {
                        SQLBinaryOpExpr whereExpr = (SQLBinaryOpExpr)query.getWhere();
                        if (whereExpr != null) {
                            newWhereExpr.setOperator(SQLBinaryOperator.BooleanAnd);
                            newWhereExpr.setLeft((SQLExpr)whereExpr);
                            newWhereExpr.setRight(authWhereExpr);
                        }
                    } else {
                        newWhereExpr = authWhereExpr;
                    }
                    query.setWhere((SQLExpr)newWhereExpr);
                }
            }
        };
        try {
            JSONObject logJson = new JSONObject();
            List statementList = SQLUtils.toStatementList((String)sqlStatement, (String)this.getDbType());
            for (SQLStatement stmt : statementList) {
                logJson.put("selectSql", (Object)sqlStatement);
                if (stmt instanceof SQLSelectStatement) {
                    this.onSelectStatement(logger, sqlStatement, logJson, invocation, mappedStatement, boundSql, stmt, callback);
                    continue;
                }
                if (stmt instanceof SQLUpdateStatement) {
                    this.onUpdateStatement(logger, logJson, invocation, mappedStatement, boundSql, stmt, partionKey);
                    continue;
                }
                if (stmt instanceof SQLDeleteStatement) {
                    this.onDeleteStatement(logger, logJson, invocation, mappedStatement, boundSql, stmt, partionKey);
                    continue;
                }
                if (!(stmt instanceof SQLInsertStatement)) continue;
                this.onInsertStatement(logger, logJson, invocation, mappedStatement, boundSql, stmt, partionKey);
            }
        }
        catch (Exception e) {
            invocation.getArgs()[0] = mappedStatement;
            logger.info((Object)String.format("newSQL --->Faiure:%1$s ---> %2$s", e.getMessage() + "", sqlStatement));
            JSONObject errorJson = new JSONObject();
            errorJson.put("unresolved sql", (Object)sqlStatement);
            e.printStackTrace();
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String dbType = properties.getProperty("dbType");
        if (dbType == null || dbType.equals("")) {
            this.setDbType("mysql");
        } else {
            this.setDbType(dbType);
        }
    }
}

