/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.servlet.view.document.AbstractXlsxStreamingView;

public class ExcelStreamView
extends AbstractXlsxStreamingView {
    private String fileName = "reponse";
    private int rowNum = 0;
    private Workbook workbook;
    private Sheet sheet;
    List<Object> headList;
    List<Object> fieldList;
    List<Object> dataList;

    public ExcelStreamView(List<Object> headList, List<Object> fieldList, List<Object> dataList) {
        this.headList = headList;
        this.fieldList = fieldList;
        this.dataList = dataList;
    }

    protected void buildExcelDocument(Map<String, Object> model, Workbook workbook, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.workbook = workbook;
        this.sheet = workbook.createSheet("page-1");
        this.setHead();
        this.setBody();
        response.setHeader("Content-disposition", "attachment;filename=" + this.fileName + ".xlsx");
    }

    private void setBody() {
        for (int j = 0; j < this.dataList.size(); ++j) {
            JSONObject data = JSONObject.parseObject((String)JSON.toJSONString((Object)this.dataList.get(j)));
            Row row = this.sheet.createRow(this.rowNum++);
            for (int i = 0; i < this.fieldList.size(); ++i) {
                String s = this.fieldList.get(i).toString();
                Cell cell = row.createCell(i);
                Object value = data.get(s);
                if (value == null) {
                    value = "";
                }
                if (value instanceof Number) {
                    cell.setCellValue(Double.valueOf(String.valueOf(value)).doubleValue());
                    continue;
                }
                if (value instanceof Timestamp) {
                    cell.setCellValue(new Date(((Timestamp)value).getTime()));
                    continue;
                }
                if (value instanceof Date) {
                    cell.setCellValue((Date)value);
                    continue;
                }
                if (value instanceof Calendar) {
                    cell.setCellValue((Calendar)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    cell.setCellValue(((Boolean)value).booleanValue());
                    continue;
                }
                cell.setCellValue(String.valueOf(value));
            }
        }
    }

    public void setHead() {
        this.rowNum = 0;
        Row row = this.sheet.createRow(this.rowNum++);
        for (int i = 0; i < this.headList.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(this.headList.get(i).toString());
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }
}

