/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.product.util.RestUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class FileProcessorUtils {
    public static List<Map<String, Object>> parseFile(JSONObject jsonparam, InputStream in) throws Exception {
        String type = jsonparam.getString("type");
        String cols = jsonparam.getString("cols");
        int sheetIndex = jsonparam.getIntValue("sheetIndex");
        int startRow = jsonparam.getIntValue("startRow");
        Integer endRow = jsonparam.getInteger("endRow");
        String separator = jsonparam.getString("separator") == null ? "\t" : jsonparam.getString("separator");
        String content = jsonparam.getString("content");
        List<Map<String, Object>> result = null;
        if (type.equals("excel")) {
            result = FileProcessorUtils.parseExcel(cols, sheetIndex, startRow, endRow, in);
        }
        if (type.equals("txt")) {
            result = FileProcessorUtils.parseTxt(cols, separator, startRow, endRow, in);
        }
        if (type.equals("plain")) {
            result = FileProcessorUtils.parsePlain(content, separator, startRow, endRow);
        }
        return result;
    }

    public static List<Map<String, Object>> parseFile(JSONObject jsonparam) throws Exception {
        int startRow = jsonparam.getIntValue("startRow");
        Integer endRow = jsonparam.getInteger("endRow");
        String separator = jsonparam.getString("separator") == null ? "\t" : jsonparam.getString("separator");
        String content = jsonparam.getString("content");
        List<Map<String, Object>> result = FileProcessorUtils.parsePlain(content, separator, startRow, endRow);
        return result;
    }

    private static List<Map<String, Object>> parseExcel(String cols, int sheetIndex, int startRow, Integer endRow, InputStream in) throws Exception {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            Workbook wb = WorkbookFactory.create((InputStream)in);
            Sheet sheet = wb.getSheetAt(sheetIndex);
            String[] fieldArr = cols.split(",");
            HashMap<String, Object> dataMap = null;
            Row row = null;
            Cell cell = null;
            int lastRowNum = sheet.getLastRowNum();
            for (int currentRowNum = 0; currentRowNum <= lastRowNum; ++currentRowNum) {
                if (currentRowNum < startRow) continue;
                if (endRow == null || currentRowNum <= endRow) {
                    row = sheet.getRow(currentRowNum);
                    if (fieldArr.length == 0) {
                        return result;
                    }
                    dataMap = new HashMap<String, Object>();
                    for (int i = 0; i < fieldArr.length; ++i) {
                        if (fieldArr[i].equals("<none>")) continue;
                        if (i < row.getLastCellNum()) {
                            cell = row.getCell(i);
                            Object value = null;
                            if (cell == null) {
                                dataMap.put(fieldArr[i], value);
                                continue;
                            }
                            switch (cell.getCellType()) {
                                case 0: {
                                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                                        value = sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue())).toString();
                                        break;
                                    }
                                    value = new DecimalFormat("#.####").format(cell.getNumericCellValue());
                                    break;
                                }
                                case 1: {
                                    value = cell.getStringCellValue();
                                    break;
                                }
                                case 4: {
                                    value = cell.getBooleanCellValue();
                                    break;
                                }
                                case 3: {
                                    value = "";
                                    break;
                                }
                                case 5: {
                                    value = "\u975e\u6cd5\u5b57\u7b26";
                                    break;
                                }
                                default: {
                                    value = "";
                                }
                            }
                            dataMap.put(fieldArr[i], value);
                            continue;
                        }
                        dataMap.put(fieldArr[i], null);
                    }
                    result.add(dataMap);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new Exception("\u89e3\u6790excel\u6587\u4ef6\u5185\u5bb9\u51fa\u9519\uff1a" + e.getMessage());
        }
        return result;
    }

    private static List<Map<String, Object>> parseTxt(String cols, String separator, int startRow, Integer endRow, InputStream in) throws Exception {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        BufferedReader reader = null;
        String charset = "gbk";
        HashMap<String, String> dataMap = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in, charset));
            String lineStr = null;
            int currentRow = -1;
            while ((lineStr = reader.readLine()) != null) {
                if (++currentRow < startRow) continue;
                if (endRow != null && currentRow > endRow) {
                    break;
                }
                String[] fieldArr = cols.split(",");
                String[] valueArr = lineStr.split(separator);
                if (fieldArr.length == 0) {
                    ArrayList<Map<String, Object>> arrayList = result;
                    return arrayList;
                }
                dataMap = new HashMap<String, String>();
                for (int i = 0; i < fieldArr.length; ++i) {
                    if (fieldArr[i].equals("<none>")) continue;
                    if (i > valueArr.length - 1) {
                        dataMap.put(fieldArr[i], null);
                        continue;
                    }
                    dataMap.put(fieldArr[i], valueArr[i]);
                }
                result.add(dataMap);
            }
        }
        catch (Exception e) {
            throw new Exception("\u89e3\u6790\u6587\u672c\u6587\u4ef6\u5185\u5bb9\u51fa\u9519\uff1a" + e.getMessage());
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, Object>> parsePlain(String content, String separator, int startRow, Integer endRow) throws Exception {
        if (startRow == 0) {
            throw new Exception("\u5217\u6807\u9898\u7f3a\u5931");
        }
        String charset = "gbk";
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(charset));
        BufferedReader reader = null;
        HashMap<String, String> dataMap = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)in, charset));
            String lineStr = null;
            int currentRow = -1;
            boolean isHeadLine = false;
            String[] fieldArr = null;
            while ((lineStr = reader.readLine()) != null) {
                ++currentRow;
                if (!isHeadLine) {
                    isHeadLine = true;
                    fieldArr = lineStr.split(separator);
                }
                if (currentRow < startRow) continue;
                if (endRow != null && currentRow > endRow) {
                    break;
                }
                String[] valueArr = lineStr.split(separator);
                if (fieldArr.length == 0) {
                    ArrayList<Map<String, Object>> arrayList = result;
                    return arrayList;
                }
                dataMap = new HashMap<String, String>();
                for (int i = 0; i < fieldArr.length; ++i) {
                    if (fieldArr[i].equals("<none>")) continue;
                    if (i > valueArr.length - 1) {
                        dataMap.put(fieldArr[i], null);
                        continue;
                    }
                    dataMap.put(fieldArr[i], valueArr[i]);
                }
                result.add(dataMap);
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void exportFile(String type, String url, String jsonparam, String cols, String tname, String istree, String childname, OutputStream os) throws Exception {
        JSONObject jsonParam = JSONObject.parseObject((String)jsonparam);
        int pageNo = 1;
        int pageSize = 10000;
        JSONArray allDataList = new JSONArray();
        boolean hasNext = true;
        if (istree == null || !istree.equals("1")) {
            while (hasNext) {
                jsonParam.put("page_no", (Object)pageNo);
                jsonParam.put("page_size", (Object)pageSize);
                jsonparam = jsonParam.toJSONString();
                String respone = RestUtils.doPost(url, jsonparam);
                JSONObject result = JSONObject.parseObject((String)respone);
                Object data = result.get((Object)"data");
                String returncode = result.getString("returncode");
                if (returncode != null && !returncode.equals("0")) {
                    throw new Exception((String)data);
                }
                JSONArray dataList = ((JSONObject)data).getJSONArray(tname);
                if (dataList == null || dataList.isEmpty()) {
                    hasNext = false;
                    continue;
                }
                allDataList.addAll((Collection)dataList);
                ++pageNo;
            }
        } else {
            String respone = RestUtils.doPost(url, jsonparam);
            JSONObject result = JSONObject.parseObject((String)respone);
            Object data = result.get((Object)"data");
            String returncode = result.getString("returncode");
            if (returncode != null && !returncode.equals("0")) {
                throw new Exception((String)data);
            }
            JSONArray dataList = ((JSONObject)data).getJSONArray(tname);
            FileProcessorUtils.fillTreeDataToList(dataList, childname, allDataList);
        }
        if (type.equals("xls") || type.equals("xlsx")) {
            FileProcessorUtils.exportExcel(type, cols, allDataList, os);
        } else if (type.equals("txt")) {
            FileProcessorUtils.exportTxt(cols, allDataList, os);
        } else if (type.equals("json")) {
            FileProcessorUtils.exportJson(allDataList, os);
        } else if (type.equals("csv")) {
            FileProcessorUtils.exportCsv(cols, allDataList, os);
        } else if (type.equals("html")) {
            FileProcessorUtils.exportHtml(cols, allDataList, os);
        } else if (type.equals("xml")) {
            FileProcessorUtils.exportXml(cols, tname, allDataList, os);
        }
    }

    private static void fillTreeDataToList(JSONArray dataList, String childname, JSONArray allDataList) {
        if (dataList != null) {
            for (Object obj : dataList) {
                JSONObject jsonobj = (JSONObject)obj;
                JSONArray children = jsonobj.getJSONArray(childname);
                allDataList.add((Object)jsonobj);
                FileProcessorUtils.fillTreeDataToList(children, childname, allDataList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportExcel(String type, String cols, JSONArray result, OutputStream os) throws IOException {
        HSSFWorkbook wb = null;
        if (type.equals("xls")) {
            wb = new HSSFWorkbook();
        } else if (type.equals("xlsx")) {
            wb = new XSSFWorkbook();
        }
        int sheetNo = 1;
        Sheet sheet = wb.createSheet("Sheet" + sheetNo);
        sheet.setDefaultColumnWidth(15);
        Font headFont = wb.createFont();
        headFont.setBoldweight((short)700);
        CellStyle headStyle = wb.createCellStyle();
        headStyle.setAlignment((short)2);
        headStyle.setFont(headFont);
        String[] headArr = cols.split(",");
        int totalColsNum = headArr.length;
        Row row = sheet.createRow(0);
        Cell cell = null;
        String[] codeArr = new String[totalColsNum];
        String[] nameArr = new String[totalColsNum];
        for (int j = 0; j < totalColsNum; ++j) {
            cell = row.createCell(j);
            String[] codeNameArr = headArr[j].split("=");
            codeArr[j] = codeNameArr[0];
            nameArr[j] = codeNameArr[1];
            cell.setCellValue(nameArr[j]);
            cell.setCellStyle(headStyle);
        }
        int rownum = 1;
        int maxnum = 65536;
        if (result != null && !result.isEmpty()) {
            for (Object o : result) {
                JSONObject jo = (JSONObject)o;
                row = sheet.createRow(rownum);
                for (int i = 0; i < totalColsNum; ++i) {
                    cell = row.createCell(i);
                    Object value = jo.get((Object)codeArr[i]);
                    if (value instanceof Number) {
                        cell.setCellValue(((Number)value).doubleValue());
                        cell.setCellType(0);
                    }
                    if (value instanceof Date) {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        String date = df.format((Date)value);
                        cell.setCellValue(date);
                        cell.setCellType(0);
                    }
                    if (value instanceof String) {
                        cell.setCellValue((String)value);
                        cell.setCellType(1);
                    }
                    if (!(value instanceof Boolean)) continue;
                    cell.setCellValue(((Boolean)value).toString());
                    cell.setCellType(4);
                }
                if (++rownum <= 0 || rownum % maxnum != 0) continue;
                sheet = wb.createSheet("Sheet" + ++sheetNo);
                sheet.setDefaultColumnWidth(15);
                rownum = 0;
            }
        }
        try {
            wb.write(os);
        }
        finally {
            os.flush();
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportTxt(String cols, JSONArray result, OutputStream os) throws IOException {
        StringBuffer buf = new StringBuffer();
        String[] headArr = cols.split(",");
        int totalColsNum = headArr.length;
        String[] codeArr = new String[totalColsNum];
        String[] nameArr = new String[totalColsNum];
        boolean isAppend = false;
        for (int j = 0; j < totalColsNum; ++j) {
            String[] codeNameArr = headArr[j].split("=");
            codeArr[j] = codeNameArr[0];
            nameArr[j] = codeNameArr[1];
            if (isAppend) {
                buf.append("\t");
            } else {
                isAppend = true;
            }
            buf.append(nameArr[j]);
        }
        buf.append("\r\n");
        if (result != null && !result.isEmpty()) {
            for (Object o : result) {
                isAppend = false;
                JSONObject jo = (JSONObject)o;
                for (int i = 0; i < totalColsNum; ++i) {
                    Object value = jo.get((Object)codeArr[i]);
                    if (isAppend) {
                        buf.append("\t");
                    } else {
                        isAppend = true;
                    }
                    if (value != null) {
                        buf.append(value);
                        continue;
                    }
                    buf.append("");
                }
                buf.append("\r\n");
            }
        }
        try {
            os.write(buf.toString().getBytes());
        }
        finally {
            os.flush();
            os.close();
        }
    }

    private static void exportJson(JSONArray result, OutputStream os) throws IOException {
        StringBuffer buf = new StringBuffer();
        if (result != null && !result.isEmpty()) {
            buf.append(result.toJSONString());
        }
        try {
            os.write(buf.toString().getBytes());
        }
        finally {
            os.flush();
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportCsv(String cols, JSONArray result, OutputStream os) throws IOException {
        String charset = "gbk";
        String[] headArr = cols.split(",");
        int totalColsNum = headArr.length;
        String[] codeArr = new String[totalColsNum];
        String[] nameArr = new String[totalColsNum];
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(os, charset), 1024);
            boolean isAppend = false;
            for (int j = 0; j < totalColsNum; ++j) {
                String[] codeNameArr = headArr[j].split("=");
                codeArr[j] = codeNameArr[0];
                nameArr[j] = codeNameArr[1];
                if (isAppend) {
                    writer.append(",");
                } else {
                    isAppend = true;
                }
                writer.append(nameArr[j]);
            }
            writer.append("\r");
            if (result != null && !result.isEmpty()) {
                for (Object o : result) {
                    JSONObject jo = (JSONObject)o;
                    isAppend = false;
                    for (int i = 0; i < totalColsNum; ++i) {
                        String value = jo.getString(codeArr[i]);
                        if (isAppend) {
                            writer.append(",");
                        } else {
                            isAppend = true;
                        }
                        writer.append(value).append("\t");
                    }
                    writer.append("\r");
                }
            }
        }
        finally {
            writer.flush();
            writer.close();
            os.flush();
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportHtml(String cols, JSONArray result, OutputStream os) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("<html>\r\n");
        buf.append("\t<head>\r\n");
        buf.append("\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\r\n");
        buf.append("\t\t<title>\u5bfc\u51fa\u5185\u5bb9</title>\r\n");
        buf.append("\t</head>\r\n");
        buf.append("\t<body>\r\n");
        buf.append("\t\t<table border=\"1\" align=\"center\" cellpadding=\"4\" cellspacing=\"0\" style=\"font-size:13px\">\r\n");
        String[] headArr = cols.split(",");
        int totalColsNum = headArr.length;
        String[] codeArr = new String[totalColsNum];
        String[] nameArr = new String[totalColsNum];
        buf.append("\t\t\t<tr>\r\n");
        for (int j = 0; j < totalColsNum; ++j) {
            String[] codeNameArr = headArr[j].split("=");
            codeArr[j] = codeNameArr[0];
            nameArr[j] = codeNameArr[1];
            buf.append("\t\t\t\t<th>").append(nameArr[j]).append("</th>\r\n");
        }
        buf.append("\t\t\t</tr>\r\n");
        if (result != null && !result.isEmpty()) {
            for (Object o : result) {
                JSONObject jo = (JSONObject)o;
                buf.append("\t\t\t<tr>\r\n");
                for (int i = 0; i < totalColsNum; ++i) {
                    Object value = jo.get((Object)codeArr[i]);
                    if (value instanceof Number) {
                        buf.append("\t\t\t\t<td align=\"right\">").append(value);
                    } else if (value instanceof String) {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        try {
                            df.parse((String)value);
                            buf.append("\t\t\t\t<td align=\"center\">").append(value);
                        }
                        catch (Exception ex) {
                            buf.append("\t\t\t\t<td>").append(value);
                        }
                    } else if (value != null) {
                        buf.append("\t\t\t\t<td>").append(value);
                    } else {
                        buf.append("\t\t\t\t<td>").append("");
                    }
                    buf.append("</td>\r\n");
                }
                buf.append("\t\t\t</tr>\r\n");
            }
        }
        buf.append("\t\t</table>\r\n");
        buf.append("\t</body>\r\n");
        buf.append("</html>");
        try {
            PrintStream ps = new PrintStream(os);
            ps.println(buf);
        }
        finally {
            os.flush();
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportXml(String cols, String tname, JSONArray result, OutputStream os) throws IOException {
        Document doc = DocumentHelper.createDocument();
        Element rootEle = doc.addElement("data");
        Element childEle = null;
        Element sonEle = null;
        String[] headArr = cols.split(",");
        int totalColsNum = headArr.length;
        String[] codeArr = new String[totalColsNum];
        String[] nameArr = new String[totalColsNum];
        for (int j = 0; j < totalColsNum; ++j) {
            String[] codeNameArr = headArr[j].split("=");
            codeArr[j] = codeNameArr[0];
            nameArr[j] = codeNameArr[1];
        }
        if (result != null && !result.isEmpty()) {
            for (Object o : result) {
                JSONObject jo = (JSONObject)o;
                childEle = rootEle.addElement(tname);
                for (int i = 0; i < totalColsNum; ++i) {
                    String value = jo.getString(codeArr[i]);
                    sonEle = childEle.addElement(nameArr[i]);
                    if (value != null) {
                        sonEle.setText(value);
                        continue;
                    }
                    sonEle.setText("");
                }
            }
        }
        XMLWriter writer = null;
        try {
            writer = new XMLWriter(os, OutputFormat.createPrettyPrint());
            writer.setEscapeText(false);
            writer.write(doc);
        }
        finally {
            writer.flush();
            writer.close();
            os.flush();
            os.close();
        }
    }

    public static void zip(String filename, OutputStream os, InputStream in) throws IOException {
        int size;
        BufferedInputStream bis = new BufferedInputStream(in);
        ZipOutputStream zipOut = new ZipOutputStream(os);
        ZipEntry entry = new ZipEntry(filename);
        zipOut.putNextEntry(entry);
        byte[] buff = new byte[2048];
        while ((size = bis.read(buff, 0, buff.length)) != -1) {
            zipOut.write(buff, 0, size);
        }
        bis.close();
        zipOut.flush();
        zipOut.closeEntry();
        zipOut.close();
    }
}

