/*
 * Decompiled with CFR 0.152.
 */
package com.product.cloudrest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.product.cloudrest.CloudUrl;
import com.product.cloudrest.RunModeEnum;
import com.product.exception.NotDataRuntimeException;
import com.product.exception.ServiceRuntimeException;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.DateTimeFormatUtil;
import com.product.util.RestBaseUtils;
import com.product.util.ServiceAssert;
import com.product.util.UniqueID;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudService {
    private static RunModeEnum runMode;
    private static Logger logger;
    private static ServiceSession session;

    private CloudService() {
    }

    public static ServiceResponse sendPost(String service, String method, ServiceSession session, JSONObject paramsObject) {
        ServiceResponse serviceResponse;
        long start = System.currentTimeMillis();
        String url = CloudUrl.getUrl(session, service, method);
        ServiceAssert.notNull(url, "\u8c03\u7528\u670d\u52a1URL\u7a7a[" + service + "];");
        String param = paramsObject.toJSONString();
        logger.info("\u2554=========================[\u8bf7\u6c42\u5730\u5740]=========================\u2557");
        logger.info(String.format("[url:]%s", url));
        logger.info("\u2560==============================================================\u2563");
        logger.info(String.format("[param:]%s", param));
        logger.error("\u2560==============================================================\u2563");
        try {
            long traceId = UniqueID.getUniqueID(true);
            HashMap<String, String> sessionMap = new HashMap<String, String>();
            sessionMap.put("session", JSON.toJSONString((Object)session));
            sessionMap.put("ent_id", String.valueOf(session.getEnt_id()));
            String res = RestBaseUtils.onHttpPost(traceId, 3000, 3000, null, url, sessionMap, param, String.class, null, null);
            logger.info(String.format("[result:]%s", res));
            ServiceResponse resp = (ServiceResponse)JSON.parseObject((String)res, ServiceResponse.class);
            if ("10003".equals(resp.getReturncode())) {
                logger.error(String.format("[error_result:]%s", JSON.toJSONString((Object)resp)));
                throw new NotDataRuntimeException();
            }
            if (!"0".equals(resp.getReturncode())) {
                logger.error(String.format("[error_result:]%s", JSON.toJSONString((Object)resp)));
                throw new ServiceRuntimeException(String.format("\u8c03\u7528[%s]\u670d\u52a1\u5931\u8d25\u4e86 \u65f6\u95f4\u53d1\u751f\u5728[%s]", service.split("\\.")[0], DateTimeFormatUtil.nowToDateTime()));
            }
            serviceResponse = resp;
        }
        catch (RuntimeException e) {
            try {
                logger.error("[ERROR]\u8c03\u7528\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                logger.info("\u255a==============================================================\u255d");
                logger.info(String.format(" \u63a5\u53e3[%s]\u8c03\u7528\u8fc7\u7a0b\u8017\u65f6\uff1a%d", method, System.currentTimeMillis() - start));
                logger.info("\u255a==============================================================\u255d");
                throw throwable;
            }
        }
        logger.info("\u255a==============================================================\u255d");
        logger.info(String.format(" \u63a5\u53e3[%s]\u8c03\u7528\u8fc7\u7a0b\u8017\u65f6\uff1a%d", method, System.currentTimeMillis() - start));
        logger.info("\u255a==============================================================\u255d");
        return serviceResponse;
    }

    public static ServiceSession defaultSession() {
        if (session == null) {
            session = new ServiceSession();
            session.setEnt_id(2L);
            session.setUser_id(0L);
            session.setUser_code("10002");
            session.setUser_name("\u7cfb\u7edf\u7ba1\u7406\u5458");
            session.setErpCode("003");
            session.setLocale("CN");
        }
        return session;
    }

    public static RunModeEnum getRunMode() {
        return runMode;
    }

    public static void setRunMode(String mode) {
        if (runMode == null) {
            RunModeEnum rmode;
            runMode = rmode = RunModeEnum.valueOf(mode.toUpperCase());
        }
    }

    static {
        logger = LoggerFactory.getLogger(CloudService.class);
    }
}

