/*
 * Decompiled with CFR 0.152.
 */
package com.product.cloudrest;

import com.product.exception.ServiceRuntimeException;

public enum RunModeEnum {
    CLOUD(1, "\u4e91\u670d\u52a1"),
    LOCAL(2, "\u672c\u5730\u670d\u52a1"),
    OFFLINE(3, "\u8131\u673a");

    private Integer code;
    private String chineseName;

    private RunModeEnum(Integer code, String chineseName) {
        this.code = code;
        this.chineseName = chineseName;
    }

    public String export() {
        return String.format("[%s]%s", this.getCode(), this.getChineseName());
    }

    public static String export(String code) {
        for (RunModeEnum o : RunModeEnum.values()) {
            if (!o.code.equals(code)) continue;
            return String.format("[%s]%s", o.code, o.chineseName);
        }
        throw new ServiceRuntimeException(String.format("ENUM ERROR[%s:%s]", RunModeEnum.class.getSimpleName(), code));
    }

    public static RunModeEnum instance(String code) {
        for (RunModeEnum o : RunModeEnum.values()) {
            if (!o.code.equals(code)) continue;
            return o;
        }
        throw new ServiceRuntimeException(String.format("ENUM ERROR[%s:%s]", RunModeEnum.class.getSimpleName(), code));
    }

    public static String chinese(String code) {
        for (RunModeEnum o : RunModeEnum.values()) {
            if (!o.code.equals(code)) continue;
            return o.chineseName;
        }
        throw new ServiceRuntimeException(String.format("ENUM ERROR[SheetTypeCodeEnum:%d]", code));
    }

    public Integer getCode() {
        return this.code;
    }

    public String getChineseName() {
        return this.chineseName;
    }
}

