/*
 * Decompiled with CFR 0.152.
 */
package com.product.config;

import com.efuture.redis.component.RedisClient;
import java.util.Properties;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class SpringSessionRedisConfiguration {
    @Resource
    ConfigurableEnvironment environment;

    @Bean(value={"jedisConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    public JedisConnectionFactory jedisConnectionFactory() {
        return this.getSingleConnectionFactory();
    }

    @Bean(value={"jedisConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="sentinel")
    public JedisConnectionFactory sentineljedisConnectionFactory() {
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory(this.sentinelConfiguration(), this.poolConfiguration());
        jedisConnectionFactory.setConvertPipelineAndTxResults(false);
        String password = this.environment.getProperty("spring.redis.password");
        if (!StringUtils.isEmpty((Object)password)) {
            jedisConnectionFactory.setPassword(password.trim());
        }
        String index = this.environment.getProperty("spring.redis.database");
        int dbIndex = 0;
        if (!StringUtils.isEmpty((Object)index)) {
            dbIndex = Integer.valueOf(index);
        }
        jedisConnectionFactory.setDatabase(dbIndex);
        return jedisConnectionFactory;
    }

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="sentinel")
    public RedisSentinelConfiguration sentinelConfiguration() {
        Properties properties = new Properties();
        properties.put("spring.redis.sentinel.master", this.environment.getProperty("spring.redis.sentinel.master"));
        properties.put("spring.redis.sentinel.nodes", this.environment.getProperty("spring.redis.sentinel.nodes"));
        PropertiesPropertySource redisPropertySource = new PropertiesPropertySource("redis", properties);
        return new RedisSentinelConfiguration((PropertySource)redisPropertySource);
    }

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, matchIfMissing=false)
    public JedisPoolConfig poolConfiguration() {
        JedisPoolConfig config = new JedisPoolConfig();
        String maxActive = this.environment.getProperty("spring.redis.pool.max-active");
        String maxWait = this.environment.getProperty("spring.redis.pool.max-wait");
        String maxIdle = this.environment.getProperty("spring.redis.pool.max-idle");
        String minIdle = this.environment.getProperty("spring.redis.pool.min-idle");
        config.setMaxTotal(Integer.parseInt(maxActive));
        config.setMaxWaitMillis((long)Integer.parseInt(maxWait));
        config.setMaxIdle(Integer.parseInt(maxIdle));
        config.setMinIdle(Integer.parseInt(minIdle));
        return config;
    }

    @Bean(value={"redisTemplate"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="sentinel")
    RedisTemplate<Object, Object> sentinelRedisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)this.sentineljedisConnectionFactory());
        redisTemplate.setEnableTransactionSupport(true);
        return redisTemplate;
    }

    @Bean(value={"stringRedisTemplate"})
    @Qualifier(value="stringRedisTemplate")
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="sentinel")
    StringRedisTemplate sentinelStringRedisTemplate() {
        StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
        stringRedisTemplate.setConnectionFactory((RedisConnectionFactory)this.sentineljedisConnectionFactory());
        stringRedisTemplate.setEnableTransactionSupport(true);
        return stringRedisTemplate;
    }

    @Bean(value={"redisTemplate"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    RedisTemplate<Object, Object> redisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)this.jedisConnectionFactory());
        redisTemplate.setEnableTransactionSupport(true);
        return redisTemplate;
    }

    @Bean(value={"stringRedisTemplate"})
    @Qualifier(value="stringRedisTemplate")
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    StringRedisTemplate stringRedisTemplate() {
        StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
        stringRedisTemplate.setConnectionFactory((RedisConnectionFactory)this.jedisConnectionFactory());
        stringRedisTemplate.setEnableTransactionSupport(true);
        return stringRedisTemplate;
    }

    @Bean(value={"RedisClient"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, matchIfMissing=false)
    RedisClient redisClient() {
        return new RedisClient();
    }

    @Bean(value={"cacheManager"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    RedisCacheManager cacheManager() {
        return new RedisCacheManager(this.redisTemplate());
    }

    @Bean(value={"cacheManager"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="sentinel")
    RedisCacheManager sentinelCacheManager() {
        return new RedisCacheManager(this.sentinelRedisTemplate());
    }

    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    private JedisConnectionFactory getSingleConnectionFactory() {
        String host = this.environment.getProperty("spring.redis.host");
        String port = this.environment.getProperty("spring.redis.port");
        String password = this.environment.getProperty("spring.redis.password");
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory();
        jedisConnectionFactory.setHostName(host.trim());
        jedisConnectionFactory.setPort(Integer.parseInt(port.trim()));
        jedisConnectionFactory.setPoolConfig(this.poolConfiguration());
        jedisConnectionFactory.setConvertPipelineAndTxResults(false);
        if (!StringUtils.isEmpty((Object)password)) {
            jedisConnectionFactory.setPassword(password.trim());
        }
        String index = this.environment.getProperty("spring.redis.database");
        int dbIndex = 0;
        if (!StringUtils.isEmpty((Object)index)) {
            dbIndex = Integer.valueOf(index);
        }
        jedisConnectionFactory.setDatabase(dbIndex);
        return jedisConnectionFactory;
    }
}

