/*
 * Decompiled with CFR 0.152.
 */
package com.product.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.product.component.CommonServiceImpl;
import com.product.controller.ProductReflect;
import com.product.model.FileImportObject;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.Utils;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.springframework.util.StringUtils;

@Path(value="/")
public class ProductRest {
    @Context
    protected HttpServletRequest request;
    @Context
    protected HttpServletResponse response;
    private static ProductReflect rcm = new ProductReflect();

    @GET
    @Produces(value={"text/html;charset=UTF-8"})
    @Path(value="/")
    public String test() {
        return this.request.getRequestURI() + " success";
    }

    @GET
    @Produces(value={"text/html;charset=UTF-8"})
    @Path(value="/getversion")
    public String getVersion() throws IOException {
        String filename = this.request.getSession().getServletContext().getRealPath("/WEB-INF");
        if (!StringUtils.isEmpty((Object)filename)) {
            filename = filename + "/classes/version.dat";
        } else {
            filename = Thread.currentThread().getContextClassLoader().getResource("").toString();
            if (StringUtils.isEmpty((Object)filename)) {
                return "\u83b7\u53d6\u7248\u672c\u6587\u4ef6\u8def\u5f84\u5931\u8d25!";
            }
            filename = filename.replace("file:", "");
            filename = filename.substring(1);
            filename = filename + "version.dat";
        }
        String versionData = String.format("\u672a\u627e\u5230\u7248\u672c\u6587\u4ef6:\u3010%1$s\u3011", filename);
        File file = new File(filename);
        if (file.exists() && file.isFile()) {
            FileReader reader = new FileReader(file);
            BufferedReader bufferReader = new BufferedReader(reader);
            versionData = bufferReader.readLine();
            bufferReader.close();
        }
        return String.format("\u5f53\u524d\u5e94\u7528\u7248\u672c:%1$s", versionData);
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/rest")
    public String callRestService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, String param, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale) {
        System.out.println(String.format("---->method=%1$s session=%2$s param=%3$s ent_id=%4$s user_id=%5$s user_name=%6$s locale=%7$s", method + "", session + "", param + "", ent_id + "", user_id + "", user_name + "", locale + ""));
        try {
            Object retdata;
            if (StringUtils.isEmpty((Object)session) && !StringUtils.isEmpty((Object)ent_id)) {
                ServiceSession ss = new ServiceSession();
                if (!StringUtils.isEmpty((Object)ent_id)) {
                    ss.setEnt_id(Long.parseLong(ent_id));
                }
                if (!StringUtils.isEmpty((Object)user_id)) {
                    ss.setUser_id(Long.parseLong(user_id));
                }
                ss.setUser_name(user_name);
                ss.setLocale(locale);
                session = JSON.toJSONString((Object)ss);
            }
            if ((retdata = rcm.executeClassMethod(method, session, param)) == null) {
                return "";
            }
            if (retdata instanceof String) {
                return (String)retdata;
            }
            return JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "10000", Utils.getLastExceptionMessage(ex)));
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/rest")
    public String callRestServiceByGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale) {
        return this.callRestService(method, session, param, ent_id, user_id, user_name, locale);
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/rest/js")
    public String callRestServiceByPost(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale) {
        return this.callRestService(method, session, param, ent_id, user_id, user_name, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/import")
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"multipart/form-data"})
    public String callImportService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, FormDataMultiPart form, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale) {
        ArrayList<FileImportObject> list = new ArrayList<FileImportObject>();
        try {
            String key2;
            Map mapFormData = form.getFields();
            Set sets = mapFormData.keySet();
            if (StringUtils.isEmpty((Object)session) && !StringUtils.isEmpty((Object)ent_id)) {
                ServiceSession ss = new ServiceSession();
                if (!StringUtils.isEmpty((Object)ent_id)) {
                    ss.setEnt_id(Long.parseLong(ent_id));
                }
                if (!StringUtils.isEmpty((Object)user_id)) {
                    ss.setUser_id(Long.parseLong(user_id));
                }
                ss.setUser_name(user_name);
                ss.setLocale(locale);
                session = JSON.toJSONString((Object)ss);
            }
            for (String key2 : sets) {
                Iterator parts = (List)mapFormData.get(key2);
                for (int i = 0; i < parts.size(); ++i) {
                    FormDataBodyPart part = (FormDataBodyPart)parts.get(i);
                    String filename = part.getContentDisposition().getFileName();
                    System.out.println(key2 + ":" + filename);
                    if (StringUtils.isEmpty((Object)filename)) continue;
                    FileImportObject fio = new FileImportObject();
                    fio.setFilename(filename);
                    fio.setStream((InputStream)part.getValueAs(InputStream.class));
                    fio.setServletrequest(this.request);
                    list.add(fio);
                }
            }
            Object retdata = rcm.executeClassMethodForListParam(method, session, param, list);
            if (retdata == null) {
                key2 = "";
                return key2;
            }
            if (retdata instanceof String) {
                key2 = (String)retdata;
                return key2;
            }
            key2 = JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata));
            return key2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "10000", Utils.getLastExceptionMessage(ex)));
            return string;
        }
        finally {
            for (FileImportObject fio : list) {
                try {
                    InputStream in = fio.getStream();
                    if (in == null) continue;
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/export")
    public String callExportServiceByGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        return this.callExportService(method, session, param, ent_id, user_id, user_name, locale, filename, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/export/csv")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/octet-stream"})
    public Response callExportServiceByGET2(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        ByteArrayOutputStream os = null;
        Response.ResponseBuilder builder = null;
        try {
            Object retdata;
            if (StringUtils.isEmpty((Object)session) && !StringUtils.isEmpty((Object)ent_id)) {
                ServiceSession ss = new ServiceSession();
                if (!StringUtils.isEmpty((Object)ent_id)) {
                    ss.setEnt_id(Long.parseLong(ent_id));
                }
                if (!StringUtils.isEmpty((Object)user_id)) {
                    ss.setUser_id(Long.parseLong(user_id));
                }
                ss.setUser_name(user_name);
                ss.setLocale(locale);
                session = JSON.toJSONString((Object)ss);
            }
            if ((retdata = rcm.executeClassMethod(method, session, param)) == null) {
                Response response = null;
                return response;
            }
            if (retdata instanceof ByteArrayOutputStream) {
                os = (ByteArrayOutputStream)retdata;
                ByteArrayInputStream in = new ByteArrayInputStream(os.toByteArray());
                builder = Response.ok((Object)in);
                if (filename == null) {
                    filename = "export.csv";
                } else if (filename.toLowerCase().endsWith(".csv")) {
                    filename = filename + ".csv";
                }
                builder.header("Content-Disposition", (Object)("attachment; filename=" + filename));
                builder.type("application/octet-stream");
                Response e = builder.build();
                return e;
            }
            Response response = Response.ok((Object)retdata.toString()).build();
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (builder != null) {
                Response.ok();
                Response response = builder.build();
                return response;
            }
            Response response = null;
            return response;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/export")
    public String callExportService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, String param, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            String data = this.callRestService(method, session, param, ent_id, user_id, user_name, locale);
            if (!StringUtils.isEmpty((Object)data)) {
                this.response.setHeader("Pragma", "No-cache");
                this.response.setHeader("Cache-Control", "No-cache");
                this.response.setDateHeader("Expires", 0L);
                this.response.setCharacterEncoding("UTF-8");
                this.response.setContentType("application/ms-excel");
                if (StringUtils.isEmpty((Object)filename)) {
                    filename = "export.xls";
                }
                this.response.setHeader("Content-Disposition", Utils.builderContentDispositionFileName(headers, filename));
            }
            return data;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "10000", Utils.getLastExceptionMessage(ex)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/rest/exportExcel")
    public void callRestServiceExcel(@QueryParam(value="method") String method, @QueryParam(value="session") String session, String param, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale, @QueryParam(value="type") String type, @QueryParam(value="url") String url, @QueryParam(value="fillName") String fillName, @QueryParam(value="cols") String cols, @QueryParam(value="tname") String tname, @QueryParam(value="istree") String istree, @QueryParam(value="childname") String childname) {
        System.out.println("---------------\u6d4b\u8bd5\u4e0b\u8f7d exportExcel");
        ServiceSession session1 = null;
        if (StringUtils.isEmpty((Object)session) && !StringUtils.isEmpty((Object)ent_id)) {
            session1 = new ServiceSession();
            if (!StringUtils.isEmpty((Object)ent_id)) {
                session1.setEnt_id(Long.parseLong(ent_id));
            }
            if (!StringUtils.isEmpty((Object)user_id)) {
                session1.setUser_id(Long.parseLong(user_id));
            }
            session1.setUser_name(user_name);
            session1.setLocale(locale);
        } else {
            session1 = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
        }
        OutputStream os = null;
        JSONObject object = new JSONObject();
        object.put("type", (Object)type);
        object.put("url", (Object)url);
        object.put("params", (Object)param);
        object.put("cols", (Object)cols);
        object.put("tname", (Object)tname);
        object.put("istree", (Object)istree);
        object.put("childname", (Object)childname);
        try {
            String name = fillName + "." + type;
            this.response.reset();
            this.response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(name, "UTF-8"));
            this.response.setCharacterEncoding("UTF-8");
            this.response.setContentType("application/vnd.ms-excel");
            os = this.response.getOutputStream();
            CommonServiceImpl service = new CommonServiceImpl(null, "", "");
            service.onExportDataDirect(session1, object.toString(), os);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.flush();
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("export success");
    }
}

