/*
 * Decompiled with CFR 0.152.
 */
package com.product.converter;

import com.product.converter.Converter;
import com.product.model.ServiceSession;
import com.product.util.LocalDateFormatterUtil;
import com.product.util.ServiceAssert;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConverter
implements Converter {
    private static Logger logger = LoggerFactory.getLogger(AbstractConverter.class);
    private LocalDateTime lastRefreshTime = LocalDateTime.MIN;
    protected Map<String, String> convRuleMap = new HashMap<String, String>();
    public String NULLERPCODE = "ERP";

    protected String getDefaultValue(String erpCode, String code) {
        return "";
    }

    protected void addConvRule(String erpCode, String code, String value) {
        String key = String.format("%s-%s", erpCode, code);
        this.convRuleMap.put(key, value);
    }

    protected void addConvRule(String code, String value) {
        this.addConvRule(code, this.NULLERPCODE, value);
    }

    @Override
    public String getName(ServiceSession session, String erpCode, String code) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime flagTime = LocalDateTime.of(LocalDate.now(), LocalTime.of(5, 0, 0));
        if (this.convRuleMap.isEmpty() || this.lastRefreshTime.isBefore(flagTime) && now.isAfter(flagTime)) {
            this.refreshRule(session);
        }
        erpCode = ServiceAssert.emptyStr(erpCode) ? this.NULLERPCODE : erpCode;
        String convCode = String.format("%s-%s", erpCode, code);
        String resultValue = this.getDefaultValue(erpCode, code);
        if (this.convRuleMap.containsKey(convCode)) {
            resultValue = this.convRuleMap.get(convCode);
        }
        return resultValue;
    }

    public String getName(ServiceSession session, String code) {
        return this.getName(session, this.NULLERPCODE, code);
    }

    @Override
    public void refreshRule(ServiceSession session) {
        logger.info(String.format("[%s]\u4e0a\u6b21\u5237\u65b0\u65f6\u95f4\uff1a%s", this.getClass().getSimpleName(), LocalDateFormatterUtil.toDateTime(this.lastRefreshTime)));
        if (!this.convRuleMap.isEmpty()) {
            this.convRuleMap.clear();
        }
        this.refresh(session);
        this.lastRefreshTime = LocalDateTime.now();
        logger.info(String.format("[%s]\u6700\u65b0\u5237\u65b0\u65f6\u95f4\uff1a%s", this.getClass().getSimpleName(), LocalDateFormatterUtil.toDateTime(this.lastRefreshTime)));
    }

    protected abstract void refresh(ServiceSession var1);
}

