/*
 * Decompiled with CFR 0.152.
 */
package com.product.converter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.product.component.JDBCCompomentServiceImpl;
import com.product.converter.AbstractConverter;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.ServiceAssert;

public abstract class DictConverter
extends AbstractConverter {
    private JDBCCompomentServiceImpl service;

    public abstract String getDictCode();

    public DictConverter(JDBCCompomentServiceImpl serviceImpl) {
        this.service = serviceImpl;
    }

    @Override
    protected void refresh(ServiceSession session) {
        JSONObject paramObject = new JSONObject();
        paramObject.put("dictCode", (Object)this.getDictCode());
        ServiceResponse resp = this.service.onQuery(session, paramObject);
        ServiceAssert.isSuccess(resp);
        JSONArray dictArray = ((JSONObject)resp.getData()).getJSONArray(this.service.getCollectionName());
        for (int i = 0; i < dictArray.size(); ++i) {
            JSONObject dict = dictArray.getJSONObject(i);
            this.addConvRule(dict.getString(this.getErpCodeName()), dict.getString(this.getKeyFieldName()), dict.getString(this.getValueFieldName()));
        }
    }

    protected String getErpCodeName() {
        return "erpCode";
    }

    protected String getKeyFieldName() {
        return "dictCode";
    }

    protected String getValueFieldName() {
        return "dictDatacnname";
    }
}

