/*
 * Decompiled with CFR 0.152.
 */
package com.product.language;

import com.product.util.SpringContext;
import java.util.Locale;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.util.StringUtils;

public class MessageSourceHelper {
    private ResourceBundleMessageSource messageSource;

    public static MessageSourceHelper getDefault() {
        return SpringContext.getBean("messageSourceHelper", MessageSourceHelper.class);
    }

    public static String getMessage(String code, String locale, Object ... args) {
        return MessageSourceHelper.getDefault().getMessage(code, code, StringUtils.isEmpty((Object)locale) ? null : new Locale(locale), args);
    }

    public String getMessage(String code, String defaultMessage, Locale locale, Object ... args) {
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i] instanceof String) continue;
            args[i] = String.valueOf(args[i]);
        }
        String msg = this.messageSource.getMessage(code, args, defaultMessage, locale);
        return msg != null ? msg.trim() : msg;
    }

    public void setMessageSource(ResourceBundleMessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

