/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.filter;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.efuture.redis.component.FtJedisPool;
import com.product.component.AuthorityBaseServiceImpl;
import com.product.model.ServiceSession;
import com.product.storage.filter.FtSqlSource;
import com.product.util.SpringBeanFactory;
import com.product.util.SpringContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class DataRangeExecutorWrapper
implements Interceptor {
    private static Logger sqlLog = Logger.getLogger(DataRangeExecutorWrapper.class);
    private String dbType;

    public Object intercept(Invocation invocation) throws Throwable {
        if (SpringContext.getActiveProfile().equals("local") || SpringContext.getActiveProfile().equals("test")) {
            return invocation.proceed();
        }
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        if (invocation.getArgs()[1] instanceof Map) {
            Map parameter = (Map)invocation.getArgs()[1];
            if (parameter.get("servicesession") != null) {
                ServiceSession serviceSession = (ServiceSession)parameter.get("servicesession");
                BoundSql boundSql = mappedStatement.getBoundSql((Object)parameter);
                String sql = boundSql.getSql();
                try {
                    sqlLog.info((Object)("parse start ==>" + new Date().getTime()));
                    String newSql = this.onMySQLAnalyzeRequest(sql, serviceSession);
                    sqlLog.info((Object)("parse end ==>" + new Date().getTime()));
                    FtSqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newSql.toString(), boundSql);
                    MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, sqlSource);
                    invocation.getArgs()[0] = newMs;
                }
                catch (Exception e) {
                    invocation.getArgs()[0] = mappedStatement;
                    sqlLog.error((Object)("unresovled sql:" + sql));
                    sqlLog.error((Object)e.getMessage(), e.getCause());
                }
            } else {
                sqlLog.error((Object)("not standard sql" + mappedStatement.getBoundSql(invocation.getArgs()[1])));
            }
        } else {
            sqlLog.error((Object)("not standard sql" + mappedStatement.getBoundSql(invocation.getArgs()[1])));
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.dbType = properties.getProperty("dbType");
        if (this.dbType == null || this.dbType.equals("")) {
            this.dbType = "mysql";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> getDataRangeTable(ServiceSession serviceSession, String tableName) {
        sqlLog.info((Object)("datarange start ==>" + new Date().getTime()));
        HashMap<String, List<String>> columnMap = new HashMap<String, List<String>>();
        FtJedisPool jedisPool = (FtJedisPool)SpringBeanFactory.getBean("jedisPool");
        try (Jedis jedis = jedisPool.getResource();){
            Set tidSets = jedis.zrange("datarangetableref", 0L, -1L);
            if (tidSets != null && tidSets.size() > 0) {
                Pipeline pipeline = jedis.pipelined();
                ArrayList<Response> list = new ArrayList<Response>();
                for (String rid : tidSets) {
                    list.add(pipeline.hmget("datarangetableref:" + rid, new String[]{"tableName", "type", "columnName"}));
                }
                pipeline.sync();
                for (Response resp : list) {
                    List tableList = (List)resp.get();
                    if (!((String)tableList.get(0)).toLowerCase().equals(tableName.toLowerCase().replaceAll("`", ""))) continue;
                    List<Object> valList = new ArrayList();
                    String type = (String)tableList.get(1);
                    if (type.equals("1")) {
                        valList = this.getDataRangeShop(serviceSession);
                    } else if (type.equals("2")) {
                        valList = this.getDataRangeOrg(serviceSession);
                    } else if (type.equals("3")) {
                        valList = this.getDataRangeCategory(serviceSession);
                    } else if (type.equals("4")) {
                        valList = this.getDataRangeBusiCompany(serviceSession);
                    } else if (type.equals("5")) {
                        valList = this.getDataRangeShopcode(serviceSession);
                    }
                    if (valList.size() <= 0) continue;
                    columnMap.put((String)tableList.get(2), (List<String>)valList);
                }
            }
        }
        sqlLog.info((Object)("datarange end ==>" + new Date().getTime()));
        return columnMap;
    }

    private List<String> getDataRangeCategory(ServiceSession serviceSession) {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = (AuthorityBaseServiceImpl)SpringBeanFactory.getBean("authorityBaseServiceImpl");
        return authorityBaseServiceImpl.getDataRangeCategory(serviceSession);
    }

    private List<String> getDataRangeShop(ServiceSession serviceSession) {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = (AuthorityBaseServiceImpl)SpringBeanFactory.getBean("authorityBaseServiceImpl");
        return authorityBaseServiceImpl.getDataRangeShop(serviceSession);
    }

    private List<String> getDataRangeShopcode(ServiceSession serviceSession) {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = (AuthorityBaseServiceImpl)SpringBeanFactory.getBean("authorityBaseServiceImpl");
        return authorityBaseServiceImpl.getDataRangeShopCode(serviceSession);
    }

    private List<String> getDataRangeOrg(ServiceSession serviceSession) {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = (AuthorityBaseServiceImpl)SpringBeanFactory.getBean("authorityBaseServiceImpl");
        return authorityBaseServiceImpl.getDataRangeOrg(serviceSession);
    }

    private List<String> getDataRangeBusiCompany(ServiceSession serviceSession) {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = (AuthorityBaseServiceImpl)SpringBeanFactory.getBean("authorityBaseServiceImpl");
        return authorityBaseServiceImpl.getDataRangeBusiCompany(serviceSession);
    }

    public String onMySQLAnalyzeRequest(String statementSQL, final ServiceSession serviceSession) {
        sqlLog.info((Object)("\u89e3\u6790\u5f00\u59cb:sql=" + statementSQL));
        try {
            MySqlStatementParser parser = new MySqlStatementParser(statementSQL);
            SQLStatement statement = parser.parseStatement();
            StringBuffer buffer = new StringBuffer();
            MySqlOutputVisitor myVisitor = new MySqlOutputVisitor(buffer){

                public boolean visit(SQLExprTableSource x) {
                    String tableName = x.toString();
                    sqlLog.info((Object)("\u89e3\u6790\u51fa\u8868:table=" + tableName));
                    if (!StringUtils.isEmpty((Object)tableName)) {
                        Map rowPolicy = DataRangeExecutorWrapper.this.getDataRangeTable(serviceSession, tableName);
                        SQLObject tableParent = x.getParent();
                        if (tableParent instanceof MySqlSelectQueryBlock) {
                            DataRangeExecutorWrapper.this.onQueryBlockPolicy((SQLSelectQueryBlock)((MySqlSelectQueryBlock)tableParent), tableName, x.getAlias(), rowPolicy);
                        } else if (tableParent instanceof SQLJoinTableSource) {
                            DataRangeExecutorWrapper.this.onMySQLJoinTablePolicy((SQLJoinTableSource)tableParent, tableName, x.getAlias(), rowPolicy);
                        }
                    }
                    return super.visit(x);
                }

                public boolean visit(MySqlSelectQueryBlock x) {
                    x.getFrom().setParent((SQLObject)x);
                    return super.visit(x);
                }

                public void endVisit(MySqlSelectQueryBlock x) {
                    sqlLog.info((Object)"===>\u89e3\u6790\u5b8c\u6210");
                }
            };
            statement.accept((SQLASTVisitor)myVisitor);
            sqlLog.info((Object)("\u89e3\u6790\u5b8c\u6210 newsql=" + buffer));
            return buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            sqlLog.error((Object)String.format("\u89e3\u6790\u5f02\u5e38:%1$s\r\n", e.getMessage() + ""));
            return statementSQL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String onMySQLAnalyzeRequest(String statementSQL, final Map<String, Map<String, List<String>>> dataPolicy) {
        final StringBuffer buflogger = new StringBuffer();
        buflogger.append(String.format("\u89e3\u6790SQL:%1$s\r\n", statementSQL));
        try {
            MySqlStatementParser parser = new MySqlStatementParser(statementSQL);
            SQLStatement statement = parser.parseStatement();
            StringBuffer buffer = new StringBuffer();
            MySqlOutputVisitor myVisitor = new MySqlOutputVisitor(buffer){

                public boolean visit(SQLExprTableSource x) {
                    String tableName = x.toString();
                    buflogger.append(String.format("\u89e3\u6790\u51fa\u8868:%1$s\r\n", tableName));
                    if (!StringUtils.isEmpty((Object)tableName) && dataPolicy.containsKey(tableName.toLowerCase())) {
                        Map rowPolicy = (Map)dataPolicy.get(tableName.toLowerCase());
                        SQLObject tableParent = x.getParent();
                        if (tableParent instanceof MySqlSelectQueryBlock) {
                            DataRangeExecutorWrapper.this.onQueryBlockPolicy((SQLSelectQueryBlock)((MySqlSelectQueryBlock)tableParent), tableName, x.getAlias(), rowPolicy);
                        } else if (tableParent instanceof SQLJoinTableSource) {
                            DataRangeExecutorWrapper.this.onMySQLJoinTablePolicy((SQLJoinTableSource)tableParent, tableName, x.getAlias(), rowPolicy);
                        }
                    }
                    return super.visit(x);
                }

                public boolean visit(MySqlSelectQueryBlock x) {
                    x.getFrom().setParent((SQLObject)x);
                    return super.visit(x);
                }

                public void endVisit(MySqlSelectQueryBlock x) {
                    sqlLog.info((Object)"===>\u89e3\u6790\u5b8c\u6210");
                }
            };
            statement.accept((SQLASTVisitor)myVisitor);
            String string = buffer.toString();
            return string;
        }
        catch (Exception e) {
            buflogger.append(String.format("\u89e3\u6790\u5f02\u5e38:%1$s\r\n", e.getMessage() + ""));
            System.out.println(e.getCause() + "");
            e.printStackTrace();
            String string = statementSQL;
            return string;
        }
        finally {
            System.out.println("\u6267\u884c\u89e3\u6790:" + buflogger.toString());
        }
    }

    protected void onQueryBlockPolicy(SQLSelectQueryBlock queryBlock, String tabname, String tabAlias, Map<String, List<String>> rowPolicy) {
        SQLExpr whereExpr = queryBlock.getWhere();
        Set<String> fieldSet = rowPolicy.keySet();
        for (String fieldName : fieldSet) {
            SQLBinaryOpExpr opCond;
            Object expr;
            SQLIdentifierExpr keyName;
            SQLInListExpr keyValue;
            String condtext;
            List<String> values = rowPolicy.get(fieldName);
            if (values == null) continue;
            if (whereExpr == null) {
                if ("@".equals(fieldName)) {
                    if (values.size() <= 0) continue;
                    condtext = values.get(0).toString();
                    condtext = condtext.replaceAll("@\\.", StringUtils.isEmpty((Object)tabAlias) ? tabname + "." : tabAlias + ".");
                    keyValue = new SQLIdentifierExpr(condtext);
                    queryBlock.setWhere((SQLExpr)keyValue);
                    whereExpr = keyValue;
                    continue;
                }
                keyName = new SQLIdentifierExpr(StringUtils.isEmpty((Object)tabAlias) ? tabname + "." + fieldName : tabAlias + "." + fieldName);
                keyValue = new SQLInListExpr((SQLExpr)keyName, false);
                for (String value : values) {
                    expr = null;
                    expr = value == null ? new SQLNullExpr() : (value instanceof String ? new SQLCharExpr(value) : new SQLCharExpr(value.toString()));
                    keyValue.getTargetList().add(expr);
                }
                queryBlock.setWhere((SQLExpr)keyValue);
                whereExpr = keyValue;
                continue;
            }
            if (!(whereExpr instanceof SQLBinaryOpExpr)) continue;
            if ("@".equals(fieldName)) {
                if (values.size() <= 0) continue;
                condtext = values.get(0).toString();
                condtext = condtext.replaceAll("@\\.", StringUtils.isEmpty((Object)tabAlias) ? tabname + "." : tabAlias + ".");
                keyValue = new SQLIdentifierExpr(condtext);
                opCond = new SQLBinaryOpExpr();
                opCond.setLeft(whereExpr);
                opCond.setOperator(SQLBinaryOperator.BooleanAnd);
                opCond.setRight((SQLExpr)keyValue);
                queryBlock.setWhere((SQLExpr)opCond);
                whereExpr = opCond;
                continue;
            }
            keyName = new SQLIdentifierExpr(StringUtils.isEmpty((Object)tabAlias) ? tabname + "." + fieldName : tabAlias + "." + fieldName);
            keyValue = new SQLInListExpr((SQLExpr)keyName, false);
            for (String value : values) {
                expr = null;
                expr = value == null ? new SQLNullExpr() : (value instanceof String ? new SQLCharExpr(value) : new SQLCharExpr(value.toString()));
                keyValue.getTargetList().add(expr);
            }
            opCond = new SQLBinaryOpExpr();
            opCond.setLeft(whereExpr);
            opCond.setOperator(SQLBinaryOperator.BooleanAnd);
            opCond.setRight((SQLExpr)keyValue);
            queryBlock.setWhere((SQLExpr)opCond);
            whereExpr = opCond;
        }
    }

    protected void onMySQLJoinTablePolicy(SQLJoinTableSource joinTableSource, String tabname, String tabAlias, Map<String, List<String>> rowPolicy) {
        SQLExpr whereExpr = null;
        SQLObject sqlObject = joinTableSource.getParent();
        if (sqlObject instanceof MySqlSelectQueryBlock) {
            MySqlSelectQueryBlock queryBlock = (MySqlSelectQueryBlock)joinTableSource.getParent();
            whereExpr = queryBlock.getWhere();
        } else if (sqlObject instanceof SQLJoinTableSource) {
            whereExpr = joinTableSource.getCondition();
        }
        Set<String> fieldSet = rowPolicy.keySet();
        for (String fieldName : fieldSet) {
            SQLBinaryOpExpr opCond;
            Object expr;
            SQLIdentifierExpr keyName;
            SQLInListExpr keyValue;
            String condtext;
            List<String> values = rowPolicy.get(fieldName);
            if (values == null) continue;
            if (whereExpr == null) {
                if ("@".equals(fieldName)) {
                    condtext = values.get(0).toString();
                    condtext = condtext.replaceAll("@\\.", StringUtils.isEmpty((Object)tabAlias) ? tabname + "." : tabAlias + ".");
                    keyValue = new SQLIdentifierExpr(condtext);
                    whereExpr = keyValue;
                    continue;
                }
                keyName = new SQLIdentifierExpr(StringUtils.isEmpty((Object)tabAlias) ? tabname + "." + fieldName : tabAlias + "." + fieldName);
                keyValue = new SQLInListExpr((SQLExpr)keyName, false);
                for (String value : values) {
                    expr = null;
                    expr = value == null ? new SQLNullExpr() : (value instanceof String ? new SQLCharExpr(value) : new SQLCharExpr(value.toString()));
                    keyValue.getTargetList().add(expr);
                }
                whereExpr = keyValue;
                continue;
            }
            if ("@".equals(fieldName)) {
                condtext = values.get(0).toString();
                condtext = condtext.replaceAll("@\\.", StringUtils.isEmpty((Object)tabAlias) ? tabname + "." : tabAlias + ".");
                keyValue = new SQLIdentifierExpr(condtext);
                opCond = new SQLBinaryOpExpr();
                opCond.setLeft(whereExpr);
                opCond.setOperator(SQLBinaryOperator.BooleanAnd);
                opCond.setRight((SQLExpr)keyValue);
                whereExpr = opCond;
                continue;
            }
            keyName = new SQLIdentifierExpr(StringUtils.isEmpty((Object)tabAlias) ? tabname + "." + fieldName : tabAlias + "." + fieldName);
            keyValue = new SQLInListExpr((SQLExpr)keyName, false);
            for (String value : values) {
                expr = null;
                expr = value == null ? new SQLNullExpr() : (value instanceof String ? new SQLCharExpr(value) : new SQLCharExpr(value.toString()));
                keyValue.getTargetList().add(expr);
            }
            opCond = new SQLBinaryOpExpr();
            opCond.setLeft(whereExpr);
            opCond.setOperator(SQLBinaryOperator.BooleanAnd);
            opCond.setRight((SQLExpr)keyValue);
            whereExpr = opCond;
        }
        if (sqlObject instanceof MySqlSelectQueryBlock) {
            ((MySqlSelectQueryBlock)joinTableSource.getParent()).setWhere(whereExpr);
        } else if (sqlObject instanceof SQLJoinTableSource) {
            joinTableSource.setCondition(whereExpr);
        }
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        builder.keyProperty(ms.getKeyProperties() == null ? null : ms.getKeyProperties()[0]);
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }
}

