/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.filter;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.fastjson.JSONObject;
import com.product.storage.filter.FtSqlSource;
import com.product.storage.filter.UserDataRangeSrv;
import com.product.storage.filter.user.DataRange;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.log4j.Logger;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class ExecutorWrapper
implements Interceptor {
    private static Logger sqlLog = Logger.getLogger((String)"sqlLog");
    private String dbType;

    public Object intercept(Invocation invocation) throws Throwable {
        if (!UserDataRangeSrv.getlocalisrange()) {
            return invocation.proceed();
        }
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String sql = "";
        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[1];
        }
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        sql = boundSql.getSql();
        boolean isexec = false;
        List<DataRange> authList = this.getdatarange();
        if (null == authList || authList.size() < 1) {
            return invocation.proceed();
        }
        for (DataRange dr : authList) {
            if (sql.toLowerCase().indexOf(dr.getTablename()) == -1) continue;
            isexec = true;
            break;
        }
        if (!isexec) {
            return invocation.proceed();
        }
        try {
            JSONObject logJson = new JSONObject();
            List statementList = SQLUtils.toStatementList((String)sql, (String)this.dbType);
            for (SQLStatement stmt : statementList) {
                if (!(stmt instanceof SQLSelectStatement)) continue;
                SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;
                logJson.put("selectSql", (Object)sql);
                if (selectStmt.getSelect().getQuery() instanceof SQLUnionQuery) {
                    logJson.put("result", (Object)this.getUnionSqlInfo((SQLUnionQuery)selectStmt.getSelect().getQuery(), 1));
                } else {
                    logJson.put("result", (Object)this.getSqlInfo((SQLSelectQuery)((SQLSelectQueryBlock)selectStmt.getSelect().getQuery())));
                }
                StringBuffer newSql = new StringBuffer();
                MySqlOutputVisitor visitor = null;
                if (this.dbType.equals("mysql")) {
                    visitor = new MySqlOutputVisitor((Appendable)newSql);
                } else if (this.dbType.equals("oracle")) {
                    visitor = new OracleOutputVisitor((Appendable)newSql);
                } else {
                    throw new Exception("\u672a\u8bc6\u522b\u7684dbType");
                }
                visitor.visit(selectStmt);
                visitor.println();
                visitor.endVisit(selectStmt);
                FtSqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newSql.toString(), boundSql);
                MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, sqlSource);
                invocation.getArgs()[0] = newMs;
                logJson.put("newSql", (Object)newSql.toString());
                sqlLog.info((Object)logJson.toJSONString());
            }
        }
        catch (Exception e) {
            invocation.getArgs()[0] = mappedStatement;
            JSONObject errorJson = new JSONObject();
            errorJson.put("unresolved sql", (Object)sql);
            sqlLog.error((Object)errorJson.toJSONString());
            e.printStackTrace();
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.dbType = properties.getProperty("dbType");
        if (this.dbType == null || this.dbType.equals("")) {
            this.dbType = "mysql";
        }
    }

    private List<DataRange> getdatarange() {
        List<DataRange> listdr = UserDataRangeSrv.getlocaldatarange();
        return listdr;
    }

    public JSONObject getSqlInfo(SQLSelectQuery selectQuery) throws Exception {
        JSONObject resultJson = new JSONObject();
        SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectQuery;
        resultJson.put("selectField", (Object)this.getSelectField(query.getSelectList()));
        resultJson.put("selectGroupBy", query.getGroupBy() == null ? null : query.getGroupBy().toString());
        JSONObject tableJson = this.getTableInfo(query.getFrom(), query);
        return tableJson;
    }

    private String getSelectField(List<SQLSelectItem> sqlSelectList) {
        String selectFields = "";
        for (int i = 0; i < sqlSelectList.size(); ++i) {
            SQLSelectItem item = sqlSelectList.get(i);
            if (item.getExpr() instanceof SQLAggregateExpr) {
                SQLAggregateExpr expr = (SQLAggregateExpr)item.getExpr();
                String methodName = expr.getMethodName();
                selectFields = selectFields + methodName + "(";
                List args = expr.getArguments();
                for (int j = 0; j < args.size(); ++j) {
                    selectFields = selectFields + ((SQLExpr)args.get(j)).toString() + ",";
                }
                selectFields = selectFields + ")";
                continue;
            }
            selectFields = item.getExpr() instanceof SQLQueryExpr ? selectFields + item.getExpr() + "," : selectFields + item.getExpr().toString() + ",";
        }
        if (!selectFields.equals("")) {
            selectFields.substring(0, selectFields.length() - 1);
        }
        return selectFields;
    }

    private String getOrderBy(SQLOrderBy sqlOrderBy) {
        String orderBy = null;
        for (int i = 0; sqlOrderBy != null && i < sqlOrderBy.getItems().size(); ++i) {
            if (orderBy == null) {
                orderBy = "";
            }
            SQLSelectOrderByItem item = (SQLSelectOrderByItem)sqlOrderBy.getItems().get(i);
            orderBy = orderBy + item.getExpr() + " " + item.getType();
            if (i > sqlOrderBy.getItems().size() - 1) continue;
            orderBy = orderBy + ",";
        }
        return orderBy;
    }

    public JSONObject getUnionSqlInfo(SQLUnionQuery selectQuery, int sqlseq) throws Exception {
        JSONObject sqlJson = new JSONObject();
        sqlJson.put("sql" + sqlseq, (Object)this.getSqlInfo(selectQuery.getLeft()));
        ++sqlseq;
        if (selectQuery.getRight() instanceof SQLUnionQuery) {
            sqlJson.putAll((Map)this.getUnionSqlInfo((SQLUnionQuery)selectQuery.getRight(), sqlseq));
        } else if (selectQuery.getRight() instanceof SQLSelectQueryBlock) {
            sqlJson.put("sql" + sqlseq, (Object)this.getSqlInfo(selectQuery.getRight()));
        }
        return sqlJson;
    }

    public JSONObject getTableInfo(SQLTableSource tableSrc, SQLSelectQueryBlock query) throws Exception {
        JSONObject tableJson = new JSONObject();
        JSONObject resultJson = new JSONObject();
        if (tableSrc instanceof SQLExprTableSource) {
            SQLExpr expr = ((SQLExprTableSource)tableSrc).getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr expr1 = (SQLIdentifierExpr)expr;
                tableJson.put("selectTable", (Object)expr1.getName());
            } else {
                SQLPropertyExpr expr1 = (SQLPropertyExpr)((SQLExprTableSource)tableSrc).getExpr();
                tableJson.put("selectTable", (Object)expr1.getName());
            }
            tableJson.put("selectTableAlias", (Object)(tableSrc.getAlias() == null ? "" : tableSrc.getAlias()));
            resultJson.put("selectTable", (Object)tableJson);
            resultJson.put("selectWhere", (Object)this.modifyWhereExpr(tableJson, query));
            return resultJson;
        }
        if (tableSrc instanceof SQLSubqueryTableSource) {
            SQLSelectQueryBlock selectQuery = (SQLSelectQueryBlock)((SQLSubqueryTableSource)tableSrc).getSelect().getQuery();
            tableJson.put("selectField", (Object)this.getSelectField(selectQuery.getSelectList()));
            tableJson.put("selectGroupBy", selectQuery.getGroupBy() == null ? null : selectQuery.getGroupBy().toString());
            JSONObject tempTableJson = this.getTableInfo(selectQuery.getFrom(), selectQuery);
            return tempTableJson;
        }
        if (tableSrc instanceof SQLJoinTableSource) {
            SQLTableSource left = ((SQLJoinTableSource)tableSrc).getLeft();
            SQLTableSource right = ((SQLJoinTableSource)tableSrc).getRight();
            tableJson.put("leftTable", (Object)this.getTableInfo(left, query));
            tableJson.put("rightTable", (Object)this.getTableInfo(right, query));
            tableJson.put("join", (Object)((SQLJoinTableSource)tableSrc).getJoinType());
            return tableJson;
        }
        if (tableSrc instanceof SQLUnionQueryTableSource) {
            SQLUnionQuery selectQuery = ((SQLUnionQueryTableSource)tableSrc).getUnion();
            tableJson.putAll((Map)this.getUnionSqlInfo(selectQuery, 1));
            return tableJson;
        }
        return tableJson;
    }

    private SQLExpr getWhereInfo(String whereSql) {
        SQLStatementParser parser = new SQLStatementParser("select * from test where " + whereSql);
        SQLStatement stmt = parser.parseStatement();
        SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;
        SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectStmt.getSelect().getQuery();
        return query.getWhere();
    }

    private String modifyWhereExpr(JSONObject tableJson, SQLSelectQueryBlock query) {
        Object tableName = tableJson.get((Object)"selectTable");
        Object tableNameAlias = tableJson.get((Object)"selectTableAlias");
        if (tableName == null) {
            tableName = tableJson.get((Object)"leftTable");
            this.modifyWhereExpr((JSONObject)tableName, query);
            tableName = tableJson.get((Object)"rightTable");
            this.modifyWhereExpr((JSONObject)tableName, query);
        } else if (tableName instanceof JSONObject && ((JSONObject)tableName).containsKey((Object)"selectTable") && !(query.getFrom() instanceof SQLSubqueryTableSource)) {
            this.modifyWhereExpr((JSONObject)tableName, query);
        }
        if (tableName != null) {
            String thistable = (String)tableName;
            SQLBinaryOpExpr newWhereExpr = new SQLBinaryOpExpr();
            List<DataRange> authList = this.getdatarange();
            for (DataRange dr : authList) {
                String authTableName = dr.getTablename();
                String authWhereSql = dr.getWherestr();
                if (!thistable.equalsIgnoreCase(authTableName)) continue;
                authWhereSql = authWhereSql.replaceAll("@", tableNameAlias == null || tableNameAlias.equals("") ? tableName.toString() : tableNameAlias.toString());
                SQLExpr authWhereExpr = this.getWhereInfo(authWhereSql);
                if (query.getWhere() != null && query.getWhere() instanceof SQLBinaryOpExpr) {
                    SQLBinaryOpExpr whereExpr = (SQLBinaryOpExpr)query.getWhere();
                    if (whereExpr != null) {
                        newWhereExpr.setOperator(SQLBinaryOperator.BooleanAnd);
                        newWhereExpr.setLeft((SQLExpr)whereExpr);
                        newWhereExpr.setRight(authWhereExpr);
                    }
                } else {
                    newWhereExpr = authWhereExpr;
                }
                query.setWhere((SQLExpr)newWhereExpr);
            }
        }
        StringBuffer whereStr = new StringBuffer();
        if (query.getWhere() != null) {
            Object v = null;
            v = query instanceof OracleSelectQueryBlock ? new OracleOutputVisitor((Appendable)whereStr) : new SQLASTOutputVisitor((Appendable)whereStr);
            query.getWhere().accept((SQLASTVisitor)v);
        }
        return whereStr.toString();
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        builder.keyProperty(ms.getKeyProperties() == null ? null : ms.getKeyProperties()[0]);
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public Map<String, Object> processParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql) {
        HashMap<String, Object> paramMap = null;
        if (parameterObject == null) {
            paramMap = new HashMap<String, Object>();
        } else if (parameterObject instanceof Map) {
            paramMap = new HashMap();
            paramMap.putAll((Map)parameterObject);
        } else {
            paramMap = new HashMap();
            boolean hasTypeHandler = ms.getConfiguration().getTypeHandlerRegistry().hasTypeHandler(parameterObject.getClass());
            MetaObject metaObject = SystemMetaObject.forObject((Object)parameterObject);
            if (!hasTypeHandler) {
                for (String name : metaObject.getGetterNames()) {
                    paramMap.put(name, metaObject.getValue(name));
                }
            }
            if (boundSql.getParameterMappings() != null && boundSql.getParameterMappings().size() > 0) {
                for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                    String name = parameterMapping.getProperty();
                    if (paramMap.get(name) != null || !hasTypeHandler && !parameterMapping.getJavaType().equals(parameterObject.getClass())) continue;
                    paramMap.put(name, parameterObject);
                    break;
                }
            }
        }
        return paramMap;
    }
}

