/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.slice.filter;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.fastjson.JSONObject;
import com.product.storage.filter.FtSqlSource;
import com.product.storage.slice.filter.CollectionUpdateWrapper;
import java.util.List;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Invocation;
import org.slf4j.Logger;

public class CollectionInsertWrapper
extends CollectionUpdateWrapper {
    protected void onInsertStatement(Logger logger, JSONObject logJson, Invocation invocation, MappedStatement mappedStatement, BoundSql boundSql, SQLStatement stmt, String partionKey) throws Throwable {
        SQLInsertStatement insertStmt = (SQLInsertStatement)stmt;
        String collectionName = insertStmt.getTableName().getSimpleName();
        String organizationCode = partionKey;
        if (this.getCollectionMap().keySet().contains(collectionName.toLowerCase())) {
            String fieldName = this.getCollectionMap().get(collectionName.toLowerCase());
            if (this.getOrganizationMap().containsKey(organizationCode)) {
                SQLInsertStatement.ValuesClause dataRow;
                int i;
                String partionCode = String.format("'%1$s'", this.getOrganizationMap().get(organizationCode));
                List fields = insertStmt.getColumns();
                List valueList = insertStmt.getValuesList();
                boolean found = false;
                int fndIndex = 0;
                for (i = 0; i < fields.size(); ++i) {
                    SQLExpr field = (SQLExpr)fields.get(i);
                    if (!fieldName.equalsIgnoreCase(field.toString())) continue;
                    found = true;
                    fndIndex = i;
                }
                if (found) {
                    for (i = 0; i < valueList.size(); ++i) {
                        dataRow = (SQLInsertStatement.ValuesClause)valueList.get(i);
                        dataRow.getValues().set(fndIndex, new SQLIdentifierExpr(partionCode));
                    }
                } else {
                    fields.add(new SQLIdentifierExpr(fieldName));
                    for (i = 0; i < valueList.size(); ++i) {
                        dataRow = (SQLInsertStatement.ValuesClause)valueList.get(i);
                        dataRow.getValues().add(new SQLIdentifierExpr(partionCode));
                    }
                }
            }
        }
        StringBuffer newSql = new StringBuffer();
        MySqlOutputVisitor visitor = null;
        if (this.getDbType().equals("mysql")) {
            visitor = new MySqlOutputVisitor((Appendable)newSql);
        } else if (this.getDbType().equals("oracle")) {
            visitor = new OracleOutputVisitor((Appendable)newSql);
        } else {
            throw new Exception("\u672a\u8bc6\u522b\u7684dbType");
        }
        visitor.visit(insertStmt);
        visitor.println();
        visitor.endVisit(insertStmt);
        FtSqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newSql.toString(), boundSql);
        MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, sqlSource);
        invocation.getArgs()[0] = newMs;
        logJson.put("newSql", (Object)newSql.toString());
        logger.info(String.format("newSQL --->%1$s", newSql.toString().replaceAll("[\\n]", "")));
    }
}

