/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.template;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.parser.ParserConfig;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import com.mongodb.util.JSONParseException;
import com.product.model.ServiceSession;
import com.product.storage.mybatis.ReflectUtil;
import com.product.storage.mybatis.SqlDbSession;
import com.product.storage.parser.QueryExtractor;
import com.product.storage.parser.QueryInsertExtractor;
import com.product.storage.parser.QueryRemoveExtractor;
import com.product.storage.parser.QuerySelectExtractor;
import com.product.storage.parser.QueryUpdateExtractor;
import com.product.storage.strategy.MySqlSessionTemplate;
import com.product.storage.strategy.SqlSessionTemplate;
import com.product.storage.template.FStorageLogger;
import com.product.storage.template.FStorageOperations;
import com.product.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class FMybatisTemplate
implements FStorageOperations {
    private MySqlSessionTemplate sqlTemplate;
    private ExecutorType executorType;
    private final int lostAffect = -2147482646;
    private QueryExtractor.DBTYPE dbType = QueryExtractor.DBTYPE.MYSQL;
    private String chartset = null;
    private final String SQL_SELECT = "mybatis.sql.select";
    private final String SQL_INSERT = "mybatis.sql.insert";
    private final String SQL_UPDATE = "mybatis.sql.update";
    private final String SQL_DELETE = "mybatis.sql.delete";
    private FStorageLogger logger = new FStorageLogger();

    public FMybatisTemplate(SqlSessionFactory sqlSessionFactory) {
        this(sqlSessionFactory, sqlSessionFactory.getConfiguration().getDefaultExecutorType(), null);
    }

    public FMybatisTemplate(SqlSessionFactory sqlSessionFactory, String characterSet) {
        this(sqlSessionFactory, sqlSessionFactory.getConfiguration().getDefaultExecutorType());
    }

    public FMybatisTemplate(SqlSessionFactory sqlSessionFactory, ExecutorType executorType) {
        this(sqlSessionFactory, executorType, null);
    }

    public FMybatisTemplate(SqlSessionFactory sqlSessionFactory, ExecutorType executorType, String characterSet) {
        this.executorType = executorType;
        this.sqlTemplate = new MySqlSessionTemplate(sqlSessionFactory, ExecutorType.SIMPLE);
        this.dbType = this.getDBType();
        this.chartset = characterSet;
    }

    public void onSetContext(ServiceSession session) {
        this.sqlTemplate.onSetContext(session);
    }

    public SqlSessionTemplate getSqlSessionTemplate() {
        return this.sqlTemplate;
    }

    public SqlDbSession getSqlDbSession() {
        SqlDbSession dbSession = new SqlDbSession(this.sqlTemplate, this.executorType);
        return dbSession;
    }

    public static String makeFullSqlStatement(String nameSpace, String sqlId) {
        if (org.springframework.util.StringUtils.isEmpty((Object)sqlId)) {
            return nameSpace;
        }
        return nameSpace + "." + sqlId;
    }

    @Override
    public void destroy() {
    }

    @Override
    public <T> T selectOne(Query query, Class<T> entityClass) {
        return this.selectOne(query, entityClass, this.fetchAnnotationTableName(entityClass));
    }

    @Override
    public <T> T selectOne(Query query, Class<T> entityClass, String tableName) {
        QuerySelectExtractor extractor = new QuerySelectExtractor(tableName, query);
        String sql = extractor.getQueryForSQL(this.dbType);
        this.logger.logSQLQuery(sql);
        return this.toJavaObject(this.sqlTemplate.selectOne("mybatis.sql.select", this.convertChartsetSQL(sql)), entityClass);
    }

    @Override
    public Map<String, Object> selectOne(Query query, String tableName) {
        QuerySelectExtractor extractor = new QuerySelectExtractor(tableName, query);
        String sql = extractor.getQueryForSQL(this.dbType);
        this.logger.logSQLQuery(sql);
        return (Map)this.sqlTemplate.selectOne("mybatis.sql.select", this.convertChartsetSQL(sql));
    }

    @Override
    public <T> List<T> select(Query query, Class<T> entityClass) {
        return this.select(query, entityClass, this.fetchAnnotationTableName(entityClass));
    }

    @Override
    public <T> List<T> select(Query query, Class<T> entityClass, String tableName) {
        QuerySelectExtractor extractor = new QuerySelectExtractor(tableName, query);
        String sql = extractor.getQueryForSQL(this.dbType);
        this.logger.logSQLQuery(sql);
        if (query != null && (query.getLimit() > 0 || query.getSkip() > 0) && this.dbType != QueryExtractor.DBTYPE.MYSQL) {
            int offset = query.getSkip() > 0 ? query.getSkip() : 0;
            int limit = query.getLimit() > 0 ? query.getLimit() : Integer.MAX_VALUE;
            RowBounds rowBounds = new RowBounds(offset, limit);
            return this.toJavaObjectList(this.sqlTemplate.selectList("mybatis.sql.select", this.convertChartsetSQL(sql), rowBounds), entityClass);
        }
        return this.toJavaObjectList(this.sqlTemplate.selectList("mybatis.sql.select", this.convertChartsetSQL(sql)), entityClass);
    }

    @Override
    public List<Map<String, Object>> select(Query query, String tableName) {
        QuerySelectExtractor extractor = new QuerySelectExtractor(tableName, query);
        String sql = extractor.getQueryForSQL(this.dbType);
        this.logger.logSQLQuery(sql);
        if (query != null && (query.getLimit() > 0 || query.getSkip() > 0) && this.dbType != QueryExtractor.DBTYPE.MYSQL) {
            int offset = query.getSkip() > 0 ? query.getSkip() : 0;
            int limit = query.getLimit() > 0 ? query.getLimit() : Integer.MAX_VALUE;
            RowBounds rowBounds = new RowBounds(offset, limit);
            return this.sqlTemplate.selectList("mybatis.sql.select", this.convertChartsetSQL(sql), rowBounds);
        }
        return this.sqlTemplate.selectList("mybatis.sql.select", this.convertChartsetSQL(sql));
    }

    @Override
    public long count(Query query, Class<?> entityClass) {
        return this.count(query, this.fetchAnnotationTableName(entityClass));
    }

    @Override
    public long count(Query query, String tableName) {
        int oldlimit = 0;
        int oldskip = 0;
        if (query != null) {
            oldlimit = query.getLimit();
            oldskip = query.getSkip();
            query.limit(0);
            query.skip(0);
        }
        QuerySelectExtractor extractor = new QuerySelectExtractor(tableName, query);
        String sql = extractor.getQueryForSQL(this.dbType);
        sql = "select count(1) as total from " + StringUtils.substringAfter((String)sql, (String)"FROM");
        this.logger.logSQLQuery(sql);
        if (oldlimit > 0) {
            query.limit(oldlimit);
        }
        if (oldskip > 0) {
            query.skip(oldskip);
        }
        List results = this.sqlTemplate.selectList("mybatis.sql.select", this.convertChartsetSQL(sql));
        Map map = (Map)results.get(0);
        long total = TypeUtils.castToLong(map.get("total"));
        return total;
    }

    @Override
    public void insert(Object objectToSave) {
        this.insert(objectToSave, this.fetchAnnotationTableName(objectToSave.getClass()));
    }

    @Override
    public int insert(Object objectToSave, String tableName) {
        QueryInsertExtractor extractor = new QueryInsertExtractor(tableName, this.toDbObject(objectToSave));
        String sql = extractor.getQueryForSQL(this.dbType);
        this.logger.logSQLQuery(sql);
        return this.sqlTemplate.insert("mybatis.sql.insert", this.convertChartsetSQL(sql));
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, Class<?> entityClass) {
        for (Object object : batchToSave) {
            this.insert(object);
        }
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, String tableName) {
        for (Object object : batchToSave) {
            this.insert(object, tableName);
        }
    }

    @Override
    public void insertAll(Collection<? extends Object> objectsToSave) {
        for (Object object : objectsToSave) {
            this.insert(object);
        }
    }

    @Override
    public int updateOrInsert(Query query, Update update, Class<?> entityClass) {
        return this.updateOrInsert(query, update, entityClass, this.fetchAnnotationTableName(entityClass));
    }

    @Override
    public int updateOrInsert(Query query, Update update, String tableName) {
        return this.updateOrInsert(query, update, null, tableName);
    }

    @Override
    public int updateOrInsert(Query query, Update update, Class<?> entityClass, String tableName) {
        int n = this.update(query, update, tableName);
        if (n <= 0) {
            this.insert(update, tableName);
        }
        return n;
    }

    @Override
    public int update(Query query, Update update, Class<?> entityClass) {
        return this.update(query, update, entityClass, this.fetchAnnotationTableName(entityClass));
    }

    @Override
    public int update(Query query, Update update, String tableName) {
        return this.update(query, update, null, tableName);
    }

    @Override
    public int update(Query query, Update update, Class<?> entityClass, String tableName) {
        QueryUpdateExtractor extractor = new QueryUpdateExtractor(tableName, query, update);
        String sql = extractor.getQueryForSQL(this.dbType);
        this.logger.logSQLQuery(sql);
        int n = this.sqlTemplate.update("mybatis.sql.update", this.convertChartsetSQL(sql));
        if (n == -2147482646) {
            return 1;
        }
        return n;
    }

    @Override
    public int delete(Object object) {
        return this.delete(object, this.fetchAnnotationTableName(object.getClass()));
    }

    @Override
    public int delete(Object object, String tableName) {
        Criteria criteria = null;
        Field fld = this.fetchDeclaredField(object.getClass(), "ID_KEY");
        if (fld != null) {
            try {
                String idkey = fld.get(null).toString();
                fld = this.fetchDeclaredField(object.getClass(), idkey);
                if (fld != null) {
                    criteria = Criteria.where((String)idkey).is(fld.get(object));
                }
            }
            catch (Exception idkey) {
                // empty catch block
            }
        }
        if (criteria == null) {
            criteria = new Criteria();
            DBObject dbDoc = this.toDbObject(object);
            Set keys = dbDoc.keySet();
            for (String key : keys) {
                Object obj = dbDoc.get(key);
                if (org.springframework.util.StringUtils.isEmpty((Object)obj)) continue;
                criteria = criteria.and(key).is(obj);
            }
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return this.delete(query, tableName);
    }

    @Override
    public int delete(Query query, Class<?> entityClass) {
        return this.delete(query, entityClass, this.fetchAnnotationTableName(entityClass));
    }

    @Override
    public int delete(Query query, Class<?> entityClass, String tableName) {
        return this.delete(query, tableName);
    }

    @Override
    public int delete(Query query, String tableName) {
        QueryRemoveExtractor extractor = new QueryRemoveExtractor(tableName, query);
        String sql = extractor.getQueryForSQL(this.dbType);
        this.logger.logSQLQuery(sql);
        int n = this.sqlTemplate.delete("mybatis.sql.delete", this.convertChartsetSQL(sql));
        if (n == -2147482646) {
            return 1;
        }
        return n;
    }

    private String fetchAnnotationTableName(Class<?> cl) {
        Annotation[] annos;
        for (Annotation ann : annos = cl.getAnnotations()) {
            if (!(ann instanceof Document)) continue;
            return ((Document)ann).collection();
        }
        String name = cl.getName();
        return (name = name.substring(name.lastIndexOf(".") + 1).toLowerCase()).endsWith("bean") ? name.substring(0, name.length() - 4) : name;
    }

    private Field fetchDeclaredField(Class<?> classDefine, String fieldName) {
        Field field;
        block2: {
            field = null;
            try {
                field = classDefine.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                if (classDefine.getSuperclass() == null) break block2;
                return this.fetchDeclaredField(classDefine.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    private StringBuffer fetchAllDeclaredField(Class<?> classDefine, StringBuffer sb) {
        Field[] flds;
        for (Field fld : flds = classDefine.getDeclaredFields()) {
            Annotation[] annos;
            if (Modifier.isStatic(fld.getModifiers())) continue;
            String fldname = fld.getName();
            boolean istransient = false;
            for (Annotation ann : annos = fld.getAnnotations()) {
                if (ann instanceof Transient) {
                    istransient = true;
                    break;
                }
                if (!(ann instanceof org.springframework.data.mongodb.core.mapping.Field)) continue;
                fldname = ((org.springframework.data.mongodb.core.mapping.Field)ann).value();
            }
            if (istransient) continue;
            sb.append(fldname + ",");
        }
        if (classDefine.getSuperclass() != null) {
            this.fetchAllDeclaredField(classDefine.getSuperclass(), sb);
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    private <T> DBObject toDbObject(T objectToSave) {
        if (!(objectToSave instanceof String)) {
            BasicDBObject dbDoc = new BasicDBObject();
            if (objectToSave instanceof Map) {
                Map map = (Map)objectToSave;
                Set keys = map.keySet();
                for (String key : keys) {
                    dbDoc.put(key, map.get(key));
                }
            } else {
                String[] flds;
                if (objectToSave instanceof Update) {
                    Update update = (Update)objectToSave;
                    for (String str : update.getUpdateObject().keySet()) {
                        Object value = update.getUpdateObject().get(str);
                        Map map = (Map)value;
                        Set keys = map.keySet();
                        for (String key : keys) {
                            dbDoc.put(key, map.get(key));
                        }
                    }
                    return dbDoc;
                }
                Class<?> clz = objectToSave.getClass();
                StringBuffer sb = new StringBuffer();
                this.fetchAllDeclaredField(clz, sb);
                for (String s : flds = sb.toString().split(",")) {
                    Method getMethod;
                    String getMethodName = "get" + s.substring(0, 1).toUpperCase() + s.substring(1);
                    try {
                        getMethod = clz.getDeclaredMethod(getMethodName, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            getMethod = clz.getSuperclass().getDeclaredMethod(getMethodName, new Class[0]);
                        }
                        catch (Exception ex) {
                            getMethod = null;
                        }
                    }
                    if (getMethod == null) continue;
                    try {
                        Object val = getMethod.invoke(objectToSave, new Object[0]);
                        if (val == null) continue;
                        dbDoc.put(s, val);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return dbDoc;
        }
        try {
            return (DBObject)JSON.parse((String)((String)objectToSave));
        }
        catch (JSONParseException e) {
            throw new MappingException("Could not parse given String to save into a JSON document!", (Throwable)e);
        }
    }

    public <T> T toJavaObject(Object obj, Class<T> entityClass) {
        return TypeUtils.cast(obj, entityClass, ParserConfig.getGlobalInstance());
    }

    public <T> List<T> toJavaObjectList(List<?> objlist, Class<T> entityClass) {
        ArrayList<T> list = new ArrayList<T>();
        for (Object obj : objlist) {
            list.add(this.toJavaObject(obj, entityClass));
        }
        return list;
    }

    private QueryExtractor.DBTYPE getDBType() {
        String type = "";
        DataSource dataSource = this.sqlTemplate.getConfiguration().getEnvironment().getDataSource();
        type = dataSource instanceof DruidDataSource ? ((String)ReflectUtil.getFieldValue(dataSource, "jdbcUrl")).toLowerCase() : ((String)ReflectUtil.getFieldValue(dataSource, "url")).toLowerCase();
        int first = type.indexOf(":");
        if ("mysql".equalsIgnoreCase(type = type.substring(first + 1, type.indexOf(":", first + 1)))) {
            return QueryExtractor.DBTYPE.MYSQL;
        }
        if ("oracle".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.ORACLE;
        }
        if ("sqlserver".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.SQLSERVER;
        }
        if ("postgresql".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.POSTGRESQL;
        }
        if ("db2".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.DB2;
        }
        if ("h2".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.H2;
        }
        if ("derby".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.DERBY;
        }
        if ("sqlite".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.SQLITE;
        }
        if ("sysbase".equalsIgnoreCase(type)) {
            return QueryExtractor.DBTYPE.SYSBASE;
        }
        return QueryExtractor.DBTYPE.OTHERSQL;
    }

    private String convertChartsetSQL(String sql) {
        if (org.springframework.util.StringUtils.isEmpty((Object)this.chartset)) {
            return sql;
        }
        try {
            String s = new String(sql.getBytes("GBK"), this.chartset);
            return s;
        }
        catch (Exception ex) {
            return sql;
        }
    }
}

