/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.product.exception.ServiceRuntimeException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateTimeFormatUtil {
    public static final SimpleDateFormat standstandardDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat standstandardDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat standstandardTimeFormat = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat dayStartDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
    public static final SimpleDateFormat dayEndDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
    public static final Long ONEDAYMS = 86400000L;

    private DateTimeFormatUtil() {
    }

    public static String nowToDateTime() {
        return DateTimeFormatUtil.toDateTime(new Date());
    }

    public static String toDateTime(Date dateTime) {
        return DateTimeFormatUtil.toDateTime(dateTime, standstandardDateTimeFormat);
    }

    public static String toDateTime(Date dateTime, DateFormat dateFormat) {
        return dateTime == null ? "" : dateFormat.format(dateTime);
    }

    public static String nowToDate() {
        return DateTimeFormatUtil.toDate(new Date());
    }

    public static String toDate(Date dateTime) {
        return DateTimeFormatUtil.toDateTime(dateTime, standstandardDateFormat);
    }

    public static String nowToTime() {
        return DateTimeFormatUtil.toDateTime(new Date());
    }

    public static String toTime(Date dateTime) {
        return DateTimeFormatUtil.toDateTime(dateTime, standstandardTimeFormat);
    }

    public static String format(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return DateTimeFormatUtil.toDateTime(date, dateFormat);
    }

    public static Date parseDate(String dateTime) {
        try {
            return standstandardDateTimeFormat.parse(dateTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u65f6\u95f4\u8f6c\u6362\u51fa\u9519");
        }
    }

    public static Date parse(String date, SimpleDateFormat dateFormat) {
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u65f6\u95f4\u8f6c\u6362\u51fa\u9519");
        }
    }
}

