/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.product.component.JDBCCompomentServiceImpl;
import com.product.exception.ServiceRuntimeException;
import com.product.model.BeanConstant;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.ServiceAssert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

public class ServiceComUtil {
    private static Logger logger = LoggerFactory.getLogger(ServiceComUtil.class);

    private ServiceComUtil() {
    }

    public static void parsePage(JSONObject paramsObject) {
        boolean defLimit = false;
        int defOffset = BeanConstant.QueryPage.DEFAULT_PAGESIZE;
        if (paramsObject.containsKey((Object)"page_no") && paramsObject.containsKey((Object)"page_size")) {
            int page_no = paramsObject.getIntValue("page_no");
            int page_size = paramsObject.getIntValue("page_size");
            int offset = page_size <= 0 ? defOffset : page_size;
            int limit = page_no <= 0 ? 0 : (page_no - 1) * page_size;
            paramsObject.put("limit", (Object)limit);
            paramsObject.put("offset", (Object)offset);
        } else {
            paramsObject.put("limit", (Object)0);
            paramsObject.put("offset", (Object)defOffset);
        }
    }

    public static ServiceResponse doForEach(JDBCCompomentServiceImpl<?> serviceImpl, ServiceSession session, JSONObject paramsObject, BiConsumer<Integer, JSONObject> cons) {
        ServiceResponse resp = serviceImpl.onQuery(session, paramsObject);
        ServiceAssert.isSuccess(resp);
        JSONObject data = (JSONObject)resp.getData();
        if (data.getLong("total_results") == 0L) {
            return resp;
        }
        JSONArray objArr = data.getJSONArray(serviceImpl.getCollectionName());
        for (int i = 0; i < objArr.size(); ++i) {
            JSONObject doObj = objArr.getJSONObject(i);
            cons.accept(i, doObj);
        }
        JSONObject map = new JSONObject();
        map.put("total_results", (Object)data.getLong("total_results"));
        map.put(serviceImpl.getCollectionName(), (Object)objArr);
        resp.setData(map);
        return resp;
    }

    public static <T> T getById(JDBCCompomentServiceImpl<T> serviceImpl, ServiceSession session, String id) {
        return ServiceComUtil.getById(serviceImpl, session, id, serviceImpl.isUseEntID());
    }

    public static <T> T getById(JDBCCompomentServiceImpl<T> serviceImpl, ServiceSession session, String id, boolean isEntId) {
        FMybatisTemplate template = serviceImpl.getTemplate();
        template.onSetContext(session);
        Criteria criteria = Criteria.where((String)serviceImpl.getKeyfieldName()).is((Object)id);
        if (isEntId) {
            criteria = criteria.and(serviceImpl.getEntname()).is((Object)session.getEnt_id());
        }
        Query query = new Query((CriteriaDefinition)criteria);
        Class<T> entityClass = ServiceComUtil.getBeanClass(serviceImpl);
        T t = template.selectOne(query, entityClass, serviceImpl.getCollectionName());
        return t;
    }

    private static <T> Class<T> getBeanClass(JDBCCompomentServiceImpl<T> serviceImpl) {
        Class entityClass = null;
        try {
            Method method = Class.forName("com.product.component.BaseServiceImpl").getDeclaredMethod("getBeanClass", new Class[0]);
            method.setAccessible(true);
            entityClass = (Class)method.invoke(serviceImpl, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ServiceRuntimeException(String.format("\u7c7b:[%s]\u83b7\u53d6\u7c7b\u578b\u5f02\u5e38:[%s]", serviceImpl.getClass(), e.getMessage()));
        }
        return entityClass;
    }

    public static <T> T getT(JDBCCompomentServiceImpl<T> serviceImpl, ServiceSession session, JSONObject paramsObject) {
        logger.info("useEntID =: " + serviceImpl.isUseEntID());
        T t = ServiceComUtil.getT(serviceImpl, session, paramsObject, serviceImpl.isUseEntID());
        ServiceAssert.assertNotNull(t);
        return t;
    }

    public static <T> T getT(JDBCCompomentServiceImpl<T> serviceImpl, ServiceSession session, JSONObject paramsObject, boolean isEntId) {
        FMybatisTemplate template = serviceImpl.getTemplate();
        template.onSetContext(session);
        Class<T> entityClass = ServiceComUtil.getBeanClass(serviceImpl);
        Criteria criteria = isEntId ? Criteria.where((String)serviceImpl.getEntname()).is((Object)session.getEnt_id()) : new Criteria();
        Set entrys = paramsObject.entrySet();
        for (Map.Entry param : entrys) {
            if (param.getValue() instanceof Collection) {
                Object[] inparam = ((Collection)param.getValue()).toArray();
                criteria = criteria.and((String)param.getKey()).in(inparam);
                continue;
            }
            criteria = criteria.and((String)param.getKey()).is(param.getValue());
        }
        Query query = new Query((CriteriaDefinition)criteria);
        T t = template.selectOne(query, entityClass, serviceImpl.getCollectionName());
        return t;
    }

    public static <T> T getFirst(JDBCCompomentServiceImpl<T> serviceImpl, ServiceSession session, Sort sort, JSONObject paramsObject) {
        T t = ServiceComUtil.getFirst(serviceImpl, session, sort, paramsObject, serviceImpl.isUseEntID());
        ServiceAssert.assertNotNull(t);
        return t;
    }

    public static <T> T getFirst(JDBCCompomentServiceImpl<T> serviceImpl, ServiceSession session, Sort sort, JSONObject paramsObject, boolean isEntId) {
        FMybatisTemplate template = serviceImpl.getTemplate();
        template.onSetContext(session);
        Class<T> entityClass = ServiceComUtil.getBeanClass(serviceImpl);
        Criteria criteria = isEntId ? Criteria.where((String)serviceImpl.getEntname()).is((Object)session.getEnt_id()) : new Criteria();
        Set entrys = paramsObject.entrySet();
        for (Map.Entry param : entrys) {
            if (param.getValue() instanceof Collection) {
                Object[] inparam = ((Collection)param.getValue()).toArray();
                criteria = criteria.and((String)param.getKey()).in(inparam);
                continue;
            }
            criteria = criteria.and((String)param.getKey()).is(param.getValue());
        }
        Query query = new Query((CriteriaDefinition)criteria);
        if (sort != null) {
            query.with(sort);
        }
        query.limit(1);
        T t = template.selectOne(query, entityClass, serviceImpl.getCollectionName());
        return t;
    }

    public static <T> List<T> listT(JDBCCompomentServiceImpl<T> serviceImpl, ServiceSession session, JSONObject paramsObject) {
        logger.info("useEntID =: " + serviceImpl.isUseEntID());
        return ServiceComUtil.listT(serviceImpl, session, null, paramsObject, serviceImpl.isUseEntID());
    }

    public static <T> List<T> listT(JDBCCompomentServiceImpl<T> serviceImpl, ServiceSession session, Sort sort, JSONObject paramsObject) {
        return ServiceComUtil.listT(serviceImpl, session, sort, paramsObject, serviceImpl.isUseEntID());
    }

    public static <T> List<T> listT(JDBCCompomentServiceImpl<T> serviceImpl, ServiceSession session, Sort sort, JSONObject paramsObject, boolean isEntId) {
        FMybatisTemplate template = serviceImpl.getTemplate();
        template.onSetContext(session);
        Class<T> entityClass = ServiceComUtil.getBeanClass(serviceImpl);
        Criteria criteria = isEntId ? Criteria.where((String)serviceImpl.getEntname()).is((Object)session.getEnt_id()) : new Criteria();
        Set entrys = paramsObject.entrySet();
        for (Map.Entry param : entrys) {
            if (param.getValue() instanceof Collection) {
                Object[] inparam = ((Collection)param.getValue()).toArray();
                criteria = criteria.and((String)param.getKey()).in(inparam);
                continue;
            }
            criteria = criteria.and((String)param.getKey()).is(param.getValue());
        }
        Query query = new Query((CriteriaDefinition)criteria);
        if (sort != null) {
            query.with(sort);
        }
        return template.select(query, entityClass, serviceImpl.getCollectionName());
    }

    public static long count(JDBCCompomentServiceImpl<?> serviceImpl, ServiceSession session, JSONObject paramsObject) {
        return ServiceComUtil.count(serviceImpl, session, paramsObject, serviceImpl.isUseEntID());
    }

    public static long count(JDBCCompomentServiceImpl<?> serviceImpl, ServiceSession session, JSONObject paramsObject, boolean isEntId) {
        FMybatisTemplate template = serviceImpl.getTemplate();
        template.onSetContext(session);
        Criteria criteria = isEntId ? Criteria.where((String)serviceImpl.getEntname()).is((Object)session.getEnt_id()) : new Criteria();
        Set entrys = paramsObject.entrySet();
        for (Map.Entry param : entrys) {
            if (param.getValue() instanceof Collection) {
                Object[] inparam = ((Collection)param.getValue()).toArray();
                criteria = criteria.and((String)param.getKey()).in(inparam);
                continue;
            }
            criteria = criteria.and((String)param.getKey()).is(param.getValue());
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return template.count(query, serviceImpl.getCollectionName());
    }

    public static JSONObject jsonCopy(Map<String, Object> paramsObject, String ... keys) {
        JSONObject newparamsObject = new JSONObject(keys.length);
        for (String key : keys) {
            if (!paramsObject.containsKey(key)) continue;
            newparamsObject.put(key, paramsObject.get(key));
        }
        return newparamsObject;
    }

    public static <T> void update(JDBCCompomentServiceImpl<T> serviceImpl, ServiceSession session, List<T> models) {
        JSONArray modelArr = JSON.parseArray((String)JSON.toJSONString(models));
        JSONObject paramObject = new JSONObject();
        paramObject.put(serviceImpl.getCollectionName(), (Object)modelArr);
        ServiceResponse resp = serviceImpl.onUpdate(session, paramObject);
        ServiceAssert.isSuccess(resp);
    }

    public static <T> void update(JDBCCompomentServiceImpl<T> serviceImpl, ServiceSession session, T model) {
        JSONObject paramObject = JSON.parseObject((String)JSON.toJSONString(model));
        ServiceResponse resp = serviceImpl.onUpdate(session, paramObject);
        ServiceAssert.isSuccess(resp);
    }

    public static <T> void insert(JDBCCompomentServiceImpl<T> serviceImpl, ServiceSession session, T model) {
        JSONObject paramObject = JSON.parseObject((String)JSON.toJSONString(model));
        ServiceResponse resp = serviceImpl.onInsert(session, paramObject);
        ServiceAssert.isSuccess(resp);
    }

    public static <T> void insert(JDBCCompomentServiceImpl<T> serviceImpl, ServiceSession session, List<T> models) {
        JSONArray modelArr = JSON.parseArray((String)JSON.toJSONString(models));
        JSONObject paramObject = new JSONObject();
        paramObject.put(serviceImpl.getCollectionName(), (Object)modelArr);
        ServiceResponse resp = serviceImpl.onInsert(session, paramObject);
        ServiceAssert.isSuccess(resp);
    }

    public static void mapRemoveNull(Map<String, Object> map) {
        Set<String> keys = map.keySet();
        Iterator<String> ite = keys.iterator();
        while (ite.hasNext()) {
            String key = ite.next();
            Object obj = map.get(key);
            if (obj instanceof Map) {
                ServiceComUtil.mapRemoveNull((Map)obj);
                if (!((Map)obj).isEmpty()) continue;
                ite.remove();
                continue;
            }
            if (obj instanceof Collection) {
                if (((Collection)obj).size() != 0) continue;
                ite.remove();
                continue;
            }
            if (!StringUtils.isEmpty((Object)obj)) continue;
            ite.remove();
        }
    }

    public static String getCreator(ServiceSession session) {
        return String.format("[%s]%s", session.getUser_code(), session.getUser_name());
    }
}

