/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.product.util.StaticVariable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class StatisticUtils {
    private static final Logger logger = LoggerFactory.getLogger(StatisticUtils.class);
    private static final DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static final Map<String, AtomicInteger> methodCountMap = new ConcurrentHashMap<String, AtomicInteger>();
    private static final AtomicInteger threadCount = new AtomicInteger(0);

    private static void onIncrementNotify(String methodName, int count, int total) {
        String tag = methodName + "";
        logger.info("run parallel before:--->\u5f53\u524d\u65f6\u95f4:{} \u6267\u884c\u65b9\u6cd5:{} \u5e76\u53d1\u6570:{} \u5168\u5c40\u5e76\u53d1:{}", new Object[]{formatter.format(new Date()), tag, count, total});
    }

    private static void onDecrementNotify(String methodName, int count, int total, Long elapsed) {
        String tag = methodName + "";
        if (elapsed > 300L) {
            logger.warn("run parallel after:--->\u5f53\u524d\u65f6\u95f4:{} \u6267\u884c\u65b9\u6cd5:{} \u5e76\u53d1\u6570:{} \u5168\u5c40\u5e76\u53d1:{} \u8017\u65f6\u65f6\u95f4:{}", new Object[]{formatter.format(new Date()), tag, count, total, elapsed});
        } else {
            logger.info("run parallel after:--->\u5f53\u524d\u65f6\u95f4:{} \u6267\u884c\u65b9\u6cd5:{} \u5e76\u53d1\u6570:{} \u5168\u5c40\u5e76\u53d1:{} \u8017\u65f6\u65f6\u95f4:{}", new Object[]{formatter.format(new Date()), tag, count, total, elapsed});
        }
    }

    private static synchronized void doIncrementMethod(String methodName, int total) {
        if (methodCountMap.containsKey(methodName)) {
            AtomicInteger aCounter = methodCountMap.get(methodName);
            int count = aCounter.incrementAndGet();
            StatisticUtils.onIncrementNotify(methodName, count, total);
        } else {
            methodCountMap.put(methodName, new AtomicInteger(1));
            StatisticUtils.onIncrementNotify(methodName, 0, total);
        }
    }

    public static void onIncrementMethod(String methodName) {
        int total = threadCount.incrementAndGet();
        if (!StringUtils.isEmpty((Object)methodName)) {
            if (methodCountMap.containsKey(methodName)) {
                AtomicInteger aCounter = methodCountMap.get(methodName);
                int count = aCounter.incrementAndGet();
                StatisticUtils.onIncrementNotify(methodName, count, total);
            } else {
                StatisticUtils.doIncrementMethod(methodName, total);
            }
        }
    }

    private static synchronized void doDecrementMethod(String methodName, int total, Long elapsed) {
        if (methodCountMap.containsKey(methodName)) {
            AtomicInteger aCounter = methodCountMap.get(methodName);
            int mCount = aCounter.incrementAndGet();
            StatisticUtils.onDecrementNotify(methodName, mCount, total, elapsed);
        } else {
            methodCountMap.put(methodName, new AtomicInteger(0));
            StatisticUtils.onDecrementNotify(methodName, 0, total, elapsed);
        }
    }

    public static void onDecrementMethod(String methodName, Long elapsed) {
        int total = threadCount.decrementAndGet();
        if (!StringUtils.isEmpty((Object)methodName)) {
            if (methodCountMap.containsKey(methodName)) {
                AtomicInteger aCounter = methodCountMap.get(methodName);
                int count = aCounter.decrementAndGet();
                StatisticUtils.onDecrementNotify(methodName, count, total, elapsed);
            } else {
                StatisticUtils.doDecrementMethod(methodName, total, elapsed);
            }
        }
    }

    public static String onDescibeMethod() {
        String response = "";
        int total = threadCount.get();
        Object methodObject = StaticVariable.get("StatisticUtils.methodName");
        Object startTimeObject = StaticVariable.get("StatisticUtils.startTimeMillis");
        String methodName = methodObject == null ? "#" : methodObject.toString();
        long startTimeMillis = startTimeObject == null ? 0L : (Long)startTimeObject;
        long endTimeMillis = System.currentTimeMillis();
        long elapsed = endTimeMillis - startTimeMillis;
        if (!StringUtils.isEmpty((Object)methodName) && methodCountMap.containsKey(methodName)) {
            AtomicInteger aCounter = methodCountMap.get(methodName);
            int count = aCounter.get();
            String tag = methodName + "";
            response = String.format("\u5f53\u524d\u65f6\u95f4:%1$s \u6267\u884c\u65b9\u6cd5:%2$s \u5e76\u53d1\u6570:%3$d \u5168\u5c40\u5e76\u53d1:%4$d \u8017\u65f6\u65f6\u95f4:%5$d", formatter.format(new Date()), tag, count, total, elapsed);
        }
        return response;
    }
}

