/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.product.annotation.ReferQueryImpl;
import com.product.annotation.ReferServiceImpl;
import com.product.annotation.UniqueKeyImpl;
import com.product.annotation.VerificationImpl;
import com.product.component.BaseCompomentServiceImpl;
import com.product.exception.ServiceException;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import java.util.List;
import java.util.Map;
import org.bson.BSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public abstract class JDBCCompomentServiceImpl<X>
extends BaseCompomentServiceImpl<FMybatisTemplate, X> {
    @Autowired
    protected RestTemplate restTemplate;
    private FMybatisTemplate mybatisTemplate;
    private boolean upsert = true;

    @Override
    public FMybatisTemplate getTemplate() {
        return this.mybatisTemplate;
    }

    public JDBCCompomentServiceImpl(FMybatisTemplate mybatisTemplate, String collectionName, String keyfieldName) {
        super(collectionName, keyfieldName);
        this.mybatisTemplate = mybatisTemplate;
        final JDBCCompomentServiceImpl self = this;
        VerificationImpl plugin0 = new VerificationImpl(){};
        this.addPlugins(plugin0);
        ReferQueryImpl<FMybatisTemplate> plugin1 = new ReferQueryImpl<FMybatisTemplate>(){

            @Override
            protected FMybatisTemplate getTemplate() {
                return self.getTemplate();
            }

            @Override
            public void onValueSet(Object targetObject, String fieldname, Object fieldValue) {
                Object response = JDBCCompomentServiceImpl.this.onAnnotationSet(targetObject, fieldname, fieldValue);
                if (response == null) {
                    super.onValueSet(targetObject, fieldname, fieldValue);
                }
            }

            @Override
            public Object onValueGet(Object targetObject, String fieldname) {
                Object response = JDBCCompomentServiceImpl.this.onAnnotationGet(targetObject, fieldname);
                if (response == null) {
                    response = super.onValueGet(targetObject, fieldname);
                }
                return response;
            }
        };
        this.addPlugins(plugin1);
        ReferServiceImpl<RestTemplate> plugin2 = new ReferServiceImpl<RestTemplate>(){

            @Override
            protected RestTemplate getTemplate() {
                return self.restTemplate;
            }

            @Override
            public void onValueSet(Object targetObject, String fieldname, Object fieldValue) {
                Object response = JDBCCompomentServiceImpl.this.onAnnotationSet(targetObject, fieldname, fieldValue);
                if (response == null) {
                    super.onValueSet(targetObject, fieldname, fieldValue);
                }
            }

            @Override
            public Object onValueGet(Object targetObject, String fieldname) {
                Object response = JDBCCompomentServiceImpl.this.onAnnotationGet(targetObject, fieldname);
                if (response == null) {
                    response = super.onValueGet(targetObject, fieldname);
                }
                return response;
            }
        };
        this.addPlugins(plugin2);
        UniqueKeyImpl<FMybatisTemplate> plugin3 = new UniqueKeyImpl<FMybatisTemplate>(){

            @Override
            protected FMybatisTemplate getTemplate() {
                return self.getTemplate();
            }
        };
        this.addPlugins(plugin3);
    }

    public Object onAnnotationSet(Object targetObject, String fieldname, Object fieldValue) {
        return null;
    }

    public Object onAnnotationGet(Object targetObject, String fieldname) {
        return null;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public void setUpsert(boolean upsert) {
        this.upsert = upsert;
    }

    @Override
    protected long onCount(ServiceSession session, FMybatisTemplate template, Query query, String collectionName) {
        template.onSetContext(session);
        System.out.println(query.toString());
        return template.count(query, collectionName);
    }

    @Override
    protected <T> List<T> onFind(ServiceSession session, FMybatisTemplate template, Query query, Class<T> entityClass, String collectionName) {
        template.onSetContext(session);
        return template.select(query, entityClass, collectionName);
    }

    protected <T> T onFindOne(ServiceSession session, FMybatisTemplate template, Query query, Class<T> entityClass, String collectionName) {
        template.onSetContext(session);
        return template.selectOne(query, entityClass, collectionName);
    }

    protected abstract DBObject onBeforeRowInsert(Query var1, Update var2);

    protected DBObject onDefaultRowInsert(Query query, Update update) {
        BasicDBObject dbInsert = new BasicDBObject();
        DBObject dbUpdateObject = update.getUpdateObject();
        Object oDataSet = dbUpdateObject.get("$set");
        Object oDataInsert = dbUpdateObject.get("$setOnInsert");
        if (oDataSet != null && oDataSet instanceof DBObject) {
            dbInsert.putAll((BSONObject)((DBObject)oDataSet));
        }
        if (oDataInsert != null && oDataInsert instanceof DBObject) {
            dbInsert.putAll((BSONObject)((DBObject)oDataInsert));
        }
        dbInsert.putAll((BSONObject)query.getQueryObject());
        return dbInsert;
    }

    @Override
    protected int onUpsertd(ServiceSession session, FMybatisTemplate template, Query query, Update update, String collectionName) {
        template.onSetContext(session);
        int n = template.update(query, update, collectionName);
        if (n <= 0 && this.isUpsert()) {
            DBObject dbInsert = this.onBeforeRowInsert(query, update);
            n = template.insert(dbInsert, collectionName);
        }
        return n;
    }

    @Override
    protected void onUpsert(ServiceSession session, FMybatisTemplate template, Query query, Update update, String collectionName) {
        template.onSetContext(session);
        int n = template.update(query, update, collectionName);
        if (n <= 0 && this.isUpsert()) {
            DBObject dbInsert = this.onBeforeRowInsert(query, update);
            template.insert(dbInsert, collectionName);
        }
    }

    @Override
    protected int onUpdate(ServiceSession session, FMybatisTemplate template, Query query, Update update, String collectionName) {
        template.onSetContext(session);
        return template.update(query, update, collectionName);
    }

    @Override
    protected void onInsert(ServiceSession session, FMybatisTemplate template, JSONObject dataRow, String collectionName) {
        template.onSetContext(session);
        template.insert(dataRow, collectionName);
    }

    @Override
    protected int onInsertd(ServiceSession session, FMybatisTemplate template, JSONObject dataRow, String collectionName) {
        template.onSetContext(session);
        return template.insert(dataRow, collectionName);
    }

    @Override
    protected int onRemoved(ServiceSession session, FMybatisTemplate template, Query query, String collectionName) {
        template.onSetContext(session);
        return template.delete(query, collectionName);
    }

    @Override
    protected void onRemove(ServiceSession session, FMybatisTemplate template, Query query, String collectionName) {
        template.onSetContext(session);
        template.delete(query, collectionName);
    }

    protected X getBeanById(ServiceSession session, FMybatisTemplate template, JSONObject paramsObject) throws Exception {
        if (!paramsObject.containsKey((Object)this.getKeyfieldName())) {
            throw new ServiceException("10005", "dependency {0} is illegal key", this.getKeyfieldName());
        }
        Criteria criteria = Criteria.where((String)this.getKeyfieldName()).is(paramsObject.get((Object)this.getKeyfieldName())).and("entId").is((Object)session.getEnt_id());
        Query query = new Query((CriteriaDefinition)criteria);
        return (X)template.selectOne(query, this.getBeanClass(), this.getCollectionName());
    }

    @Override
    public String onBeforeExportData(String params) throws Exception {
        JSONObject jsonparam = JSONObject.parseObject((String)params);
        String tag = jsonparam.getString("tag");
        String token = jsonparam.getString("token");
        Criteria criteria = Criteria.where((String)"tag").is((Object)tag);
        Query query = new Query((CriteriaDefinition)criteria);
        Map tagUrlMap = this.getTemplate().selectOne(query, Map.class, "tagurl");
        if (tagUrlMap == null || StringUtils.isEmpty(tagUrlMap.get("url"))) {
            throw new Exception("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff1a\u6ca1\u6709\u914d\u7f6e\u5bfc\u51fa\u6807\u7b7e\u5bf9\u5e94\u7684url\uff01");
        }
        jsonparam.put("url", (Object)(tagUrlMap.get("url") + "&token=" + token));
        jsonparam.put("tname", tagUrlMap.get("tname"));
        return jsonparam.toJSONString();
    }
}

