/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.filter;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.fastjson.JSONObject;
import com.efuture.redis.component.FtJedisPool;
import com.product.component.AuthorityBaseServiceImpl;
import com.product.model.ServiceSession;
import com.product.storage.filter.FtSqlSource;
import com.product.util.SpringBeanFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.log4j.Logger;
import redis.clients.jedis.Jedis;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class DataRangeExecutorWrapperOld
implements Interceptor {
    private static Logger sqlLog = Logger.getLogger((String)"sqlLog");
    private String dbType;

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Map parameter = (Map)invocation.getArgs()[1];
        ServiceSession serviceSession = (ServiceSession)parameter.get("servicesession");
        BoundSql boundSql = mappedStatement.getBoundSql((Object)parameter);
        String sql = boundSql.getSql();
        boolean isexec = false;
        List<Map<String, String>> authList = this.getdatarange();
        if (authList != null && authList.size() > 0) {
            for (Map<String, String> auth : authList) {
                if (sql.toLowerCase().indexOf(auth.get("tableName").toLowerCase()) == -1) continue;
                isexec = true;
                break;
            }
        }
        if (!isexec) {
            return invocation.proceed();
        }
        try {
            JSONObject logJson = new JSONObject();
            List statementList = SQLUtils.toStatementList((String)sql, (String)this.dbType);
            for (SQLStatement stmt : statementList) {
                if (!(stmt instanceof SQLSelectStatement)) continue;
                SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;
                logJson.put("selectSql", (Object)sql);
                if (selectStmt.getSelect().getQuery() instanceof SQLUnionQuery) {
                    logJson.put("result", (Object)this.getUnionSqlInfo((SQLUnionQuery)selectStmt.getSelect().getQuery(), 1, serviceSession));
                } else {
                    logJson.put("result", (Object)this.getSqlInfo((SQLSelectQuery)((SQLSelectQueryBlock)selectStmt.getSelect().getQuery()), serviceSession));
                }
                StringBuffer newSql = new StringBuffer();
                MySqlOutputVisitor visitor = null;
                if (this.dbType.equals("mysql")) {
                    visitor = new MySqlOutputVisitor((Appendable)newSql);
                } else if (this.dbType.equals("oracle")) {
                    visitor = new OracleOutputVisitor((Appendable)newSql);
                } else {
                    throw new Exception("\u672a\u8bc6\u522b\u7684dbType");
                }
                visitor.visit(selectStmt);
                visitor.println();
                visitor.endVisit(selectStmt);
                FtSqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newSql.toString(), boundSql);
                MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, sqlSource);
                invocation.getArgs()[0] = newMs;
                logJson.put("newSql", (Object)newSql.toString());
                sqlLog.info((Object)logJson.toJSONString());
            }
        }
        catch (Exception e) {
            invocation.getArgs()[0] = mappedStatement;
            JSONObject errorJson = new JSONObject();
            errorJson.put("unresolved sql", (Object)sql);
            sqlLog.error((Object)errorJson.toJSONString());
            e.printStackTrace();
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.dbType = properties.getProperty("dbType");
        if (this.dbType == null || this.dbType.equals("")) {
            this.dbType = "mysql";
        }
    }

    private List<Map<String, String>> getdatarange() {
        ArrayList tableRefList = null;
        FtJedisPool jedisPool = (FtJedisPool)SpringBeanFactory.getBean("jedisPool");
        Jedis jedis = jedisPool.getResource();
        Set tidSets = jedis.zrange("datarangetableref", 0L, -1L);
        if (tidSets != null && tidSets.size() > 0) {
            tableRefList = new ArrayList();
            for (String rid : tidSets) {
                HashMap columnMap = new HashMap();
                List valList = jedis.hmget("datarangetableref:" + rid, new String[]{"tableName", "type", "columnName"});
                columnMap.put("tableName", valList.get(0));
                columnMap.put("type", valList.get(1));
                columnMap.put("columnName", valList.get(2));
                tableRefList.add(columnMap);
            }
        }
        jedis.close();
        return tableRefList;
    }

    private List<String> getDataRangeCategory(ServiceSession serviceSession) {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = (AuthorityBaseServiceImpl)SpringBeanFactory.getBean("authorityBaseServiceImpl");
        return authorityBaseServiceImpl.getDataRangeCategory(serviceSession);
    }

    private List<String> getDataRangeShop(ServiceSession serviceSession) {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = (AuthorityBaseServiceImpl)SpringBeanFactory.getBean("authorityBaseServiceImpl");
        return authorityBaseServiceImpl.getDataRangeShop(serviceSession);
    }

    private List<String> getDataRangeOrg(ServiceSession serviceSession) {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = (AuthorityBaseServiceImpl)SpringBeanFactory.getBean("authorityBaseServiceImpl");
        return authorityBaseServiceImpl.getDataRangeOrg(serviceSession);
    }

    public JSONObject getSqlInfo(SQLSelectQuery selectQuery, ServiceSession serviceSession) throws Exception {
        JSONObject resultJson = new JSONObject();
        SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectQuery;
        resultJson.put("selectField", (Object)this.getSelectField(query.getSelectList()));
        resultJson.put("selectGroupBy", query.getGroupBy() == null ? null : query.getGroupBy().toString());
        JSONObject tableJson = this.getTableInfo(query.getFrom(), query, serviceSession);
        return tableJson;
    }

    private String getSelectField(List<SQLSelectItem> sqlSelectList) {
        String selectFields = "";
        for (int i = 0; i < sqlSelectList.size(); ++i) {
            SQLSelectItem item = sqlSelectList.get(i);
            if (item.getExpr() instanceof SQLAggregateExpr) {
                SQLAggregateExpr expr = (SQLAggregateExpr)item.getExpr();
                String methodName = expr.getMethodName();
                selectFields = selectFields + methodName + "(";
                List args = expr.getArguments();
                for (int j = 0; j < args.size(); ++j) {
                    selectFields = selectFields + ((SQLExpr)args.get(j)).toString() + ",";
                }
                selectFields = selectFields + ")";
                continue;
            }
            selectFields = item.getExpr() instanceof SQLQueryExpr ? selectFields + item.getExpr() + "," : selectFields + item.getExpr().toString() + ",";
        }
        if (!selectFields.equals("")) {
            selectFields.substring(0, selectFields.length() - 1);
        }
        return selectFields;
    }

    private String getOrderBy(SQLOrderBy sqlOrderBy) {
        String orderBy = null;
        for (int i = 0; sqlOrderBy != null && i < sqlOrderBy.getItems().size(); ++i) {
            if (orderBy == null) {
                orderBy = "";
            }
            SQLSelectOrderByItem item = (SQLSelectOrderByItem)sqlOrderBy.getItems().get(i);
            orderBy = orderBy + item.getExpr() + " " + item.getType();
            if (i > sqlOrderBy.getItems().size() - 1) continue;
            orderBy = orderBy + ",";
        }
        return orderBy;
    }

    public JSONObject getUnionSqlInfo(SQLUnionQuery selectQuery, int sqlseq, ServiceSession serviceSession) throws Exception {
        JSONObject sqlJson = new JSONObject();
        sqlJson.put("sql" + sqlseq, (Object)this.getSqlInfo(selectQuery.getLeft(), serviceSession));
        ++sqlseq;
        if (selectQuery.getRight() instanceof SQLUnionQuery) {
            sqlJson.putAll((Map)this.getUnionSqlInfo((SQLUnionQuery)selectQuery.getRight(), sqlseq, serviceSession));
        } else if (selectQuery.getRight() instanceof SQLSelectQueryBlock) {
            sqlJson.put("sql" + sqlseq, (Object)this.getSqlInfo(selectQuery.getRight(), serviceSession));
        }
        return sqlJson;
    }

    public JSONObject getTableInfo(SQLTableSource tableSrc, SQLSelectQueryBlock query, ServiceSession serviceSession) throws Exception {
        JSONObject tableJson = new JSONObject();
        JSONObject resultJson = new JSONObject();
        if (tableSrc instanceof SQLExprTableSource) {
            SQLExpr expr = ((SQLExprTableSource)tableSrc).getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr expr1 = (SQLIdentifierExpr)expr;
                tableJson.put("selectTable", (Object)expr1.getName());
            } else {
                SQLPropertyExpr expr1 = (SQLPropertyExpr)((SQLExprTableSource)tableSrc).getExpr();
                tableJson.put("selectTable", (Object)expr1.getName());
            }
            tableJson.put("selectTableAlias", (Object)(tableSrc.getAlias() == null ? "" : tableSrc.getAlias()));
            resultJson.put("selectTable", (Object)tableJson);
            resultJson.put("selectWhere", (Object)this.modifyWhereExpr(tableJson, query, serviceSession));
            return resultJson;
        }
        if (tableSrc instanceof SQLSubqueryTableSource) {
            SQLSelectQueryBlock selectQuery = (SQLSelectQueryBlock)((SQLSubqueryTableSource)tableSrc).getSelect().getQuery();
            tableJson.put("selectField", (Object)this.getSelectField(selectQuery.getSelectList()));
            tableJson.put("selectGroupBy", selectQuery.getGroupBy() == null ? null : selectQuery.getGroupBy().toString());
            JSONObject tempTableJson = this.getTableInfo(selectQuery.getFrom(), selectQuery, serviceSession);
            return tempTableJson;
        }
        if (tableSrc instanceof SQLJoinTableSource) {
            SQLTableSource left = ((SQLJoinTableSource)tableSrc).getLeft();
            SQLTableSource right = ((SQLJoinTableSource)tableSrc).getRight();
            tableJson.put("leftTable", (Object)this.getTableInfo(left, query, serviceSession));
            tableJson.put("rightTable", (Object)this.getTableInfo(right, query, serviceSession));
            tableJson.put("join", (Object)((SQLJoinTableSource)tableSrc).getJoinType());
            return tableJson;
        }
        if (tableSrc instanceof SQLUnionQueryTableSource) {
            SQLUnionQuery selectQuery = ((SQLUnionQueryTableSource)tableSrc).getUnion();
            tableJson.putAll((Map)this.getUnionSqlInfo(selectQuery, 1, serviceSession));
            return tableJson;
        }
        return tableJson;
    }

    private SQLExpr getWhereInfo(String whereSql) {
        SQLStatementParser parser = new SQLStatementParser("select * from dual where " + whereSql);
        SQLStatement stmt = parser.parseStatement();
        SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;
        SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectStmt.getSelect().getQuery();
        return query.getWhere();
    }

    private String modifyWhereExpr(JSONObject tableJson, SQLSelectQueryBlock query, ServiceSession serviceSession) throws Exception {
        Object tableName = tableJson.get((Object)"selectTable");
        Object tableNameAlias = tableJson.get((Object)"selectTableAlias");
        if (tableName == null) {
            tableName = tableJson.get((Object)"leftTable");
            this.modifyWhereExpr((JSONObject)tableName, query, serviceSession);
            tableName = tableJson.get((Object)"rightTable");
            this.modifyWhereExpr((JSONObject)tableName, query, serviceSession);
        } else if (tableName instanceof JSONObject && ((JSONObject)tableName).containsKey((Object)"selectTable") && !(query.getFrom() instanceof SQLSubqueryTableSource)) {
            this.modifyWhereExpr((JSONObject)tableName, query, serviceSession);
        }
        if (tableName != null) {
            String thistable = (String)tableName;
            List<Map<String, String>> authList = this.getdatarange();
            for (Map<String, String> dr : authList) {
                String authTableName = dr.get("tableName");
                if (!thistable.equalsIgnoreCase(authTableName)) continue;
                SQLBinaryOpExpr newWhereExpr = new SQLBinaryOpExpr();
                String authWhereSql = "";
                List<String> inList = null;
                if (dr.get("type").equals("3")) {
                    inList = this.getDataRangeCategory(serviceSession);
                } else if (dr.get("type").equals("1")) {
                    inList = this.getDataRangeShop(serviceSession);
                } else if (dr.get("type").equals("2")) {
                    inList = this.getDataRangeOrg(serviceSession);
                }
                if (inList != null && inList.size() > 0) {
                    StringBuffer authWhereSqlBuffer = new StringBuffer();
                    authWhereSqlBuffer.append("@." + dr.get("columnName")).append(" in (");
                    for (String ref : inList) {
                        authWhereSqlBuffer.append(ref).append(",");
                    }
                    String s = authWhereSqlBuffer.substring(0, authWhereSqlBuffer.length() - 1);
                    authWhereSql = authWhereSql + s + ")";
                    authWhereSql = authWhereSql.replaceAll("@", tableNameAlias == null || tableNameAlias.equals("") ? tableName.toString() : tableNameAlias.toString());
                    SQLExpr authWhereExpr = this.getWhereInfo(authWhereSql);
                    if (query.getWhere() != null && query.getWhere() instanceof SQLBinaryOpExpr) {
                        SQLBinaryOpExpr whereExpr = (SQLBinaryOpExpr)query.getWhere();
                        if (whereExpr != null) {
                            newWhereExpr.setOperator(SQLBinaryOperator.BooleanAnd);
                            newWhereExpr.setLeft((SQLExpr)whereExpr);
                            newWhereExpr.setRight(authWhereExpr);
                        }
                    } else {
                        newWhereExpr = authWhereExpr;
                    }
                } else {
                    newWhereExpr = query.getWhere();
                }
                query.setWhere((SQLExpr)newWhereExpr);
            }
        }
        StringBuffer whereStr = new StringBuffer();
        if (query.getWhere() != null) {
            Object v = null;
            v = query instanceof MySqlSelectQueryBlock ? new MySqlOutputVisitor((Appendable)whereStr) : new SQLASTOutputVisitor((Appendable)whereStr);
            query.getWhere().accept((SQLASTVisitor)v);
        }
        return whereStr.toString();
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        builder.keyProperty(ms.getKeyProperties() == null ? null : ms.getKeyProperties()[0]);
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public Map<String, Object> processParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql) {
        HashMap<String, Object> paramMap = null;
        if (parameterObject == null) {
            paramMap = new HashMap<String, Object>();
        } else if (parameterObject instanceof Map) {
            paramMap = new HashMap();
            paramMap.putAll((Map)parameterObject);
        } else {
            paramMap = new HashMap();
            boolean hasTypeHandler = ms.getConfiguration().getTypeHandlerRegistry().hasTypeHandler(parameterObject.getClass());
            MetaObject metaObject = SystemMetaObject.forObject((Object)parameterObject);
            if (!hasTypeHandler) {
                for (String name : metaObject.getGetterNames()) {
                    paramMap.put(name, metaObject.getValue(name));
                }
            }
            if (boundSql.getParameterMappings() != null && boundSql.getParameterMappings().size() > 0) {
                for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                    String name = parameterMapping.getProperty();
                    if (paramMap.get(name) != null || !hasTypeHandler && !parameterMapping.getJavaType().equals(parameterObject.getClass())) continue;
                    paramMap.put(name, parameterObject);
                    break;
                }
            }
        }
        return paramMap;
    }
}

