/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.slice.filter;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.fastjson.JSONObject;
import com.product.storage.slice.filter.ExecutorCallback;
import com.product.storage.slice.filter.SliceBase;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;

public class CollectionSQLWrapper
extends SliceBase {
    private String dbType;

    protected String getDbType() {
        return this.dbType;
    }

    protected void setDbType(String dbType) {
        this.dbType = dbType;
    }

    protected JSONObject getSqlInfo(SQLSelectQuery selectQuery, ExecutorCallback callback) throws Exception {
        SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectQuery;
        JSONObject tableJson = this.getTableInfo(query.getFrom(), query, callback);
        return tableJson;
    }

    private String getSelectField(List<SQLSelectItem> sqlSelectList) {
        String selectFields = "";
        for (int i = 0; i < sqlSelectList.size(); ++i) {
            SQLSelectItem item = sqlSelectList.get(i);
            if (item.getExpr() instanceof SQLAggregateExpr) {
                SQLAggregateExpr expr = (SQLAggregateExpr)item.getExpr();
                String methodName = expr.getMethodName();
                selectFields = selectFields + methodName + "(";
                List args = expr.getArguments();
                for (int j = 0; j < args.size(); ++j) {
                    selectFields = selectFields + ((SQLExpr)args.get(j)).toString() + ",";
                }
                selectFields = selectFields + ")";
                continue;
            }
            selectFields = item.getExpr() instanceof SQLQueryExpr ? selectFields + item.getExpr() + "," : selectFields + item.getExpr().toString() + ",";
        }
        if (!selectFields.equals("")) {
            selectFields.substring(0, selectFields.length() - 1);
        }
        return selectFields;
    }

    protected JSONObject getUnionSqlInfo(SQLUnionQuery selectQuery, int sqlseq, ExecutorCallback callback) throws Exception {
        JSONObject sqlJson = new JSONObject();
        sqlJson.put("sql" + sqlseq, (Object)this.getSqlInfo(selectQuery.getLeft(), callback));
        ++sqlseq;
        if (selectQuery.getRight() instanceof SQLUnionQuery) {
            sqlJson.putAll((Map)this.getUnionSqlInfo((SQLUnionQuery)selectQuery.getRight(), sqlseq, callback));
        } else if (selectQuery.getRight() instanceof SQLSelectQueryBlock) {
            sqlJson.put("sql" + sqlseq, (Object)this.getSqlInfo(selectQuery.getRight(), callback));
        }
        return sqlJson;
    }

    private JSONObject getTableInfo(SQLTableSource tableSrc, SQLSelectQueryBlock query, ExecutorCallback callback) throws Exception {
        JSONObject tableJson = new JSONObject();
        JSONObject resultJson = new JSONObject();
        if (tableSrc instanceof SQLExprTableSource) {
            SQLExpr expr = ((SQLExprTableSource)tableSrc).getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr expr1 = (SQLIdentifierExpr)expr;
                tableJson.put("selectTable", (Object)expr1.getName());
            } else {
                SQLPropertyExpr expr1 = (SQLPropertyExpr)((SQLExprTableSource)tableSrc).getExpr();
                tableJson.put("selectTable", (Object)expr1.getName());
            }
            tableJson.put("selectTableAlias", (Object)(tableSrc.getAlias() == null ? "" : tableSrc.getAlias()));
            resultJson.put("selectTable", (Object)tableJson);
            resultJson.put("selectWhere", (Object)this.modifyWhereExpr(tableJson, query, callback));
            return resultJson;
        }
        if (tableSrc instanceof SQLSubqueryTableSource) {
            SQLSelectQueryBlock selectQuery = (SQLSelectQueryBlock)((SQLSubqueryTableSource)tableSrc).getSelect().getQuery();
            tableJson.put("selectField", (Object)this.getSelectField(selectQuery.getSelectList()));
            tableJson.put("selectGroupBy", selectQuery.getGroupBy() == null ? null : selectQuery.getGroupBy().toString());
            JSONObject tempTableJson = this.getTableInfo(selectQuery.getFrom(), selectQuery, callback);
            return tempTableJson;
        }
        if (tableSrc instanceof SQLJoinTableSource) {
            SQLTableSource left = ((SQLJoinTableSource)tableSrc).getLeft();
            SQLTableSource right = ((SQLJoinTableSource)tableSrc).getRight();
            tableJson.put("leftTable", (Object)this.getTableInfo(left, query, callback));
            tableJson.put("rightTable", (Object)this.getTableInfo(right, query, callback));
            tableJson.put("join", (Object)((SQLJoinTableSource)tableSrc).getJoinType());
            return tableJson;
        }
        if (tableSrc instanceof SQLUnionQueryTableSource) {
            SQLUnionQuery selectQuery = ((SQLUnionQueryTableSource)tableSrc).getUnion();
            tableJson.putAll((Map)this.getUnionSqlInfo(selectQuery, 1, callback));
            return tableJson;
        }
        return tableJson;
    }

    protected SQLExpr getWhereInfo(String whereSql) {
        SQLStatementParser parser = new SQLStatementParser("select * from test where " + whereSql);
        SQLStatement stmt = parser.parseStatement();
        SQLSelectStatement selectStmt = (SQLSelectStatement)stmt;
        SQLSelectQueryBlock query = (SQLSelectQueryBlock)selectStmt.getSelect().getQuery();
        return query.getWhere();
    }

    private String modifyWhereExpr(JSONObject tableJson, SQLSelectQueryBlock query, ExecutorCallback callback) {
        Object tableName = tableJson.get((Object)"selectTable");
        Object tableNameAlias = tableJson.get((Object)"selectTableAlias");
        if (tableName == null) {
            tableName = tableJson.get((Object)"leftTable");
            this.modifyWhereExpr((JSONObject)tableName, query, callback);
            tableName = tableJson.get((Object)"rightTable");
            this.modifyWhereExpr((JSONObject)tableName, query, callback);
        } else if (tableName instanceof JSONObject && ((JSONObject)tableName).containsKey((Object)"selectTable") && !(query.getFrom() instanceof SQLSubqueryTableSource)) {
            this.modifyWhereExpr((JSONObject)tableName, query, callback);
        }
        if (tableName != null && callback != null) {
            String thistable = (String)tableName;
            callback.onAction(query, thistable, tableNameAlias.toString());
        }
        StringBuffer whereStr = new StringBuffer();
        if (query.getWhere() != null) {
            Object v = null;
            v = query instanceof OracleSelectQueryBlock ? new OracleOutputVisitor((Appendable)whereStr) : new SQLASTOutputVisitor((Appendable)whereStr);
            query.getWhere().accept((SQLASTVisitor)v);
        }
        return whereStr.toString();
    }

    protected MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length > 0) {
            builder.keyProperty(ms.getKeyProperties()[0]);
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }
}

